'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH icmp n "" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
icmp \- Send ICMP messages to hosts on the Internet.
.BE

.SH DESCRIPTION
The \fBicmp\fR command allows to send Internet Control Messages (ICMP)
(RFC 792, RFC 1122) to a list of hosts on the Internet. ICMP messages
can be used to check whether hosts are reachable. The \fBicmp
command\fR can also be used to trace routes to Internet hosts by
sending UDP datagrams to unused UDP ports and interpreting the ICMP
responses (Van Jacobsen and Steve Deering algorithm).

.SH ICMP COMMAND
The \fBicmp\fR command always accepts a list of target hosts. ICMP
messages are send to the targets in a round-robin fashion which allows
to check entire IP address ranges or a list of core routers
efficiently. The user of the \fBicmp\fR command should be careful not
to flood a network with ICMP requests.
.TP
\fBicmp\fR [\fIoptions\fR]
Invoking the \fBicmp\fR command with options but without any command
arguments allows to retrieve and change the default values. See the
description of supported options below. Default values are bound
to a Tcl interpreter which allows to have multiple Tcl interpreter
with different defaults.
.TP
\fBicmp\fR [\fIoptions\fR] \fBecho\fR \fIhosts\fR
The \fBicmp echo\fR command can be used to test the reachability of IP
devices by sending ICMP echo requests to the \fIhosts\fR.  The command
returns a list of host / round trip time pairs. The round trip time is
returned in milliseconds. A negative round trip time indicates that a
host did not respond in the timeout interval.
.TP
\fBicmp\fR [\fIoptions\fR] \fBmask\fR \fIhosts\fR
The \fBicmp mask\fR command sends ICMP mask requests and returns a
list of host / netmask pairs. The mask will be set to 0.0.0.0 if a
host does not respond to ICMP mask requests.
.TP
\fBicmp\fR [\fIoptions\fR] \fBtimestamp\fR \fIhosts\fR
The \fBicmp timestamp\fR command retrieves timestamps using the ICMP
timestamp request. This command returns an estimate of the time
difference between local time and the time on the hosts given in
\fIhosts\fR. The command returns a list of host / time offset
pairs. The time offset is returned in milliseconds. An empty time
offset indicates that a host did not respond in the timeout interval.
.TP
\fBicmp\fR [\fIoptions\fR] \fBttl\fR \fInum\fR \fIhosts\fR
The \fBicmp ttl\fR command, which may not be supported on every
operating system, sends a UDP packet to an unused port number with the
time to live field of the IP header set to \fInum\fR. This command
returns a list of host / round trip time pairs, where the host is the
IP device being \fInum\fR hops away. The round trip time is returned
in milliseconds. A negative round trip time indicates that a host did
not respond in the timeout interval.
.TP
\fBicmp\fR [\fIoptions\fR] \fBtrace\fR \fInum\fR \fIhosts\fR
The \fBicmp trace\fR command works similar to the \fBicmp ttl\fR
command but it always returns the destination address even when the
responding host chooses another interface with a different IP address
to send the reply. This can be used to trace a route to a host since
the command returns the host that discards the packet if it does not
reach the destination.

.SH ICMP OPTIONS
The following options control how ICMP requests are send and how the icmp
command deals with lost ICMP packets.
.TP
.BI "-timeout " time
The \fB-timeout\fR option defines the time the \fBicmp command\fR will
wait for a response. The \fItime\fR is defined in seconds with a
default of 5 seconds.
.TP
.BI "-retries " number
The \fB-retries\fR option defines how many times a request is
retransmitted during the timeout interval. The default \fInumber\fR of
retries is 2.
.TP
.BI "-delay " time
The \fB-delay\fR option defines the minimum delay between two outgoing
ICMP packets. The delay \fItime\fR is defined in milliseconds with a
default delay of 0 milliseconds. Delays are useful to reduce the load
on intermediate devices like gateways or bridges.
.TP
.BI "-size " number
The \fB-size\fR option allows to control the size of ICMP packets. The
\fInumber\fR defines the size of ICMP packets in bytes with a default
size of 64 bytes. Sizes smaller than 64 bytes are silently rounded to
64 bytes.

.SH BUGS
The \fBicmp\fR command requires the setuid root program ntping(8)
because sending icmp packets requires access to raw sockets on
most operating systems.

.SH SEE ALSO
scotty(1), ntping(8), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@cs.utwente.nl>
.br
