/*
  $Id: debug.h,v 1.8 1996/08/20 14:55:31 luik Exp $

  debug.h - omirrd debug module definitions.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef DEBUG_H_INCLUDED
#define DEBUG_H_INCLUDED

#include <stdio.h>

#ifdef	__cplusplus
extern "C" {
#endif

/* debug levels */
#define DEBUG_GENERAL	(1L << 0)
#define DEBUG_DAEMON	(1L << 1) /* process structure, fork etc. */
#define DEBUG_SOCK	(1L << 2) /* debug msgs from socket operations */
#define DEBUG_CF	(1L << 3) /* debug msgs from config file handling */
#define DEBUG_DPROT	(1L << 4) /* protocol from master omirrd -> slave */
#define DEBUG_PROT	(1L << 5) /* protocol from omirrk -> omirrd */
#define DEBUG_CONN	(1L << 6) /* debug omirrd TCP connections */
#define DEBUG_KPROT	(1L << 7) /* protocol from kernel -> omirrk */
#define DEBUG_INAME	(1L << 8) /* debug msgs from inode-to-name assoc cache */
#define DEBUG_OP	(1L << 9) /* slave file operations */

#ifdef DEBUG
#include "omirrd.h"		/* for debug_flag */
#define debug(L)	(debug_flag & (L))
#define debuglog(L,M)	if (!debug(L)) ; else printf M
#else
#define debug(L)	0
#define debuglog(L,M)	/* as nothing */
#endif /* defined(DEBUG) */

/* debug.c */
#ifdef DEBUG
extern int debugParseLevels(char *optstring, unsigned long *setp, char **unknown_argsp);
#endif

#ifdef	__cplusplus
}
#endif

#endif /* DEBUG_H_INCLUDED */

