/*
    jail 1.04
    Copyright 1998 Abhijit Menon-Sen <crab@wiw.org>
*/

#include "icmplog.h"

int background(void)
{
    int fd, fs;

    if (getppid() != -1) {
        signal(SIGTTOU, SIG_IGN);
        signal(SIGTTIN, SIG_IGN);
        signal(SIGTSTP, SIG_IGN);
        if ((fs = fork()) < 0) { perror("fork"); exit(-1); }
        if (fs > 0)          { exit(0); }
        setpgrp();
        fd=open("/dev/tty", O_RDWR);
        if (fd >= 0) {
            ioctl(fd, TIOCNOTTY, (char *)NULL);
            close(fd);
        }
    }
    for (fd = 0; fd<NOFILE; ++fd) { close(fd); }
    errno=0;
    chdir("/");
    umask(0);
    return 0;
}

/*
  given an address, returns a hostname or IP according to the global variable
  resolve_names.
*/
char *gethost(unsigned long int in)
{
    static char host[1024];
    struct hostent *h;
    struct in_addr i;

    i.s_addr=in;
    if (resolve_names) {
        h=gethostbyaddr((char *)&i, sizeof(struct in_addr), AF_INET);
        if (h == NULL) { strcpy(host, inet_ntoa(i)); }
        else           { strcpy(host, h->h_name); }
    }
    else { strcpy(host, inet_ntoa(i)); }
    return host;
}

/*
  Given a string like:
  ignore (0), inform (6), notify (5) and warn (4), returns the numeric value.
*/
int level(char *str)
{
    if (strncmp(str, "ignore", 6) == 0) { return 0; }
    if (strncmp(str, "inform", 6) == 0) { return 6; }
    if (strncmp(str, "notify", 6) == 0) { return 5; }
    if (strncmp(str,   "warn", 4) == 0) { return 4; }
    else { return strtol(str, NULL, 10); }
}

/*
  Handles parsing the configuration file and updating values.
*/
void configure(char *file, int dfl)
{
    char buf[MAXLINE];
    FILE *rc;
    int i = 0;

    if ((rc = fopen(file, "r")) == NULL) {
        if (!dfl) { perror(file); exit(1); }
    }

    while (fgets(buf, MAXLINE-1, rc)) {
        if (buf[0] == '#' || strlen(buf) == 0) { continue; }

        if (strncmp(buf, "default", 7) == 0) {
            strtok(buf, " \t\n");
            tbl[MAX_ICMP_TYPE+1].act = level(strtok(NULL, " \t\n"));
            continue;
        }

        for (i = 0; i <= MAX_ICMP_TYPE; ++i) {
            if (strncmp(buf, cfg[i], strlen(cfg[i])) == 0) {
                strtok(buf, " \t\n");
                tbl[i].act = level(strtok(NULL, " \t\n"));
                break;
            }
        }

        memset(buf, 0, MAXLINE);
    }
}

int main(int argc, char *argv[])
{
    char *rc=NULL, *host;
    int c=0, s=0, index=0, type=0;
    struct protoent *icmp;

    if (geteuid() != 0) {
        printf("%s: root privileges required.\n",argv[0]);
        exit(1);
    }

    while (1) {
        c=getopt_long(argc, argv, "f:nv", opts, &index);
        if (c == -1) { break; }
        switch (c) {
        case 0: switch (index) {
                case 0: rc=optarg; break;
                case 1: resolve_names=0; break;
                case 2: printf("jail 1.04 <crab@wiw.org>\n"); exit(0); break;
                }
                break;
        case 'f': rc=optarg; break;
        case 'n': resolve_names=0; break;
        case 'v': printf("jail 1.04 <crab@wiw.org>\n"); exit(0); break;
        default : printf ("options: --file, --no-resolve, --version\n");
                  exit(1);
        }
    }

    if (rc == NULL) { configure("/etc/icmplog.conf", 1); }
    else            { configure(rc, 0); }

    if ((icmp = getprotobyname("icmp")) == NULL) {
        perror("getprotobyname");
        exit(1);
    }

    background();
    if ((s = socket(AF_INET, SOCK_RAW, icmp->p_proto)) < 0) {
        perror("socket");
        exit(1);
    }
    openlog("icmplog", 0, LOG_DAEMON);
    syslog(LOG_INFO, "running");
    while (1) {
        read(s, (struct ippkt *)&p, 9999);
        host = gethost(p.ip.saddr);
        type = p.icmp.type;
        if (p.ip.ihl != 5) {
            syslog(LOG_WARNING, "bad options from %s", host);
            continue;
        }
        if (type > MAX_ICMP_TYPE) {
            syslog(tbl[MAX_ICMP_TYPE+1].act, "undefined icmp %d from %s", host);
            continue;
        }
        if (tbl[type].act) {
            syslog(tbl[type].act, "%s from %s", tbl[type].name, host);
        }
    }
}
