
/*
 * Reconstruction of the TCP header structure, as shown in the linux/tcp.h
 * file, for little-endian machines.
 */
 
#ifndef _I386_TYPES_H
#include <asm/types.h>
#endif

struct tcphdr {
	__u16	source;
	__u16	dest;
	__u32	seq;
	__u32	ack_seq;
	__u16	res1:4,
		doff:4,
		fin:1,
		syn:1,
		rst:1,
		psh:1,
		ack:1,
		urg:1,
		res2:2;
	__u16	window;
	__u16	check;
	__u16	urg_ptr;
};

