/**************************************************************************
 * LPRng IFHP Filter
 * Copyright 1994-1997 Patrick Powell, San Diego, CA <papowell@sdsu.edu>
 *
 * Based on the CTI printer filters.
 *  See COPYRIGHT for details.
 *
 * $Id: ifhp.c,v 2.4 1997/01/21 04:14:51 papowell Exp $
 */

#include "portable.h"
#include "common.h"
#include "hp4.h"

static const char *const idallf = "@(#) Computer Technology Institute, CTI-Print Project";
static const char *const idhp4 = "@(#)       Filter for HP LaserJet 4, V 1.2 \n" ;
static const char *const idifhp4 = "@(#) ifhp4.c 95/08/23 - V 1.15" ;

int main(argc,argv,envp)
int argc;
char *argv[];
char *envp[];
{
	int acnt_fd;
	unsigned long starttime, endtime;
	int elapsed;

	Envp = envp;
	debug = 2;

	/* save the PID */
	starttime = time( (void *)0 );
	filterpid = getpid();

	acnt_fd = Accounting_fd = dup(3);
	if( Accounting_fd >= 0 ){
		close( Accounting_fd );
		Accounting_fd = 3;
	}
	getargs( argc, argv );

	get_info();
	errorcode = FILTABORT;
	plp_snprintf(job_start,sizeof(job_start)-1,
		"NAME=\"Start of CTI-Print Job: %d\"",getpid());
	plp_snprintf(job_end,sizeof(job_start)-1,
		"NAME=\"End of CTI-Print Job: %d\"", getpid() );


	(void)signal(SIGINT, cleanup);
	(void)signal(SIGHUP, cleanup);
	(void)signal(SIGTERM, cleanup);
	(void)signal(SIGQUIT, cleanup);
	(void)signal(SIGPIPE, SIG_IGN);

	/* open device if specified */
	if( device ) open_device();

	log(4,"ifhp: get_status %d", get_status );
#if defined(F_GETFL)
	if( get_status ){
		int status;
		log(4,"ifhp: trying fcntl" );
		status = fcntl( 1, F_GETFL );
		log(4,"ifhp: fcntl returned 0x%x, O_RDWR = 0x%x", status, O_RDWR );
		if( (status & O_RDWR) == 0 ){
			log(4,"ifhp: cannot read stdout, not getting status" );
			get_status = 0;
		}
	}
#endif

	/* set up the initialization of the printer, and start monitoring */
	do_monitor();

	if( of_filter ){
		log(2,"Starting of_filter actions");
		do_of_stream(stdin, STDOUT );
	} else {
		sendjob(0, STDOUT );
	}

	/* terminate job */
	header_info();

	if( monitpid > 0 ) {
		int pid, status;
		log(3,"stopping monitor %d", monitpid);
		kill(monitpid,SIGTERM);
		kill(monitpid,SIGCONT);
		pid = waitpid( monitpid, &status, 0 );
		log(3,"ifhp: monitor %d exit status %d", pid, status );
	}

	/* get the status and end of job */
	if( get_status ){
		if( sync_printer ) check_job_end();
		if( pagecount ){
			npages = pr_pagecount(STDOUT);
			if( npages == 0 ){
				log (2, "Pagecount 0 using PJL INFO.");
			}
		}
		if (npages == 0 || forcepagecount ) {
			npages = pr_pspagecount(STDOUT);
			if (npages == 0)  {
				log (2, "Pagecount 0 using PostScript");
			}
		}
	}
	endtime = time( (void *)0 );
	elapsed = endtime - starttime;
	log(2,"Initial page count %d, final %d, Total pages = %d, elapsed time %d secs",
		initialpagecount, npages, npages - initialpagecount, elapsed );
	doaccnt(0);

	fexit(FILTSUCC);
	return( 0 );
}
