/*
 *  This file is part of x48, an emulator of the HP-48sx Calculator.
 *  Copyright (C) 1994  Eddie C. Dost  (ecd@dressler.de)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Log: hp48char.h,v $
 * Revision 1.3  1995/01/11  18:20:01  ecd
 * major update to support HP48 G/GX
 *
 * Revision 1.2  1994/12/07  20:16:41  ecd
 * added comment at top of file
 *
 * Revision 1.2  1994/12/07  20:16:41  ecd
 * added comment at top of file
 *
 * Revision 1.1  1994/12/07  10:16:15  ecd
 * Initial revision
 *
 *
 * $Id: hp48char.h,v 1.3 1995/01/11 18:20:01 ecd Exp ecd $
 */
#ifndef _HP48CHAR_H
#define _HP48CHAR_H	1

typedef struct trans_tbl_t {
  unsigned char  hp48_char;
  char          *trans;
} trans_tbl_t;

#ifndef DEFINE_TRANS_TABLE
extern trans_tbl_t hp48_trans_tbl[256];
#else
trans_tbl_t hp48_trans_tbl[256] =
{
  { 0, "\\0" },
  { 1, "\\001" },
  { 2, "\\002" },
  { 3, "\\003" },
  { 4, "\\004" },
  { 5, "\\005" },
  { 6, "\\006" },
  { 7, "\\007" },
  { 8, "\\b" },
  { 9, "\\t" },
  { 10, "\\n" },
  { 11, "\\011" },
  { 12, "\\f" },
  { 13, "\\r" },
  { 14, "\\014" },
  { 15, "\\015" },
  { 16, "\\016" },
  { 17, "\\017" },
  { 18, "\\018" },
  { 19, "\\019" },
  { 20, "\\020" },
  { 21, "\\021" },
  { 22, "\\022" },
  { 23, "\\023" },
  { 24, "\\024" },
  { 25, "\\025" },
  { 26, "\\026" },
  { 27, "\\027" },
  { 28, "\\028" },
  { 29, "\\029" },
  { 30, "\\030" },
  { 31, "\\031" },
  { ' ', 0 },
  { '!', 0 },
  { '"', 0 },
  { '#', 0 },
  { '$', 0 },
  { '%', 0 },
  { '&', 0 },
  { '\'', 0 },
  { '(', 0 },
  { ')', 0 },
  { '*', 0 },
  { '+', 0 },
  { ',', 0 },
  { '-', 0 },
  { '.', 0 },
  { '/', 0 },
  { '0', 0 },
  { '1', 0 },
  { '2', 0 },
  { '3', 0 },
  { '4', 0 },
  { '5', 0 },
  { '6', 0 },
  { '7', 0 },
  { '8', 0 },
  { '9', 0 },
  { ':', 0 },
  { ';', 0 },
  { '<', 0 },
  { '=', 0 },
  { '>', 0 },
  { '?', 0 },
  { '@', 0 },
  { 'A', 0 },
  { 'B', 0 },
  { 'C', 0 },
  { 'D', 0 },
  { 'E', 0 },
  { 'F', 0 },
  { 'G', 0 },
  { 'H', 0 },
  { 'I', 0 },
  { 'J', 0 },
  { 'K', 0 },
  { 'L', 0 },
  { 'M', 0 },
  { 'N', 0 },
  { 'O', 0 },
  { 'P', 0 },
  { 'Q', 0 },
  { 'R', 0 },
  { 'S', 0 },
  { 'T', 0 },
  { 'U', 0 },
  { 'V', 0 },
  { 'W', 0 },
  { 'X', 0 },
  { 'Y', 0 },
  { 'Z', 0 },
  { '[', 0 },
  { '\\', 0 },
  { ']', 0 },
  { '^', 0 },
  { '_', 0 },
  { '`', 0 },
  { 'a', 0 },
  { 'b', 0 },
  { 'c', 0 },
  { 'd', 0 },
  { 'e', 0 },
  { 'f', 0 },
  { 'g', 0 },
  { 'h', 0 },
  { 'i', 0 },
  { 'j', 0 },
  { 'k', 0 },
  { 'l', 0 },
  { 'm', 0 },
  { 'n', 0 },
  { 'o', 0 },
  { 'p', 0 },
  { 'q', 0 },
  { 'r', 0 },
  { 's', 0 },
  { 't', 0 },
  { 'u', 0 },
  { 'v', 0 },
  { 'w', 0 },
  { 'x', 0 },
  { 'y', 0 },
  { 'z', 0 },
  { '{', 0 },
  { '|', 0 },
  { '}', 0 },
  { '~', 0 },
  { 127, "\\127" },
  { 128, "\\<)" },
  { 129, "\\x-" },
  { 130, "\\.V" },
  { 131, "\\v/" },
  { 132, "\\.S" },
  { 133, "\\GS" },
  { 134, "\\|>" },
  { 135, "\\pi" },
  { 136, "\\.d" },
  { 137, "\\<=" },
  { 138, "\\>=" },
  { 139, "\\=/" },
  { 140, "\\Ga" },
  { 141, "\\->" },
  { 142, "\\<-" },
  { 143, "\\|v" },
  { 144, "\\|^" },
  { 145, "\\Gg" },
  { 146, "\\Gd" },
  { 147, "\\Ge" },
  { 148, "\\Gn" },
  { 149, "\\Gh" },
  { 150, "\\Gl" },
  { 151, "\\Gr" },
  { 152, "\\Gs" },
  { 153, "\\Gt" },
  { 154, "\\Gw" },
  { 155, "\\GD" },
  { 156, "\\PI" },
  { 157, "\\GW" },
  { 158, "\\[]" },
  { 159, "\\oo" },
  { 160, "\\160" },
  { 161, "\\161" },
  { 162, "\\162" },
  { 163, "\\163" },
  { 164, "\\164" },
  { 165, "\\165" },
  { 166, "\\166" },
  { 167, "\\167" },
  { 168, "\\168" },
  { 169, "\\169" },
  { 170, "\\170" },
  { 171, "\\<<" },
  { 172, "\\172" },
  { 173, "\\173" },
  { 174, "\\174" },
  { 175, "\\175" },
  { 176, "\\^o" },
  { 177, "\\177" },
  { 178, "\\178" },
  { 179, "\\179" },
  { 180, "\\180" },
  { 181, "\\Gm" },
  { 182, "\\182" },
  { 183, "\\183" },
  { 184, "\\184" },
  { 185, "\\185" },
  { 186, "\\186" },
  { 187, "\\>>" },
  { 188, "\\188" },
  { 189, "\\189" },
  { 190, "\\190" },
  { 191, "\\191" },
  { 192, "\\192" },
  { 193, "\\193" },
  { 194, "\\194" },
  { 195, "\\195" },
  { 196, "\\196" },
  { 197, "\\197" },
  { 198, "\\198" },
  { 199, "\\199" },
  { 200, "\\200" },
  { 201, "\\201" },
  { 202, "\\202" },
  { 203, "\\203" },
  { 204, "\\204" },
  { 205, "\\205" },
  { 206, "\\206" },
  { 207, "\\207" },
  { 208, "\\208" },
  { 209, "\\209" },
  { 210, "\\210" },
  { 211, "\\211" },
  { 212, "\\212" },
  { 213, "\\213" },
  { 214, "\\214" },
  { 215, "\\.x" },
  { 216, "\\O/" },
  { 217, "\\217" },
  { 218, "\\218" },
  { 219, "\\219" },
  { 220, "\\220" },
  { 221, "\\221" },
  { 222, "\\222" },
  { 223, "\\223" },
  { 224, "\\224" },
  { 225, "\\225" },
  { 226, "\\226" },
  { 227, "\\227" },
  { 228, "\\228" },
  { 229, "\\229" },
  { 230, "\\230" },
  { 231, "\\231" },
  { 232, "\\232" },
  { 233, "\\233" },
  { 234, "\\234" },
  { 235, "\\235" },
  { 236, "\\236" },
  { 237, "\\237" },
  { 238, "\\238" },
  { 239, "\\239" },
  { 240, "\\240" },
  { 241, "\\241" },
  { 242, "\\242" },
  { 243, "\\243" },
  { 244, "\\244" },
  { 245, "\\245" },
  { 246, "\\246" },
  { 247, "\\:-" },
  { 248, "\\248" },
  { 249, "\\249" },
  { 250, "\\250" },
  { 251, "\\251" },
  { 252, "\\252" },
  { 253, "\\253" },
  { 254, "\\254" },
  { 255, "\\255" }
};
#endif /* DEFINE_TRANS_TABLE */

#endif /* !_HP48CHAR_H */
