\name{poly.value}
\title{Evaluate a Polynomial}
\usage{
poly.value(p, x, nam = as.character(x))
}
\arguments{
\item{p}{An object of class polynomial}
\item{x}{A numeric vector of x-values}
\item{nam}{An optional names vector for the result}
}
\description{
Given an object of class polynomial, evaluate the polynomial represented
at a vector of x-values.

The horner scheme is used to evaluate the polynomial, but numerical
difficulties can still arise, expecially with high degree polynomials.

The argument \code{x} may also be another polynomial, in which case a
polynomial substitution is done and the result is another polynomial. 
}
\value{
A vector of polynomial values.
}
\seealso{
as.function.polynomial
}
\examples{
pr <- poly.from.zeros(1:5)
poly.value(pr, 0:6)
##     0 1 2 3 4 5   6 
##  -120 0 0 0 0 0 120
prf <- as.function(pr)
prf(0:6, nam = NULL)
## [1] -120    0    0    0    0    0  120
}
