\name{make.character.polynomial}
\title{Construct a Character String from a
Polynomial}
\usage{
make.character(p, variable = "x", style = c("ordinary", "horner"))
}
\arguments{
\item{p}{An object of class polynomial}
\item{variable}{Name for the independent variable to be used in the
character string}
\item{style}{Indicator to prescribe either truncated power series
(ordinary) or recursive expansion (horner) form.}
}
\description{
Essentially a coercion method function from objects of class polynomial
to a character string, but with slightly more flexibility than is
possible with a method under the system \code{as.character} generic.

Used mainly in \code{as.function.polynomial}, but may be useful in other
contexts.
}
\value{
An object of mode character.
}
\seealso{
as.function.polynomial
}
\examples{
pr <- 
pr
-120 + 274*x - 225*x^2 + 85*x^3 - 15*x^4 + x^5 
make.character(pr, variable=y, style="o")
## [1] "-120 + 274*y - 225*y^2 + 85*y^3 - 15*y^4 + y^5"
make.character(pr, variable="z", style="h")
## [1] "-120 + z * (274 + z * (-225 + z * (85 + z * (-15 + z * (1)))))"
}
