#include <math.h>
extern char *S_alloc();

void rational(x, n, length, maxdenom, a, b)
long *n, *length, *maxdenom;
double *x, *a, *b;
/*
 *      a[i]/b[i] gives a continued fraction approximation to x[i]
 *      using up to `length'  terms, each less than `maxdenom'
 */
{
long m = *n, k, len = *length;
double bot, top, tmp, *d = (double *) S_alloc((unsigned) len, sizeof(double)),
        maxd = (double) *maxdenom;
    while (m--)
    {
        tmp = *x++;
        for (k = 0; k < len; k++)
        {
            d[k] = floor(tmp + 0.5e0);
            tmp = tmp - d[k];
            if (fabs(tmp) * maxd <= 1.0e0)
                break;
            tmp = 1.0e0 / tmp;
        };
        top = d[k];
        bot = 1.0e0;
        while (k-- > 0)
        {
            tmp = top;
            top = d[k] * top + bot;
            bot = tmp;
        };
        if (bot < 0.0e0)
        {
            top = -top;
            bot = -bot;
        }
        *a++ = top;
        *b++ = bot;
    }
}
