/*								-*- C++ -*-
 * $Id: WIN_multitext.h,v 1.1 1996-09-25 11:07:06+02 mho Exp $
 *
 * Purpose: multi text panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef MultiText_h
#define MultiText_h

#ifdef __GNUG__
#pragma interface
#endif

class wxPanel;

class wxMultiText : public wxText {
DECLARE_DYNAMIC_CLASS(wxMultiText)
public:
    wxMultiText(void);
    wxMultiText(wxPanel *panel, wxFunction func, Const char *label,
		Constdata char *value=wxEmptyString,
		int x=-1, int y=-1, int width=-1, int height=-1,
		long style=0, Constdata char *name=wxMultiTextNameStr);
    
    Bool Create(wxPanel *panel, wxFunction func, Const char *label,
		Constdata char *value=wxEmptyString,
		int x=-1, int y=-1, int width=-1, int height=-1,
		long style=0, Constdata char *name=wxMultiTextNameStr);

    char *GetValue(void) { return wxText::GetValue(); }
    void GetValue(char *buffer, int size);
    void Scroll(int x, int y);
    // override event handlers
    void OnChar(wxKeyEvent& event);
    void OnPaint(void);
    void OnSize(int width, int height);
    void OnScroll(wxCommandEvent& event);
protected:
    void AdjustScrollbars(void);
protected:
    #ifdef Have_Xt_Types
    long FirstPosition(void);
    long FirstVisiblePosition(void);
    long LastVisiblePosition(void);
    long LastPosition(void);

    int  LineForPosition(long);
    int  LastLine(void);
    int  TopLine(void);
    Bool LineAndXYForPosition(long, int*, Position*, Position*);
    #endif
private:
    #ifdef Have_Xt_Types
    static void EventCallback(Widget, XtPointer, XtPointer);
    #endif
};

#endif // MultiText_h
