/*								-*- C++ -*-
 * $Id: UTL_date+time.cpp,v 1.1 1996-09-25 11:31:48+02 mho Exp $
 *
 * Purpose: time and date related functions
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#include "wx_setup.h"

#define  Uses_XLib
#include "wx.h"

#ifdef SVR4
#ifndef SYSV
#define SYSV
#endif
#endif

#include <signal.h>
#include <sys/time.h>
#ifndef sgi
#include <sys/timeb.h>
#endif
#include <sys/types.h>
#include <time.h>
#include <unistd.h>

#if defined(sun) || defined(__osf__)
// At least on Sun, ftime is undeclared.
// Need to be verified on other platforms.
extern "C" int ftime(struct timeb *tp);
// extern "C" time_t time(time_t);
// #include <sys/timeb.h>
#ifdef SVR4
// dito for gettimeofday on Solaris 2.x.
extern "C" int gettimeofday(struct timeval *tp, void *);
#endif
#endif

/*
 * sleep for nSecs seconds
 */

void wxSleep(int nSecs)
{
#if defined(__sgi)
    sleep(nSecs);
#else
#if defined(SVR4)
    sigset_t oldmask, mask;
    timeval tv;

    tv.tv_sec = nSecs;
    tv.tv_usec = 0;

    sigemptyset (&mask);
    sigaddset (&mask, SIGIO);
    sigaddset (&mask, SIGALRM);
    sigprocmask (SIG_BLOCK, &mask, &oldmask);
    if ((select (0, 0, 0, 0, &tv)) == -1) {
	perror ("select in wxSleep");
    }
    sigprocmask (SIG_SETMASK, &oldmask, (sigset_t *) NULL);
#else
    int oldmask, mask;
    struct timeval tv;

    tv.tv_sec = nSecs;
    tv.tv_usec = 0;

    mask = sigmask (SIGIO);
    mask |= sigmask (SIGALRM);
    oldmask = sigblock (mask);
    if ((select (0, 0, 0, 0, &tv)) == -1) {
	perror ("select in wxSleep");
    }
    sigsetmask (oldmask);
#endif
#endif // __sgi
}

/*
 * current time
 */

char *wxNow(void)
{
    time_t now = time(NULL);
    char *date = ctime(&now); 
    date[24] = '\0';
    return date;
}


/*
 * start timer
 */

long wxStartTime = 0;

void wxStartTimer(void)
{
#if defined(__xlC__) || defined(_AIX) || defined(SVR4) || defined(SYSV) // || defined(AIXV3)
    struct timeval tp;
#ifdef SYSV
    gettimeofday(&tp, (struct timezone *)NULL);
#else
    gettimeofday(&tp);
#endif
    wxStartTime = 1000*tp.tv_sec + tp.tv_usec/1000;
#elif (defined(__SC__) || defined(__sgi) || defined(__bsdi__) || defined(__alpha))
    time_t t0;
    struct tm *tp;
    time(&t0);
    tp = localtime(&t0);
    wxStartTime = 1000*(60*(60*tp->tm_hour+tp->tm_min)+tp->tm_sec);
#else
    struct timeb tp;
    ftime(&tp);
    wxStartTime = 1000*tp.time + tp.millitm;
#endif
}

/*
 * return time since start of timer in milliseconds
 */

long wxGetElapsedTime(Bool resetTimer)
{
#if defined(__xlC__) || defined(_AIX) || defined(SVR4) || defined(SYSV) // || defined(AIXV3)
    struct timeval tp;
#ifdef SYSV
    gettimeofday(&tp, (struct timezone *)NULL);
#else
    gettimeofday(&tp);
#endif
    long oldTime = wxStartTime;
    long newTime = 1000*tp.tv_sec + tp.tv_usec / 1000;
    if (resetTimer)
	wxStartTime = newTime;
#elif (defined(__SC__) || defined(__sgi) || defined(__bsdi__) || defined(__alpha))
    time_t t0;
    struct tm *tp;
    time(&t0);
    tp = localtime(&t0);
    long oldTime = wxStartTime;
    long newTime = 1000*(60*(60*tp->tm_hour+tp->tm_min)+tp->tm_sec);
    if (resetTimer)
	wxStartTime = newTime;
#else
    struct timeb tp;
    ftime(&tp);
    long oldTime = wxStartTime;
    long newTime = 1000*tp.time + tp.millitm;
    if (resetTimer)
	wxStartTime = newTime;
#endif
    return newTime - oldTime;
}

/*
 * get local time for time zone
 */

// EXPERIMENTAL: comment this out if it doesn't compile.
Bool wxGetLocalTime(long *timeZone, int *dstObserved)
{
#if ((defined(SYSV) && !defined(hpux)) || defined(__MSDOS__) || defined(wx_msw))
#ifdef __BORLANDC__
    /* Borland uses underscores */
    *timeZone = _timezone;
    *dstObserved = _daylight;
#else
    *timeZone = timezone;
    *dstObserved = daylight;
#endif
#elif defined(__xlC__) || defined(_AIX) || defined(SVR4) || defined(SYSV) // || defined(AIXV3)
    struct timeval tp;
#ifdef SYSV
    struct timezone tz;
    gettimeofday(&tp, &tz);
    *timeZone = 60*(tz.tz_minuteswest);
    *dstObserved = tz.tz_dsttime;
#else
    time_t t0;
    struct tm *tp;
    time(&t0);
    tp = localtime(&t0);
    *timeZone = tp->tm_gmtoff; // ???
    *dstOberved = tp->tm_isdst;
#endif
#else
    // #error wxGetLocalTime not implemented.
    struct timeval tp;
    struct timezone tz;
    gettimeofday(&tp, &tz);
    *timeZone = 60*(tz.tz_minuteswest);
    *dstObserved = tz.tz_dsttime;
#endif
    return TRUE;
}

/*
 * Get number of seconds since 00:00:00 GMT, Jan 1st 1970.
 */

long wxGetCurrentTime(void)
{
#if defined(__xlC__) || defined(_AIX) || defined(SVR4) || defined(SYSV) // || defined(AIXV3)
    struct timeval tp;
#ifdef SYSV
    gettimeofday(&tp, (struct timezone *)NULL);
#else
    gettimeofday(&tp);
#endif
    return tp.tv_sec;
#else // (defined(__SC__) || defined(__sgi) || defined(__bsdi__) || defined(__alpha))
    return time(0);
#endif
}

