/*								-*- C++ -*-
 * $Id: DLG_choice.cpp,v 1.2 1997-01-30 09:55:45+01 mho Exp $
 *
 * Purpose: dialogs to select or more selection from listboxes
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#define  Uses_wxDialogBase
#define  Uses_wxListBox
#include "wx.h"

int wxGetSingleChoiceIndex(const char *message, const char *caption, int n,
			   char *choices[], wxWindow *parent,
			   int x, int y, Bool centre, int width, int height)
{
    int selection = -1;

    // create dialog box and listbox item
    wxDialogBase *box
	= wxNEW wxDialogBase(message, NULL, caption,
			     (centre ? wxCENTRE : 0) | wxOK | wxCANCEL,
			     parent, x, y);
    wxListBox *lbox
	= wxNEW wxListBox(box, (wxFunction)NULL, NULL, wxSINGLE|wxALWAYS_SB,
			  -1, -1, width, height, n, choices);
    // wait for input
    if (box->GetInput() == wxOK) {
	selection = lbox->GetSelection();
    }
    delete box;
    return selection;
}

char *wxGetSingleChoice(const char *message, const char *caption, int n, char *choices[],
			wxWindow *parent, int x, int y, Bool centre,
			int width, int height)
{
    int selection = wxGetSingleChoiceIndex(message, caption, n, choices,
					   parent, x, y, centre, width,height);
    if (selection > -1)
	return choices[selection];
    return NULL;
}

char *wxGetSingleChoiceData(const char *message, const char *caption, int n,
			    char *choices[], char *client_data[],
			    wxWindow *parent, int x, int y, Bool centre,
			    int width, int height)
{
    int selection = wxGetSingleChoiceIndex(message, caption, n, choices,
					   parent, x, y, centre, width,height);
    if (selection > -1)
	return client_data[selection];
    return NULL;
}

int wxGetMultipleChoice(const char *message, const char *caption, int n, char *choices[],
			int nsel, int *selection, wxWindow *parent,
			int x , int y, Bool centre, int width, int height)
{
    int num_selections = -1;

    // create dialog box and listbox item
    wxDialogBase *box
	= wxNEW wxDialogBase(message, NULL, caption,
			     (centre ? wxCENTRE : 0) | wxOK | wxCANCEL,
			     parent, x, y);
    wxListBox *lbox
	= wxNEW wxListBox(box, (wxFunction)NULL, NULL,
			  wxMULTIPLE|wxEXTENDED|wxALWAYS_SB,
			  -1, -1, width, height, n, choices);
    // initialize lbox
    for (int i=0; i < nsel; i++)
	lbox->SetSelection(selection[i], TRUE);
    // wait for input
    if (box->GetInput() == wxOK) {
	int *selections_internal;
	num_selections = lbox->GetSelections(&selections_internal);
	for(int i=0; i < num_selections; ++i)
	    selection[i] = selections_internal[i];
    }
    delete box;
    return num_selections;
}
