%{
/*
     YABASIC --- a tiny integrated Basic Compiler/Interpreter

     FLEX - part
     
     this Program is subject to the GNU General Public License;
     see the file yabasic.c for details.
*/

#include <string.h>
#undef WINDOWS
#include "bison.h"       /* get tokens from BISON */
#include "yabasic.h"     /* definitions of yabasic */

extern int yylineno;
extern int errorlevel;

void switch_to_my_file(FILE *inputfile); /* switches input to given file */
%}

NAME [A-Za-z][A-za-z0-9]*
%option noyywrap
%x RET

%%
[ \t]* {BEGIN INITIAL;}     /* ignore whitespace */
<RET>[ \t]* {BEGIN INITIAL;} /* still ignore whitespace */

<<EOF>> {return EOFILE;}
<RET>\n {yylineno++;return (interactive) ? EOFILE:SEP;}
<RET>[^\n] {BEGIN INITIAL;unput(yytext[0]);}
\n {yylineno++; BEGIN RET; return SEP;}
: {return SEP;}

REM.*\n {yylineno++; return SEP;}  /* comments span 'til end of line */
^#.*\n {yylineno++; return SEP;} /* '#' can introduce comments too */

FOR return FOR;
TO return TO;
STEP return STEP;
NEXT return NEXT;
GOTO return GOTO;
GOSUB return GOSUB;
ON return ON;
LABEL return LABEL;
IF return IF;
THEN return THEN;
ELSE return ELSE;
ENDIF return ENDIF;
FI return ENDIF;
OPEN return OPEN;
CLOSE return CLOSE;
PRINT return PRINT;
\? return PRINT;
INPUT return INPUT;
RETURN return RETURN;
DIM return DIM;
END return END;
READ return READ;
DATA return DATA;
RESTORE return RESTORE;
AND return AND;
OR return OR;
NOT return NOT;
WINDOW return WINDOW;
PRINTER return PRINTER;
DOT return DOT;
LINE return LINE;
CIRCLE return CIRCLE;
CLEAR return CLEAR;
TEXT return TEXT;
WAIT return WAIT;
PAUSE return WAIT;
BELL return BELL;
BEEP return BELL;

SIN return SIN;
ASIN return ASIN;
COS return COS;
ACOS return ACOS;
TAN return TAN;
ATAN return ATAN;
EXP return EXP;
LOG return LOG;
SQRT return SQRT;
INT return INT;
FRAC return FRAC;
RAN return RAN;
MIN return MIN;
MAX return MAX;
"LEFT$" return LEFT;
"RIGHT$" return RIGHT;
"MID$" return MID;
"LOWER$" return LOWER;
"UPPER$" return UPPER;
INSTR return INSTR;
LEN return LEN;
VAL return VAL;
EOF return MYEOF;
"STR$" return STR;
"INKEY$" return INKEY;
"INKEY$()" return INKEY;
"CHR$" return CHR;
ASC return ASC;
AT return AT;
@ return AT;
SCREEN return SCREEN;
"SYSTEM$" return SYSTEM;
SYSTEM return SYSTEM2;

"<>" return NE;
"<=" return LE;
">=" return GE;
"=" return EQ;
"<" return LT;
">" return GT;

[-+*/:(),.;] {return yytext[0];}

(([0-9]+|([0-9]*\.[0-9]*))([eE][-+]?[0-9]+)?) {
  {float f;
  sscanf(yytext,"%f",&f);
  yylval.number=f;
  return NUMBER;}
}

({NAME}+) {
  yylval.symbol=(char *)my_strdup(yytext);
  return SYMBOL;
}

  /* Symbols with a trailing $-sign are treated special */
({NAME}+"$") {
  yylval.strsym=(char *)my_strdup(yytext);
  return STRSYM;
}

\"([^\"\n]|"\\\"")*\" {
  yylval.string=(char *)my_strdup(yytext+1);
  *(yylval.string+yyleng-2)='\0';
  replace(yylval.string);
  return STRING;
}

\"([^\"\n]|"\\\"")*\n {
  error(ERROR,"String not terminated");
  yylval.string=(char *)my_strdup(yytext);
  yylineno++;
  return STRING;
}

. {return yytext[0];}

%%
void yyerror(char *msg)
{
  int n;
  char c=' ';	
  
  sprintf(string,"%s at %n",msg,&n);
  if (*yytext=='\n') 
    sprintf(string+n,"end of line");
  else 
    sprintf(string+n,"'%s'",yytext);
  error(ERROR,string);

  if (c!=' ') unput(c); /* stop gcc from complaining about yyunput ... */

  return;
}

void switch_to_my_file(FILE *inputfile) /* switches lex input to given file */
{
  YY_BUFFER_STATE my_buffer;

  my_buffer=yy_create_buffer(inputfile,YY_BUF_SIZE);
  yy_switch_to_buffer(my_buffer);

  return;
}

