// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  XDROp.h

  Stephane Rehel
  August 4 1996
*/

#ifndef __XDROp_h
#define __XDROp_h

#ifndef __IBOOL_h
#include "tools/IBOOL.h"
#endif

class OString;

/////////////////////////////////////////////////////////////////////////////

class XDROp
{
protected:
  void* xdr; // actually XDR* (avoid including headers...)
  IBOOL error;

public:
  XDROp();
  virtual ~XDROp();

  IBOOL getError() const
    {
    return error;
    }

public:

  void putByte( char b );
  void putChar( char ch );
  void putUChar( unsigned char ch );
  void putInteger( int i );
  void putUInteger( unsigned int i );
  void putShort( short i );
  void putUShort( unsigned short i );
  void putLong( long l );
  void putULong( unsigned long l );
  void putFloat( float f );
  void putDouble( double d );
  void putString( const OString& s );

  XDROp& operator << ( char c )          { putChar(c); return *this; }
  XDROp& operator << ( unsigned char c ) { putUChar(c); return *this; }
  XDROp& operator << ( int i )           { putInteger(i); return *this; }
  XDROp& operator << ( unsigned int i )  { putUInteger(i); return *this; }
  XDROp& operator << ( short i )         { putShort(i); return *this; }
  XDROp& operator << ( unsigned short i ){ putUShort(i); return *this; }
  XDROp& operator << ( long l )          { putLong(l); return *this; }
  XDROp& operator << ( unsigned long l ) { putULong(l); return *this; }
  XDROp& operator << ( float f )         { putFloat(f); return *this; }
  XDROp& operator << ( double d )        { putDouble(d); return *this; }
  XDROp& operator << ( const OString& s ){ putString(s); return *this; }

  void getByte( char* b );
  void getChar( char* ch );
  void getUChar( unsigned char* ch );
  void getInteger( int* i );
  void getUInteger( unsigned int* i );
  void getShort( short* i );
  void getUShort( unsigned short* i );
  void getLong( long* l );
  void getULong( unsigned long* l );
  void getFloat( float* f );
  void getDouble( double* d );
  void getString( OString* s );

  XDROp& operator >> ( char& c )          { getChar(&c); return *this; }
  XDROp& operator >> ( unsigned char& c ) { getUChar(&c); return *this; }
  XDROp& operator >> ( int& i )           { getInteger(&i); return *this; }
  XDROp& operator >> ( unsigned int& i )  { getUInteger(&i); return *this; }
  XDROp& operator >> ( short& i )         { getShort(&i); return *this; }
  XDROp& operator >> ( unsigned short& i ){ getUShort(&i); return *this; }
  XDROp& operator >> ( long& l )          { getLong(&l); return *this; }
  XDROp& operator >> ( unsigned long& l ) { getULong(&l); return *this; }
  XDROp& operator >> ( float& f )         { getFloat(&f); return *this; }
  XDROp& operator >> ( double& d )        { getDouble(&d); return *this; }
  XDROp& operator >> ( OString& s )       { getString(&s); return *this; }
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __XDROp_h
