// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  TmplCanvas.C

  Stephane Rehel

  October 19 1997
*/

#include "tools/file/MLWFileBlock.h"
#include "tools/file/MLRFileBlock.h"

#include "TmplCanvas.h"
#include "TmplModule.h"

#include "engines/TmplEColored.h"
#include "engines/TmplERed.h"
#include "engines/TmplEGreen.h"
#include "engines/TmplEBlue.h"

/////////////////////////////////////////////////////////////////////////////

TmplCanvas::TmplCanvas()
{
  coloredEngine= 0;
  redEngine= 0;
  greenEngine= 0;
  blueEngine= 0;
}

/////////////////////////////////////////////////////////////////////////////

TmplCanvas::~TmplCanvas()
{
  coloredEngine= 0;
  redEngine= 0;
  greenEngine= 0;
  blueEngine= 0;
}

/////////////////////////////////////////////////////////////////////////////

void TmplCanvas::create( MLModule* _module, int _where )
{
  MLCanvas::create(_module,_where);

  coloredEngine= new TmplEColored(this);
  coloredEngine->updatePopupsFlags();

  redEngine= new TmplERed(this);
  redEngine->updatePopupsFlags();

  greenEngine= new TmplEGreen(this);
  greenEngine->updatePopupsFlags();

  blueEngine= new TmplEBlue(this);
  blueEngine->updatePopupsFlags();

  MLCanvas::addEngine( coloredEngine );
  MLCanvas::addEngine( redEngine );
  MLCanvas::addEngine( greenEngine );
  MLCanvas::addEngine( blueEngine );

  activateDefaultEngine();
}

/////////////////////////////////////////////////////////////////////////////

void TmplCanvas::refreshScreen( unsigned what )
{
  if( MLCanvas::engine == 0 )
    return;

  ((TmplEngine*)MLCanvas::engine)->refreshScreen(what);
}

/////////////////////////////////////////////////////////////////////////////

void TmplCanvas::write( MLWFileBlock& block )
{
  MLCanvas::write(block);
  block << int(0);
}

/////////////////////////////////////////////////////////////////////////////

void TmplCanvas::read( MLRFileBlock& block )
{
  MLCanvas::read(block);
  if( block.getInteger() == 0 )
    return;
}

/////////////////////////////////////////////////////////////////////////////

void TmplCanvas::activateDefaultEngine()
{
  int index= ((TmplModule*)module)->getCanvasIndex(this);

  switch( index )
    {
    case 1: MLCanvas::activateEngine( redEngine->getID() );
            break;
    case 2: MLCanvas::activateEngine( blueEngine->getID() );
            break;
    case 3: MLCanvas::activateEngine( coloredEngine->getID() );
            break;
    case 4: MLCanvas::activateEngine( greenEngine->getID() );
            break;
    default:
      break;
    }
}

/////////////////////////////////////////////////////////////////////////////

void TmplCanvas::resetAll()
{
  MLCanvas::resetAll();

  activateDefaultEngine();
}

/////////////////////////////////////////////////////////////////////////////
