// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
   MLVertex.C

   Stephane Rehel
   November 11 1996
*/

#include <string.h>

#include "MLVertex.h"
#include "MLEdge.h"
#include "MeshRep.h"

/////////////////////////////////////////////////////////////////////////////

int MLVertex::getSizeOf() const
{
  return  sizeof(*this)
        + nEdges * sizeof(edges[0])
        + nPolygons * sizeof(polygons[0])
        + nSVertices * sizeof(svertices[0]);
}

/////////////////////////////////////////////////////////////////////////////

void MLVertex::gob( const MLVertex& v )
{
  delete edges;
  delete polygons;
  delete svertices;

  point= v.point;

  nEdges= v.nEdges;
  edges= new int [ nEdges ];
  memcpy( (void*) edges,
          (const void*) v.edges,
          sizeof(edges[0]) * nEdges );

  nPolygons= v.nPolygons;
  polygons= new int [ nPolygons ];
  memcpy( (void*) polygons,
          (const void*) v.polygons,
          sizeof(polygons[0]) * nPolygons );

  nSVertices= v.nSVertices;
  svertices= new int [ nSVertices ];
  memcpy( (void*) svertices,
          (const void*) v.svertices,
          sizeof(svertices[0]) * nSVertices );

  flags= v.flags;
}

/////////////////////////////////////////////////////////////////////////////

void MLVertex::unallocate()
{
  delete edges; edges= 0; nEdges= 0;
  delete polygons; polygons= 0; nPolygons= 0;
  delete svertices; svertices= 0; nSVertices= 0;

  flags &= ~Flag(ALLOCATED);
}

/////////////////////////////////////////////////////////////////////////////

// Find edge from this vertex (v1) to vertex v2
// return edge index (>=1) if found
// return 0 if not found
int MLVertex::findEdge( MeshRep* mesh, int v1, int v2 ) const
{
  int* ei= edges;
  for( int i= 0; i < nEdges; ++i, ++ei )
    {
    MLEdge& e= mesh->edges[*ei];
    if( (e.v1==v1 && e.v2==v2) || (e.v1==v2 && e.v2==v1) )
      return *ei;
    }

  return 0;
}

/////////////////////////////////////////////////////////////////////////////

void MLVertex::addEdge( int ei )
{
  if( ei < 1 )
    return; // crazy?

  int new_nEdges= nEdges + 1;
  int* new_edges= new int [ new_nEdges ];

  memcpy( (void*) new_edges,
          (const void*) edges,
          sizeof(int) * nEdges );

  new_edges [ nEdges ] = ei;

  nEdges= new_nEdges;
  edges= new_edges;
}

/////////////////////////////////////////////////////////////////////////////
