// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
   MLEdge.C

   Stephane Rehel
   November 11 1996
*/

#include "MLEdge.h"
#include "MLPolygon.h"
#include "MeshRep.h"

/////////////////////////////////////////////////////////////////////////////

int MLEdge::getSizeOf() const
{
  return sizeof(*this);
}

/////////////////////////////////////////////////////////////////////////////

// test if this a discontinuity edge
void MLEdge::computeDisc( MeshRep* mesh )
{
  if( polygon1 == 0 || polygon2 == 0 )
    {
    flags &= ~Flag(DISC);
    flags |= Flag(BORDER);
    return;
    }

  flags &= ~Flag(BORDER);

  MLPolygon& p1= mesh->polygons[polygon1];
  MLPolygon& p2= mesh->polygons[polygon2];

  float cos_a;

  if( p1.material != p2.material )
    goto disc;

  cos_a= (p1.normal | p2.normal);
  if( cos_a <= mesh->cos_discAngle )
    goto disc;

  flags &= ~Flag(DISC);
  return;

disc:
  flags |= Flag(DISC);
}

/////////////////////////////////////////////////////////////////////////////

void MLEdge::gob( const MLEdge& e )
{
  v1= e.v1;
  v2= e.v2;
  polygon1= e.polygon1;
  polygon2= e.polygon2;
  flags= e.flags;
}

/////////////////////////////////////////////////////////////////////////////

void MLEdge::unallocate()
{
  flags &= ~Flag(ALLOCATED);
}

/////////////////////////////////////////////////////////////////////////////
