// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  popupCommand.C

  void PhotoModule::handlePopupCommand( int label );

  Stephane Rehel

  OCtober 19 1997
*/

#include "PhotoModule.h"

#include "kw/KWDialog.h"

#include "interface/MLInterfaceCommand.h"
#include "interface/MLPopup.h"

#include "PhotoCommand.h"
#include "PhotoCommands.h"

#include "PhotoPopups.h"

#include "photo/photo/Photo.h"

#include "gdialogs/PTDOpen.h"

/////////////////////////////////////////////////////////////////////////////

void PhotoModule::handlePopupCommand( int label )
{
  if( label == popups->open )
    {
    PTDOpen o(this);
    o.run();
    return;
    }

#ifndef NDEBUG
  if( label == popups->photo_open_test )
    {
    PhotoCommand* cmd= new PhotoCommand;
    cmd->type= PhotoCommands::LOAD_IMAGE;
    cmd->string= "/home/kepler/maps/valley.jpg";
    post(cmd);
    return;
    }
#endif

  if( label == popups->quit )
    {
    MLInterfaceCommand* icmd= new MLInterfaceCommand;
    icmd->type= MLInterfaceCommand::QUIT;
    icmd->post();
    return;
    }

}

/////////////////////////////////////////////////////////////////////////////
