// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  OOMStatusBars.C

  Stephane Rehel

  October 19 1997
*/

#include "interface/MLStatusBars.h"
#include "interface/MLStatusLine.h"
#include "interface/MLStatusLineText.h"
#include "interface/MLStatusLineButton.h"

#include "OOMCommand.h"
#include "OOMCommands.h"
#include "OOMModule.h"

#include "OOMStatusBars.h"

/////////////////////////////////////////////////////////////////////////////

OOMStatusBars::OOMStatusBars( OOMModule* _oom,
                                MLStatusBars* _statusBars )
{
  oom= _oom;
  statusBars= _statusBars;

  modeInfo= 0;
  message= 0;
  single_multiple= 0;
}

/////////////////////////////////////////////////////////////////////////////

OOMStatusBars::~OOMStatusBars()
{
  modeInfo= 0;
  message= 0;
  single_multiple= 0;
}

/////////////////////////////////////////////////////////////////////////////

void OOMStatusBars::init()
{
  if( oom == 0 || statusBars == 0 )
    return;

  message= new MLStatusLineText( oom,
                                 statusBars->getLine1(),
                                 0,
                                 MLStatusLineItem::LEFT, ITRUE );

//(new MLStatusLineButton( statusBars->getLine1(),
//                         3, MLStatusLineItem::RIGHT, IFALSE ))->
//setMessage("ABC");

  modeInfo= new MLStatusLineText( oom,
                                  statusBars->getLine2(),
                                  0,
                                  MLStatusLineItem::LEFT, ITRUE );

  single_multiple= new MLStatusLineButton( oom,
                                           statusBars->getLine2(),
                                           3,
                                           MLStatusLineItem::RIGHT, IFALSE);
  single_multiple->setActionHandler(this);

  statusBars->getLine1()->finalize();
  statusBars->getLine2()->finalize();

  single_multiple->printMessage("SGL");

  update();
}

/////////////////////////////////////////////////////////////////////////////

void OOMStatusBars::update()
{
  if( oom == 0 || statusBars == 0 )
    return;

  if( single_multiple != 0 )
    single_multiple->setPressed(IFALSE);
}

/////////////////////////////////////////////////////////////////////////////

IBOOL OOMStatusBars::handleAction( MLAction* action )
{
  if( oom == 0 )
    return IFALSE;

  if( action == single_multiple )
    {
    OOMCommand* cmd= new OOMCommand;
    cmd->type= OOMCommands::PRESS_IT;

    oom->post(cmd);

    return ITRUE;
    }

  return IFALSE;
}

/////////////////////////////////////////////////////////////////////////////
