// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  MLCSetVariable.h

  Stephane Rehel

  November 1st 1997
*/

#ifndef __MLCSetVariable_h
#define __MLCSetVariable_h

#ifndef __Transform_h
#include "tools/Transform.h"
#endif

#ifndef __ModelCommand_h
#include "model/ModelCommand.h"
#endif

#ifndef __MLTagVertexArray_h
#include "model/MLTagVertexArray.h"
#endif

class ModelModule;

/////////////////////////////////////////////////////////////////////////////

class MLCSetVariable: public ModelCommand
{
public:
  int variable_id; // from ModelFlags::VARIABLE_NAME

public:
  MLCSetVariable();

  MLCSetVariable( int _variable_id, int yes );

  virtual ~MLCSetVariable();

  virtual IBOOL doit( ModelModule* model );
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __MLCSetVariable_h
