/*
  main.C

  Copyright (C) 1997-1998  Stephane Rehel

  December 14 1997
*/

#include <stdio.h>
#include <GL/gl.h>

#include "MLRawReader.h"

/////////////////////////////////////////////////////////////////////////////

int main( int argc, char* argv[] )
{
  if( argc != 2 )
    {
    fprintf( stderr, "Usage:\n"
                     "%s <file.mlraw>\n",
                     argv[0] );
    return 1;
    }

  const char* filename= argv[1];

  FILE* file= fopen(filename,"r");
  if( file == 0 )
    {
    fprintf( stderr, "unable to open file %s\n", filename );
    return 1;
    }

  bool verbose= TRUE;

  MLRawReader raw(file,verbose);

  if( ! raw.read() )
    {
    fprintf( stderr, "error reading file %s\n", filename );
    return 1;
    }

  fprintf( stderr, "successfully read\n" );

  fclose(file);

  return 0;
}

/////////////////////////////////////////////////////////////////////////////

void draw_it( MLRawReader::Object* o,
              int nPools, float* pool_factors )
{
  if( o == 0 )
    return;

  for( int i= 0; i < o->nPolygons; ++i )
    {
    MLRawReader::Polygon& p= o->polygons[i];

    glBegin(GL_POLYGON);
    for( int j= 0; j < p.nVertices; ++j )
      {
      MLRawReader::Vertex& v= o->vertices[ p.vertices[j] ];

      if( nPools > 0 )
        {
        MLRawReader::Spectrum s;
        s.r= 0.;
        s.g= 0.;
        s.b= 0.;
        for( int k= 0; k < nPools; ++k )
          {
          s.r+= pool_factors[k] * v.lighting[k].r;
          s.g+= pool_factors[k] * v.lighting[k].g;
          s.b+= pool_factors[k] * v.lighting[k].b;
          }

        glColor3f( s.r, s.g, s.b );
        }

      glNormal3f( v.nx, v.ny, v.nz );
      glVertex3f( v.x, v.y, v.z );
      }
    glEnd();
    }
}

/////////////////////////////////////////////////////////////////////////////

void draw_it( MLRawReader* rr,
              int nPools, float* pool_factors )
{
  if( rr == 0 )
    return;

  for( int i= 0; i < rr->getNObjects(); ++i )
    {
    MLRawReader::Object* o= rr->getObject(i);
    if( o == 0 )
      continue;

    draw_it( o, nPools, pool_factors );
    }
}

/////////////////////////////////////////////////////////////////////////////
