#include "Imlib.h"
#include "Imlib_private.h"

void calc_map_tables(ImlibData *id, ImlibImage *im)
{
   int    i;
   double g,b,c,ii,v;
   
   if (!im) return;

   g=((double)im->mod.gamma)/256;
   b=((double)im->mod.brightness)/256;
   c=((double)im->mod.contrast)/256;
   if (g<0.01) g=0.01;
   for(i=0;i<256;i++)
     {
	ii=((double)i)/256;
	v=((ii-0.5)*c)+0.5+(b-1);
	if (v>0) v=pow(((ii-0.5)*c)+0.5+(b-1),1/g)*256;
	else v=0;
	if (v>255) v=255;
	else if (v<0) v=0;
	im->rmap[i]=(unsigned char)v;
	im->gmap[i]=(unsigned char)v;
	im->bmap[i]=(unsigned char)v;
     }
   g=((double)im->rmod.gamma)/256;
   b=((double)im->rmod.brightness)/256;
   c=((double)im->rmod.contrast)/256;
   if (g<0.01) g=0.01;
   for(i=0;i<256;i++)
     {
	ii=((double)im->rmap[i])/256;
	v=((ii-0.5)*c)+0.5+(b-1);
	if (v>0) v=pow(((ii-0.5)*c)+0.5+(b-1),1/g)*256;
	else v=0;
	if (v>255) v=255;
	else if (v<0) v=0;
	im->rmap[i]=(unsigned char)v;
     }
   g=((double)im->gmod.gamma)/256;
   b=((double)im->gmod.brightness)/256;
   c=((double)im->gmod.contrast)/256;
   if (g<0.01) g=0.01;
   for(i=0;i<256;i++)
     {
	ii=((double)im->gmap[i])/256;
	v=((ii-0.5)*c)+0.5+(b-1);
	if (v>0) v=pow(((ii-0.5)*c)+0.5+(b-1),1/g)*256;
	else v=0;
	if (v>255) v=255;
	else if (v<0) v=0;
	im->gmap[i]=(unsigned char)v;
     }
   g=((double)im->bmod.gamma)/256;
   b=((double)im->bmod.brightness)/256;
   c=((double)im->bmod.contrast)/256;
   if (g<0.01) g=0.01;
   for(i=0;i<256;i++)
     {
	ii=((double)im->bmap[i])/256;
	v=((ii-0.5)*c)+0.5+(b-1);
	if (v>0) v=pow(((ii-0.5)*c)+0.5+(b-1),1/g)*256;
	else v=0;
	if (v>255) v=255;
	else if (v<0) v=0;
	im->bmap[i]=(unsigned char)v;
     }
   dirty_pixmaps(id,im);
}

int Imlib_load_file_to_pixmap(ImlibData *id, char *filename, Pixmap *pmap, Pixmap *mask)
{
   ImlibImage *im;
   
   im=Imlib_load_image(id,filename);
   if (!im) 
     {
	if (pmap) *pmap=0;
	if (mask) *mask=0;
	return 0;
     }
   if (!Imlib_render(id,im,im->rgb_width,im->rgb_height))
     {
	Imlib_destroy_image(id,im);
	if (pmap) *pmap=0;
	if (mask) *mask=0;
	return 0;
     }
   if (pmap) *pmap=Imlib_move_image(id,im);
   if (mask) *mask=Imlib_move_mask(id,im);
   Imlib_destroy_image(id,im);
   return 1;
}

void Imlib_set_image_modifier(ImlibData *id, ImlibImage *im, ImlibColorModifier *mod)
{
   if ((!im)|(!mod)) return;
   im->mod.gamma=mod->gamma;
   im->mod.brightness=mod->brightness;
   im->mod.contrast=mod->contrast;
   calc_map_tables(id,im);
}

void Imlib_set_image_red_modifier(ImlibData *id, ImlibImage *im, ImlibColorModifier *mod)
{
   if ((!im)|(!mod)) return;
   im->rmod.gamma=mod->gamma;
   im->rmod.brightness=mod->brightness;
   im->rmod.contrast=mod->contrast;
   calc_map_tables(id,im);
}

void Imlib_set_image_green_modifier(ImlibData *id, ImlibImage *im, ImlibColorModifier *mod)
{
   if ((!im)|(!mod)) return;
   im->gmod.gamma=mod->gamma;
   im->gmod.brightness=mod->brightness;
   im->gmod.contrast=mod->contrast;
   calc_map_tables(id,im);
}

void Imlib_set_image_blue_modifier(ImlibData *id, ImlibImage *im, ImlibColorModifier *mod)
{
   if ((!im)|(!mod)) return;
   im->bmod.gamma=mod->gamma;
   im->bmod.brightness=mod->brightness;
   im->bmod.contrast=mod->contrast;
   calc_map_tables(id,im);
}

void Imlib_get_image_modifier(ImlibData *id, ImlibImage *im, ImlibColorModifier *mod)
{
   if ((!im)|(!mod)) return;
   mod->gamma=im->mod.gamma;
   mod->brightness=im->mod.brightness;
   mod->contrast=im->mod.contrast;
   calc_map_tables(id,im);
}

void Imlib_get_image_red_modifier(ImlibData *id, ImlibImage *im, ImlibColorModifier *mod)
{
   if ((!im)|(!mod)) return;
   mod->gamma=im->rmod.gamma;
   mod->brightness=im->rmod.brightness;
   mod->contrast=im->rmod.contrast;
}

void Imlib_get_image_green_modifier(ImlibData *id, ImlibImage *im, ImlibColorModifier *mod)
{
   if ((!im)|(!mod)) return;
   mod->gamma=im->gmod.gamma;
   mod->brightness=im->gmod.brightness;
   mod->contrast=im->gmod.contrast;
}

void Imlib_get_image_blue_modifier(ImlibData *id, ImlibImage *im, ImlibColorModifier *mod)
{
   if ((!im)|(!mod)) return;
   mod->gamma=im->bmod.gamma;
   mod->brightness=im->bmod.brightness;
   mod->contrast=im->bmod.contrast;
}

void Imlib_set_image_red_curve(ImlibData *id, ImlibImage *im, unsigned char *mod)
{
   int i;
   
   if ((!im)||(!mod)) return;
   for(i=0;i<256;i++) im->rmap[i]=mod[i];
   dirty_pixmaps(id,im);
   im->mod.contrast=257;
}

void Imlib_set_image_green_curve(ImlibData *id, ImlibImage *im, unsigned char *mod)
{
   int i;
   
   if ((!im)||(!mod)) return;
   for(i=0;i<256;i++) im->gmap[i]=mod[i];
   dirty_pixmaps(id,im);
   im->mod.contrast=257;
}

void Imlib_set_image_blue_curve(ImlibData *id, ImlibImage *im, unsigned char *mod)
{
   int i;
   
   if ((!im)||(!mod)) return;
   for(i=0;i<256;i++) im->bmap[i]=mod[i];
   dirty_pixmaps(id,im);
   im->mod.contrast=257;
}

void Imlib_get_image_red_curve(ImlibData *id, ImlibImage *im, unsigned char *mod)
{
   int i;
   
   if ((!im)||(!mod)) return;
   for(i=0;i<256;i++) mod[i]=im->rmap[i];
}

void Imlib_get_image_green_curve(ImlibData *id, ImlibImage *im, unsigned char *mod)
{
   int i;
   
   if ((!im)||(!mod)) return;
   for(i=0;i<256;i++) mod[i]=im->gmap[i];
}

void Imlib_get_image_blue_curve(ImlibData *id, ImlibImage *im, unsigned char *mod)
{
   int i;
   
   if ((!im)||(!mod)) return;
   for(i=0;i<256;i++) mod[i]=im->bmap[i];
}

void Imlib_apply_modifiers_to_rgb(ImlibData *id, ImlibImage *im)
{
   int x,y;
   unsigned char *ptr;
   
   if (!im) return;
   ptr=im->rgb_data;
   for (y=0;y<im->rgb_height;y++)
     {
	for(x=0;x<im->rgb_width;x++)
	  {
	     *ptr=im->rmap[*ptr++];
	     *ptr=im->gmap[*ptr++];
	     *ptr=im->bmap[*ptr++];
	  }
     }
   im->mod.gamma=256;
   im->mod.brightness=256;
   im->mod.contrast=256;
   im->rmod.gamma=256;
   im->rmod.brightness=256;
   im->rmod.contrast=256;
   im->gmod.gamma=256;
   im->gmod.brightness=256;
   im->gmod.contrast=256;
   im->bmod.gamma=256;
   im->bmod.brightness=256;
   im->bmod.contrast=256;
   calc_map_tables(id,im);
   dirty_images(id,im);
   dirty_pixmaps(id,im);
}

void Imlib_crop_image(ImlibData *id, ImlibImage *im, int x, int y, int w, int h)
{
   unsigned char *data;
   int xx,yy,w3,w4;
   unsigned char *ptr1,*ptr2;

   if (!im) return;
   if (x<0) 
     {
	w+=x;
	x=0;
     }
   if (y<0) 
     {
	h+=y;
	y=0;
     }
   if (x>=im->rgb_width) return;
   if (y>=im->rgb_height) return;
   if (w<=0) return;
   if (h<=0) return;
   if (x+w>im->rgb_width) w=im->rgb_width-x;
   if (y+h>im->rgb_height) h=im->rgb_height-y;
   if (w<=0) return;
   if (h<=0) return;

   w3=im->rgb_width*3;
   w4=(im->rgb_width-w)*3;
   data=malloc(w*h*3);
   ptr1=im->rgb_data+(y*w3)+(x*3);
   ptr2=data;
   for(yy=0;yy<h;yy++)
     {
	for(xx=0;xx<w;xx++)
	  {
	     *ptr2++=*ptr1++;
	     *ptr2++=*ptr1++;
	     *ptr2++=*ptr1++;
	  }
	ptr1+=w4;
     }
   free(im->rgb_data);
   im->rgb_data=data;
   if (im->border.left>x) im->border.left=im->border.left-x;
   else im->border.left=0;
   if (im->border.top>y) im->border.top=im->border.top-y;
   else im->border.top=0;
   if (im->rgb_width-im->border.right<x+w) 
     im->border.right=im->border.right-(im->rgb_width-(x+w));
   else im->border.right=0;
   if (im->rgb_height-im->border.bottom<y+h) 
     im->border.bottom=im->border.bottom-(im->rgb_height-(y+h));
   else im->border.bottom=0;
   im->rgb_width=w;
   im->rgb_height=h;
   dirty_images(id,im);
   dirty_pixmaps(id,im);
}

void Imlib_changed_image(ImlibData *id, ImlibImage *im)
{
   if (!im) return;
   dirty_images(id,im);
   dirty_pixmaps(id,im);
}

void Imlib_apply_image(ImlibData *id, ImlibImage *im, Window p)
{
   Pixmap pp,mm;
   int x,y;
   unsigned int w,h,bd,d;
   Window ww;
   
   if ((!im)||(!p)) return;
   XGetGeometry(id->x.disp,p,&ww,&x,&y,&w,&h,&bd,&d);
   if ((w<=0)||(h<=0)) return;
   Imlib_render(id,im,w,h);
   pp=Imlib_move_image(id,im);
   mm=Imlib_move_mask(id,im);
   XSetWindowBackgroundPixmap(id->x.disp,p,pp);
   if (mm) XShapeCombineMask(id->x.disp,p,ShapeBounding,0,0,mm,ShapeSet);
   else XShapeCombineMask(id->x.disp,p,ShapeBounding,0,0,0,ShapeSet);
   XClearWindow(id->x.disp,p);
   Imlib_free_pixmap(id,pp);
}

void Imlib_paste_image(ImlibData *id, ImlibImage *im, Window p, int x, int y, int w, int h)
{
   GC gc;
   XGCValues gcv;
   Pixmap pp,mm;
   
   if ((!im)||(!p)) return;
   if ((w<=0)||(h<=0)) return;
   gc=XCreateGC(id->x.disp,p,0,&gcv);
   Imlib_render(id,im,w,h);
   pp=Imlib_move_image(id,im);
   mm=Imlib_move_mask(id,im);
   if (mm)
     {
	XSetClipMask(id->x.disp,gc,mm);
	XSetClipOrigin(id->x.disp,gc,x,y);
     }
   XCopyArea(id->x.disp,pp,p,gc,0,0,w,h,x,y);
   Imlib_free_pixmap(id,pp);
   XFreeGC(id->x.disp,gc);
}

void Imlib_paste_image_border(ImlibData *id, ImlibImage *im, Window p, int x, int y, int w, int h)
{
   GC gc;
   XGCValues gcv;
   Pixmap pp,mm;
   
   if (!im) return;
   if ((w<=0)||(h<=0)) return;
   gc=XCreateGC(id->x.disp,p,0,&gcv);
   Imlib_render(id,im,w,h);
   pp=Imlib_move_image(id,im);
   mm=Imlib_move_mask(id,im);
   if (mm)
     {
	XSetClipMask(id->x.disp,gc,mm);
	XSetClipOrigin(id->x.disp,gc,x,y);
     }
   if ((w<=(im->border.left+im->border.right))||
       (h<=(im->border.top+im->border.bottom)))
     XCopyArea(id->x.disp,pp,p,gc,0,0,w,h,x,y);
   else
     {
	XCopyArea(id->x.disp,pp,p,gc,0,0,w,im->border.top,x,y);
	XCopyArea(id->x.disp,pp,p,gc,0,0,w,im->border.bottom,x,y+(h-im->border.bottom));
	XCopyArea(id->x.disp,pp,p,gc,0,0,im->border.left,h-(im->border.top+im->border.bottom),x,y+im->border.top);
	XCopyArea(id->x.disp,pp,p,gc,0,0,im->border.right,h-(im->border.top+im->border.bottom),x+(w-im->border.right),y+(h-im->border.bottom));
     }
   Imlib_free_pixmap(id,pp);
   XFreeGC(id->x.disp,gc);
}

void Imlib_flip_image_horizontal(ImlibData *id, ImlibImage *im)
{
   unsigned char *ptr1,*ptr2,r,rr;
   int x,y;
   int w3;

   if (!im) return;
   w3=im->rgb_width*3;
   for(y=0;y<im->rgb_height;y++)
     {
	ptr1=im->rgb_data+(y*w3);
	ptr2=im->rgb_data+(y*w3)+w3-3;
	for(x=0;x<im->rgb_width>>1;x++)
	  {
	     r=*ptr1;rr=*ptr2;*ptr2++=r;*ptr1++=rr;
	     r=*ptr1;rr=*ptr2;*ptr2++=r;*ptr1++=rr;
	     r=*ptr1;rr=*ptr2;*ptr2=r;*ptr1++=rr;
	     ptr2-=5;
	  }
     }
   w3=im->border.left;
   im->border.left=im->border.right;
   im->border.right=w3;
   dirty_images(id,im);
   dirty_pixmaps(id,im);
}

void Imlib_flip_image_vertical(ImlibData *id, ImlibImage *im)
{
   unsigned char *ptr1,*ptr2,r,rr;
   int x,y,yy;
   int w3;
   
   if (!im) return;
   w3=im->rgb_width*3;
   for(yy=im->rgb_height-1,y=0;y<im->rgb_height>>1;y++,yy--)
     {
	ptr1=im->rgb_data+(y*w3);
	ptr2=im->rgb_data+(yy*w3);
	for(x=0;x<im->rgb_width;x++)
	  {
	     r=*ptr1;rr=*ptr2;*ptr2++=r;*ptr1++=rr;
	     r=*ptr1;rr=*ptr2;*ptr2++=r;*ptr1++=rr;
	     r=*ptr1;rr=*ptr2;*ptr2++=r;*ptr1++=rr;
	  }
     }
   w3=im->border.top;
   im->border.top=im->border.bottom;
   im->border.bottom=w3;
   dirty_images(id,im);
   dirty_pixmaps(id,im);
}

void Imlib_rotate_image(ImlibData *id, ImlibImage *im, int d)
{
   unsigned char *data;
   int x,y,w3,w4;
   unsigned char *ptr1,*ptr2;

   if (!im) return;
   w3=im->rgb_width*3;
   w4=im->rgb_height*3;
   data=malloc(im->rgb_width*im->rgb_height*3);
   for(y=0;y<im->rgb_height;y++)
     {
	ptr1=im->rgb_data+(y*w3);
	ptr2=data+(y*3);
	for(x=0;x<im->rgb_width;x++)
	  {
	     *ptr2++=*ptr1++;
	     *ptr2++=*ptr1++;
	     *ptr2=*ptr1++;
	     ptr2+=w4-2;
	  }
     }
   free(im->rgb_data);
   im->rgb_data=data;
   w3=im->rgb_width;
   im->rgb_width=im->rgb_height;
   im->rgb_height=w3;
   w3=im->border.top;
   im->border.top=im->border.left;
   im->border.left=w3;
   w3=im->border.bottom;
   im->border.bottom=im->border.right;
   im->border.right=w3;
   dirty_images(id,im);
   dirty_pixmaps(id,im);
}

ImlibImage *Imlib_create_image_from_data(ImlibData *id, unsigned char *data, unsigned char *alpha, int w, int h)
{
   ImlibImage *im;
   char s[1024];
   
   if ((!data)||(w<=0)||(h<=0)) return NULL;
   im=malloc(sizeof(ImlibImage));
   if (!im) return NULL;
   im->rgb_width=w;
   im->rgb_height=h;
   im->rgb_data=malloc(im->rgb_width*im->rgb_height*3);
   if (!im->rgb_data)
     {
	free(im);
	return NULL;
     }
   memcpy(im->rgb_data,data,im->rgb_width*im->rgb_height*3);
/*   im->alpha_data=alpha;*/
   im->alpha_data=NULL;
   sprintf(s,"creat_%x_%x",(int)time(NULL),(int)rand());
   im->filename=malloc(strlen(s)+1);
   strcpy(im->filename,s);
   im->width=0;
   im->height=0;
   im->shape_color.r=-1;
   im->shape_color.g=-1;
   im->shape_color.b=-1;
   im->border.left=0;
   im->border.right=0;
   im->border.top=0;
   im->border.bottom=0;
   im->pixmap=0;
   im->shape_mask=0;
   im->cache=1;
   im->mod.gamma=id->mod.gamma;
   im->mod.brightness=id->mod.brightness;
   im->mod.contrast=id->mod.contrast;
   im->rmod.gamma=id->rmod.gamma;
   im->rmod.brightness=id->rmod.brightness;
   im->rmod.contrast=id->rmod.contrast;
   im->gmod.gamma=id->gmod.gamma;
   im->gmod.brightness=id->gmod.brightness;
   im->gmod.contrast=id->gmod.contrast;
   im->bmod.gamma=id->bmod.gamma;
   im->bmod.brightness=id->bmod.brightness;
   im->bmod.contrast=id->bmod.contrast;
   if (id->cache.on_image) add_image(id,im,im->filename);
   calc_map_tables(id,im);
   return im;
}

ImlibImage *Imlib_clone_image(ImlibData *id, ImlibImage *im)
{
   ImlibImage *im2;
   char s[1024];
   
   if (!im) return NULL;
   im2=malloc(sizeof(ImlibImage));
   if (!im2) return NULL;
   im2->rgb_width=im->rgb_width;
   im2->rgb_height=im->rgb_height;
   im2->rgb_data=malloc(im2->rgb_width*im2->rgb_height*3);
   if (!im2->rgb_data)
     {
	free(im2);
	return NULL;
     }
   memcpy(im2->rgb_data,im->rgb_data,im2->rgb_width*im2->rgb_height*3);
   if (im->alpha_data)
     {
	im2->alpha_data=malloc(im2->rgb_width*im2->rgb_height);
	if (!im2->alpha_data)
	  {
	     free(im2->rgb_data);
	     free(im2);
	     return NULL;
	  }
	memcpy(im2->alpha_data,im->alpha_data,im2->rgb_width*im2->rgb_height);
     }
   else im2->alpha_data=NULL;
   sprintf(s,"%s_%x_%x",im->filename,(int)time(NULL),(int)rand());
   im2->filename=malloc(strlen(s)+1);
   strcpy(im2->filename,s);
   im2->width=0;
   im2->height=0;
   im2->shape_color.r=im->shape_color.r;
   im2->shape_color.g=im->shape_color.g;
   im2->shape_color.b=im->shape_color.b;
   im2->border.left=im->border.left;
   im2->border.right=im->border.right;
   im2->border.top=im->border.top;
   im2->border.bottom=im->border.bottom;
   im2->pixmap=0;
   im2->shape_mask=0;
   im2->cache=1;
   im2->mod.gamma=im->mod.gamma;
   im2->mod.brightness=im->mod.brightness;
   im2->mod.contrast=im->mod.contrast;
   im2->rmod.gamma=im->rmod.gamma;
   im2->rmod.brightness=im->rmod.brightness;
   im2->rmod.contrast=im->rmod.contrast;
   im2->gmod.gamma=im->gmod.gamma;
   im2->gmod.brightness=im->gmod.brightness;
   im2->gmod.contrast=im->gmod.contrast;
   im2->bmod.gamma=im->bmod.gamma;
   im2->bmod.brightness=im->bmod.brightness;
   im2->bmod.contrast=im->bmod.contrast;
   calc_map_tables(id,im2);
   if (id->cache.on_image) add_image(id,im2,im2->filename);
   return im2;
}

ImlibImage *Imlib_clone_scaled_image(ImlibData *id, ImlibImage *im, int w, int h)
{
   ImlibImage *im2;
   char s[1024];
   
   if ((!im)||(w<=0)||(h<=0)) return NULL;
   
   im2=malloc(sizeof(ImlibImage));
   if (!im2) return NULL;
   im2->rgb_width=w;
   im2->rgb_height=h;
   im2->rgb_data=malloc(w*h*3);
   if (!im2->rgb_data)
     {
	free(im2);
	return NULL;
     }
     {  
	int x,y,*xarray;
	unsigned char **yarray,*ptr,*ptr2,*ptr22;
	int l,r,m,pos,inc,w3;
	
	xarray=malloc(sizeof(int)*w);
	if (!xarray)
	  {
	     fprintf(stderr,"ERROR: Cannot allocate X co-ord buffer\n");
	     free(im2->rgb_data);
	     free(im2);
	     return NULL;
	  }
	yarray=malloc(sizeof(unsigned char *)*h);
	if (!yarray)
	  {
	     fprintf(stderr,"ERROR: Cannot allocate Y co-ord buffer\n");
	     free(xarray);
	     free(im2->rgb_data);
	     free(im2);
	     return NULL;
	  }
	ptr22=im->rgb_data;
	w3=im->rgb_width*3;
	inc=0;
	if (w<im->border.left+im->border.right)
	  {l=w>>1;r=w-l;m=0;}
	else
	  {l=im->border.left;r=im->border.right;m=w-l-r;}
	if (m>0) inc=((im->rgb_width-im->border.left-im->border.right)<<16)/m;
	pos=0;
	if (l)
	  for (x=0;x<l;x++)
	  {xarray[x]=(pos>>16)+(pos>>16)+(pos>>16);pos+=0x10000;}
	if (m)
	  {
	     for (x=l;x<l+m;x++)
	       {xarray[x]=(pos>>16)+(pos>>16)+(pos>>16);pos+=inc;}
	  }
	pos=(im->rgb_width-r)<<16;
	for (x=w-r;x<w;x++)
	  {xarray[x]=(pos>>16)+(pos>>16)+(pos>>16);pos+=0x10000;}
	
	if (h<im->border.top+im->border.bottom)
	  {l=h>>1;r=h-l;m=0;}
	else
	  {l=im->border.top;r=im->border.bottom;m=h-l-r;}
	if (m>0) inc=((im->rgb_height-im->border.top-im->border.bottom)<<16)/m;
	pos=0;
	for (x=0;x<l;x++)
	  {yarray[x]=ptr22+((pos>>16)*w3);pos+=0x10000;}
	if (m)
	       {
		  for (x=l;x<l+m;x++)
		    {yarray[x]=ptr22+((pos>>16)*w3);pos+=inc;}
	       }
	pos=(im->rgb_height-r)<<16;
	for (x=h-r;x<h;x++)
	  {yarray[x]=ptr22+((pos>>16)*w3);pos+=0x10000;}
	
	ptr=im2->rgb_data;
	for(y=0;y<h;y++)
	  {
	     for(x=0;x<w;x++)
	       {
		  ptr2=yarray[y]+xarray[x];
		  *ptr++=(int)*ptr2++;
		  *ptr++=(int)*ptr2++;
		  *ptr++=(int)*ptr2;
	       }
	  }
     }
   if (im->alpha_data)
     {
	im2->alpha_data=NULL;
/* yet to be filled in */
     }
   else im2->alpha_data=NULL;
   sprintf(s,"%s_%x_%x_%x_%x",im->filename,(int)time(NULL),w,h,(int)rand());
   im2->filename=malloc(strlen(s)+1);
   strcpy(im2->filename,s);
   im2->width=0;
   im2->height=0;
   im2->shape_color.r=im->shape_color.r;
   im2->shape_color.g=im->shape_color.g;
   im2->shape_color.b=im->shape_color.b;
   im2->border.left=im->border.left;
   im2->border.right=im->border.right;
   im2->border.top=im->border.top;
   im2->border.bottom=im->border.bottom;
   im2->pixmap=0;
   im2->shape_mask=0;
   im2->cache=1;
   im2->mod.gamma=im->mod.gamma;
   im2->mod.brightness=im->mod.brightness;
   im2->mod.contrast=im->mod.contrast;
   im2->rmod.gamma=im->rmod.gamma;
   im2->rmod.brightness=im->rmod.brightness;
   im2->rmod.contrast=im->rmod.contrast;
   im2->gmod.gamma=im->gmod.gamma;
   im2->gmod.brightness=im->gmod.brightness;
   im2->gmod.contrast=im->gmod.contrast;
   im2->bmod.gamma=im->bmod.gamma;
   im2->bmod.brightness=im->bmod.brightness;
   im2->bmod.contrast=im->bmod.contrast;
   calc_map_tables(id,im2);
   if (id->cache.on_image) add_image(id,im2,im2->filename);
   return im2;
}

ImlibImage *Imlib_create_image_from_xpm_data(ImlibData *id, char **data)
{
   ImlibImage *im;
   unsigned char *ptr;
   int pc,c,i,j,k,ncolors,cpp,comment,transp,quote,context,len,count,done;
   int w,h;
   char *line,s[65536],tok[65536],col[65536];
   XColor xcol;
   struct _cmap
     {
	char str[8];
	char transp;
	int r,g,b;
     } *cmap;
   int lookup[128][128];

   if (!data) return NULL;
   im=malloc(sizeof(ImlibImage));
   if (!im) return NULL;
   count=0;
   transp=0;
   done=0;
   
   c=' ';comment=0;quote=0;context=0;ptr=NULL;
   while(!done)
     {
	line=data[count++];
	if (context==0)
	  {
	     /* Header */
	     sscanf(line,"%i %i %i %i",&w,&h,&ncolors,&cpp);
	     if (cpp>7) 
	       {
		  fprintf(stderr,"IMLIB ERROR: XPM data with characters per pixel > 7 not supported\n");
		  free(im);
		  return NULL;
	       }
	     if (w>32767)
	       {
		  fprintf(stderr,"IMLIB ERROR: Image width > 32767 pixels for data\n");
		  free(im);
		  return NULL;
	       }
	     if (h>32767)
	       {
		  fprintf(stderr,"IMLIB ERROR: Image height > 32767 pixels for data\n");
		  free(im);
		  return NULL;
	       }
	     cmap=malloc(sizeof(struct _cmap)*ncolors);
	     if (!cmap) 
	       {
		  free(im);
		  return NULL;
	       }
	     im->rgb_width=w;im->rgb_height=h;
	     im->rgb_data=malloc(im->rgb_width*im->rgb_height*3);
	     if (!im->rgb_data)
	       {
		  free(cmap);
		  free(im);
		  return NULL;
	       }
	     im->alpha_data=NULL;
	     sprintf(s,"creat_%x_%x",(int)time(NULL),(int)rand());
	     im->filename=malloc(strlen(s)+1);
	     strcpy(im->filename,s);
	     im->width=0;
	     im->height=0;
	     im->border.left=0;
	     im->border.right=0;
	     im->border.top=0;
	     im->border.bottom=0;
	     im->pixmap=0;
	     im->shape_mask=0;
	     im->cache=1;
	     im->mod.gamma=id->mod.gamma;
	     im->mod.brightness=id->mod.brightness;
	     im->mod.contrast=id->mod.contrast;
	     im->rmod.gamma=id->rmod.gamma;
	     im->rmod.brightness=id->rmod.brightness;
	     im->rmod.contrast=id->rmod.contrast;
	     im->gmod.gamma=id->gmod.gamma;
	     im->gmod.brightness=id->gmod.brightness;
	     im->gmod.contrast=id->gmod.contrast;
	     im->bmod.gamma=id->bmod.gamma;
	     im->bmod.brightness=id->bmod.brightness;
	     im->bmod.contrast=id->bmod.contrast;
	     ptr=im->rgb_data;
	     j=0;
	     context++;
	  }
	else if (context==1)
	  {
	     /* Color Table */
	     if (j<ncolors)
	       {
		  tok[0]=0;col[0]=0;s[0]=0;
		  len=strlen(line);
		  strncpy(cmap[j].str,line,cpp);
		  cmap[j].str[cpp]=0;
		  cmap[j].r=-1;
		  cmap[j].transp=0;
		  for(k=cpp;k<len;k++)
		    {
		       if (line[k]!=' ')
			 {
			    sscanf(&line[k],"%s",s);
			    k+=strlen(s);
			    if ((!strcmp(s,"m"))||(!strcmp(s,"s"))||
				(!strcmp(s,"g4"))||(!strcmp(s,"g"))||
				(!strcmp(s,"c"))||(k>=len))
			      {
				 if (k>=len)
				   {
				      if (col[0]) strcat(col," ");
				      strcat(col,s);
				   }
				 if (col[0])
				   {
				      if (!strcasecmp(col,"none"))
					{
					   transp=1;
					   cmap[j].transp=1;
					}
				      else
					{
					   if ((cmap[j].r<0)||
					       (!strcmp(tok,"c")))
					     {
						XParseColor(id->x.disp,
							    id->x.root_cmap,
							    col,&xcol);
						cmap[j].r=xcol.red>>8;
						cmap[j].g=xcol.green>>8;
						cmap[j].b=xcol.blue>>8;
						if ((cmap[j].r==255)&&
						    (cmap[j].g==0)&&
						    (cmap[j].b==255))
						  cmap[j].r=254;
					     }
					}
				   }
				 strcpy(tok,s);
				 col[0]=0;
			      }
			    else
			      {
				 if (col[0]) strcat(col," ");
				 strcat(col,s);
			      }
			 }
		    }
	       }
	     j++;
	     if (j>=ncolors) 
	       {
		  if (cpp==1)
		    for(i=0;i<ncolors;i++)
		      lookup[cmap[i].str[0]][cmap[i].str[1]]=i;
		  if (cpp==2)
		    for(i=0;i<ncolors;i++)
		      lookup[cmap[i].str[0]][cmap[i].str[1]]=i;
		  context++;
	       }
	  }
	else
	  {
	     /* Image Data */
	     i=0;
	     if (cpp==0)
	       {
	       }
	     else if (cpp==1)
	       {
		  if (transp)
		    {
		       for(i=0;((i<65536)&&(line[i]));i++)
			 {
			    col[0]=line[i];
			    if (cmap[lookup[col[0]][0]].transp)
			      {
				 *ptr++=255;*ptr++=0;*ptr++=255;
			      }
			    else
			      {
				 *ptr++=(unsigned char)cmap[lookup[col[0]][0]].r;
				 *ptr++=(unsigned char)cmap[lookup[col[0]][0]].g;
				 *ptr++=(unsigned char)cmap[lookup[col[0]][0]].b;
			      }
			 }
		    }
		  else
		    {
		       for(i=0;((i<65536)&&(line[i]));i++)
			 {
			    col[0]=line[i];
			    *ptr++=(unsigned char)cmap[lookup[col[0]][0]].r;
			    *ptr++=(unsigned char)cmap[lookup[col[0]][0]].g;
			    *ptr++=(unsigned char)cmap[lookup[col[0]][0]].b;
			 }
		    }
	       }
	     else if (cpp==2)
	       {
		  if (transp)
		    {
		       for(i=0;((i<65536)&&(line[i]));i++)
			 {
			    col[0]=line[i++];
			    col[1]=line[i];
			    if (cmap[lookup[col[0]][col[1]]].transp)
			      {
				 *ptr++=255;*ptr++=0;*ptr++=255;
			      }
			    else
			      {
				 *ptr++=(unsigned char)cmap[lookup[col[0]][col[1]]].r;
				 *ptr++=(unsigned char)cmap[lookup[col[0]][col[1]]].g;
				 *ptr++=(unsigned char)cmap[lookup[col[0]][col[1]]].b;
			      }
			 }
		    }
		  else
		    {
		       for(i=0;((i<65536)&&(line[i]));i++)
			 {
			    col[0]=line[i++];
			    col[1]=line[i];
			    *ptr++=(unsigned char)cmap[lookup[col[0]][col[1]]].r;
			    *ptr++=(unsigned char)cmap[lookup[col[0]][col[1]]].g;
			    *ptr++=(unsigned char)cmap[lookup[col[0]][col[1]]].b;
			 }
		    }
	       }
	     else
	       {
		  if (transp)
		    {
		       for(i=0;((i<65536)&&(line[i]));i++)
			 {
			    for(j=0;j<cpp;j++,i++)
			      {
				 col[j]=line[i];
			      }
			    col[j]=0;i--;
			    for(j=0;j<ncolors;j++)
			      {
				 if (!strcmp(col,cmap[j].str))
				   {
				      if (cmap[j].transp)
					{
					   *ptr++=255;*ptr++=0;*ptr++=255;
					}
				      else
					{
					   *ptr++=(unsigned char)cmap[j].r;
					   *ptr++=(unsigned char)cmap[j].g;
					   *ptr++=(unsigned char)cmap[j].b;
					}
				      j=ncolors;
				   }
			      }
			 }
		    }
		  else
		    {
		       for(i=0;((i<65536)&&(line[i]));i++)
			 {
			    for(j=0;j<cpp;j++,i++)
			      {
				 col[j]=line[i];
			      }
			    col[j]=0;i--;
			    for(j=0;j<ncolors;j++)
			      {
				 if (!strcmp(col,cmap[j].str))
				   {
				      *ptr++=(unsigned char)cmap[j].r;
				      *ptr++=(unsigned char)cmap[j].g;
				      *ptr++=(unsigned char)cmap[j].b;
				      j=ncolors;
				   }
			      }
			 }
		    }
	       }
	  }
	if ((ptr)&&((ptr-im->rgb_data)>=w*h*3)) done=1;
     }
   if (!transp)
     {
	im->shape_color.r=-1;
	im->shape_color.g=-1;
	im->shape_color.b=-1;
     }
   else
     {
	im->shape_color.r=255;
	im->shape_color.g=0;
	im->shape_color.b=255;
     }
   if (id->cache.on_image) add_image(id,im,im->filename);
   calc_map_tables(id,im);
   free(cmap);
   return im;
}

int Imlib_data_to_pixmap(ImlibData *id, char **data, Pixmap *pmap, Pixmap *mask)
{
   ImlibImage *im;
   
   im=Imlib_create_image_from_xpm_data(id,data);
   if (!im) 
     {
	if (pmap) *pmap=0;
	if (mask) *mask=0;
	return 0;
     }
   if (!Imlib_render(id,im,im->rgb_width,im->rgb_height))
     {
	Imlib_destroy_image(id,im);
	if (pmap) *pmap=0;
	if (mask) *mask=0;
	return 0;
     }
   if (pmap) *pmap=Imlib_move_image(id,im);
   if (mask) *mask=Imlib_move_mask(id,im);
   Imlib_kill_image(id,im);
   return 1;
}
