.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.TH glutInitWindowPosition 3GLUT "3.6" "GLUT" "GLUT"
.SH NAME
glutInitWindowPositionWindowPosition, glutInitWindowSize - set the
initial window position and size respectively.
.SH SYNTAX
.nf
.LP
void glutInitWindowSize(int width, int height);
void glutInitWindowPosition(int x, int y);
.fi
.SH ARGUMENTS
.IP \fIwidth\fP 1i
Width in pixels. 
.IP \fIheight\fP 1i
Height in pixels. 
.IP \fIx\fP 1i
Window X location in pixels. 
.IP \fIy\fP 1i
Window Y location in pixels. 
.SH DESCRIPTION
Windows created by glutCreateWindow will be requested to be
created with the current initial window position and size. 

The initial value of the initial window position GLUT state is -1 and -1.
If either the X or Y component to the initial window position is negative,
the actual window position is left to the window system to determine.
The initial value of the initial window size GLUT state is 300 by 300.
The initial window size components must be greater than zero. 

The intent of the initial window position and size values is to provide a
suggestion to the window system for a window's initial size and
position. The window system is not obligated to use this information.
Therefore, GLUT programs should not assume the window was created
at the specified size or position. A GLUT program should use the
window's reshape callback to determine the true size of the window. 
.SH EXAMPLE
If you would like your GLUT program to default to starting at a given
screen location and at a given size, but you would also like to let
the user override these defaults via a command line argument (such as
-geometry for X11), call glutInitWindowSize and glutInitWindowPosition
.I before
your call to glutInit.  For example:
.nf
.LP
  int main(int argc, char **argv)
  {
    glutInitWindowSize(500, 300);
    glutInitWindowPosition(100, 100);
    glutInit(&argc, argv);
    ...
  }
.fi
.LP
However, if you'd like to force your program to start up at a given
size, call glutInitWindowSize and glutInitWindowPosition
.I after
your call to glutInit.  For example:
.nf
.LP
  int main(int argc, char **argv)
  {
    glutInit(&argc, argv);
    glutInitWindowSize(500, 300);  
    glutInitWindowPosition(100, 100);
    ...
  }
.fi
.SH SEE ALSO
glutInit, glutCreateWindow, glutCreateSubWindow, glutReshapeFunc, glutGet
.SH AUTHOR
Mark J. Kilgard (mjk@sgi.com)
