/*
 * XSOLDIER, a video-oriented game
 * Copyright (C) 1997, Yuusuke HASHIMOTO
 *                     s945750@educ.info.kanagawa-u.ac.jp
 *
 * ܥץˤ copyleft ŬѤƤޤCONDITION ե򻲾Ȥ
 * Ƥ
 */

#ifndef IMAGE_H_INCLUDE
#define IMAGE_H_INCLUDE

typedef struct {
    Pixmap pixmap;
    Pixmap mask;
    GC     maskgc;
    int    width, height;
} Image;

extern void ReadFileToImage(char *filename, Image **img);
extern void PutImage(Image *img, int x, int y);
extern void SplitImage(Image *img, Image ***imgs, int nsplit);
extern void FreeImage(Image *img);
extern void FreeImages(Image **imgs, int nimg);
extern Image **ImageInit(char *filename, int split);

#ifdef GZIP
 #define GZ ".gz"
#else
 #define GZ
#endif

#endif /* IMAGE_H_INCLUDE */
