#! /bin/sh
# config.values.sh --- create config.values.in from ../configure

# Author:	Martin Buchholz
# Maintainer:	Martin Buchholz
# Keywords:	configure elisp report-xemacs-bugs

# This file is part of XEmacs.

# XEmacs is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# XEmacs is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with XEmacs; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

### Commentary:

## Extract all the @foo@ configuration symbols from ../configure
## to make them available to elisp later (see util/config.el)
## Primarily useful for creating ridiculously verbose bug reports.
##
## See lisp/utils/config.el, ../configure.in,
## and the Autoconf documentation on AC_OUTPUT, for more details.
##
## This script needs only to be run occasionally (before a Net release)
## by an XEmacs Maintainer (consider yourself so blessed, if you are
## actually reading this commentary).
##
if test ! -r ./configure; then
  cd ..
  if test ! -r ./configure; then
    echo "Can't find configure!";
    exit 1;
  fi
fi

exec < ./configure > "lib-src/config.values.in"
cat <<\EOF
;;; Do not edit this file!
;;; This file was automatically generated, by the config.values.sh script,
;;; from configure, which was itself automatically generated from configure.in
;;;
;;; See lisp/util/config.el for details on how this file is used.
;;;
;;; You are trapped in a twisty maze of strange-looking files, all autogenerated...

;;; configure        is created, from configure.in,     by autoconf
;;; config.values.in is created, from configure,        by config.values.sh
;;; config.values    is created, from config.values.in, by configure
;;; config.values    is read by lisp/utils/config.el,
;;;                  to create the (Lisp object) config-value-hash-table

;;; Variables defined in configure by AC_SUBST follow:
;;; (These are used in Makefiles)

EOF
sed -n '/^s%@\([A-Za-z_][A-Za-z_]*\)@%\$\1%g$/ {
  s/^s%@\([A-Za-z_][A-Za-z_]*\)@%\$\1%g$/\1 "@\1@"/
  p
}' | \
sort -u
cat <<\EOF

;;; Variables defined in configure by AC_DEFINE and AC_DEFINE_UNQUOTED follow:
;;; (These are used in C code)

EOF
