/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1997 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                 Email:             M.Hessling@qut.edu.au
 * PO Box 203                    Phone:                    +617 3802 0800
 * Bellara                       http://www.gu.edu.au/gext/the/markh.html
 * QLD 4507                      **** Maintainer PDCurses & REXX/SQL ****
 * Australia                     ************* Author of THE ************
 */

/*
$Id: key.h 2.1 1995/06/24 16:30:16 MH Rel MH $
*/

#if defined(USE_EXTCURSES)
# include <cur02.h>
#endif

#include "getch.h"

struct key_values
{
 CHARTYPE *mnemonic;
 int key_value;
};
typedef struct key_values KEYS;

KEYS key_table[] =
{
  {(CHARTYPE *)"A",(int)'a'},
  {(CHARTYPE *)"B",(int)'b'},
  {(CHARTYPE *)"C",(int)'c'},
  {(CHARTYPE *)"D",(int)'d'},
  {(CHARTYPE *)"E",(int)'e'},
  {(CHARTYPE *)"F",(int)'f'},
  {(CHARTYPE *)"G",(int)'g'},
  {(CHARTYPE *)"H",(int)'h'},
  {(CHARTYPE *)"I",(int)'i'},
  {(CHARTYPE *)"J",(int)'j'},
  {(CHARTYPE *)"K",(int)'k'},
  {(CHARTYPE *)"L",(int)'l'},
  {(CHARTYPE *)"M",(int)'m'},
  {(CHARTYPE *)"N",(int)'n'},
  {(CHARTYPE *)"O",(int)'o'},
  {(CHARTYPE *)"P",(int)'p'},
  {(CHARTYPE *)"Q",(int)'q'},
  {(CHARTYPE *)"R",(int)'r'},
  {(CHARTYPE *)"S",(int)'s'},
  {(CHARTYPE *)"T",(int)'t'},
  {(CHARTYPE *)"U",(int)'u'},
  {(CHARTYPE *)"V",(int)'v'},
  {(CHARTYPE *)"W",(int)'w'},
  {(CHARTYPE *)"X",(int)'x'},
  {(CHARTYPE *)"Y",(int)'y'},
  {(CHARTYPE *)"Z",(int)'z'},
  {(CHARTYPE *)"S-A",(int)'A'},
  {(CHARTYPE *)"S-B",(int)'B'},
  {(CHARTYPE *)"S-C",(int)'C'},
  {(CHARTYPE *)"S-D",(int)'D'},
  {(CHARTYPE *)"S-E",(int)'E'},
  {(CHARTYPE *)"S-F",(int)'F'},
  {(CHARTYPE *)"S-G",(int)'G'},
  {(CHARTYPE *)"S-H",(int)'H'},
  {(CHARTYPE *)"S-I",(int)'I'},
  {(CHARTYPE *)"S-J",(int)'J'},
  {(CHARTYPE *)"S-K",(int)'K'},
  {(CHARTYPE *)"S-L",(int)'L'},
  {(CHARTYPE *)"S-M",(int)'M'},
  {(CHARTYPE *)"S-N",(int)'N'},
  {(CHARTYPE *)"S-O",(int)'O'},
  {(CHARTYPE *)"S-P",(int)'P'},
  {(CHARTYPE *)"S-Q",(int)'Q'},
  {(CHARTYPE *)"S-R",(int)'R'},
  {(CHARTYPE *)"S-S",(int)'S'},
  {(CHARTYPE *)"S-T",(int)'T'},
  {(CHARTYPE *)"S-U",(int)'U'},
  {(CHARTYPE *)"S-V",(int)'V'},
  {(CHARTYPE *)"S-W",(int)'W'},
  {(CHARTYPE *)"S-X",(int)'X'},
  {(CHARTYPE *)"S-Y",(int)'Y'},
  {(CHARTYPE *)"S-Z",(int)'Z'},
  {(CHARTYPE *)"0",(int)'0'},
  {(CHARTYPE *)"1",(int)'1'},
  {(CHARTYPE *)"2",(int)'2'},
  {(CHARTYPE *)"3",(int)'3'},
  {(CHARTYPE *)"4",(int)'4'},
  {(CHARTYPE *)"5",(int)'5'},
  {(CHARTYPE *)"6",(int)'6'},
  {(CHARTYPE *)"7",(int)'7'},
  {(CHARTYPE *)"8",(int)'8'},
  {(CHARTYPE *)"9",(int)'9'},
  {(CHARTYPE *)"`",(int)'`'},
  {(CHARTYPE *)"-",(int)'-'},
  {(CHARTYPE *)"=",(int)'='},
  {(CHARTYPE *)"[",(int)'['},
  {(CHARTYPE *)"]",(int)']'},
  {(CHARTYPE *)"\\",(int)'\\'},
  {(CHARTYPE *)";",(int)';'},
  {(CHARTYPE *)"'",(int)'\''},
  {(CHARTYPE *)",",(int)','},
  {(CHARTYPE *)".",(int)'.'},
  {(CHARTYPE *)"/",(int)'/'},
  {(CHARTYPE *)")",(int)')'},
  {(CHARTYPE *)"!",(int)'!'},
  {(CHARTYPE *)"@",(int)'@'},
  {(CHARTYPE *)"#",(int)'#'},
  {(CHARTYPE *)"$",(int)'$'},
  {(CHARTYPE *)"%",(int)'%'},
  {(CHARTYPE *)"^",(int)'^'},
  {(CHARTYPE *)"&",(int)'&'},
  {(CHARTYPE *)"*",(int)'*'},
  {(CHARTYPE *)"(",(int)'('},
  {(CHARTYPE *)"~",(int)'~'},
  {(CHARTYPE *)"_",(int)'_'},
  {(CHARTYPE *)"+",(int)'+'},
  {(CHARTYPE *)"{",(int)'{'},
  {(CHARTYPE *)"}",(int)'}'},
  {(CHARTYPE *)"|",(int)'|'},
  {(CHARTYPE *)":",(int)':'},
  {(CHARTYPE *)"\"",(int)'\"'},
  {(CHARTYPE *)"<",(int)'<'},
  {(CHARTYPE *)">",(int)'>'},
  {(CHARTYPE *)"?",(int)'?'},
  {(CHARTYPE *)"SPACE",(int)' '},
  {(CHARTYPE *)"ESC",KEY_ESC },
  {(CHARTYPE *)"F0",KEY_F0},
  {(CHARTYPE *)"F1",KEY_F1},
  {(CHARTYPE *)"F2",KEY_F2},
  {(CHARTYPE *)"F3",KEY_F3},
  {(CHARTYPE *)"F4",KEY_F4},
  {(CHARTYPE *)"F5",KEY_F5},
  {(CHARTYPE *)"F6",KEY_F6},
  {(CHARTYPE *)"F7",KEY_F7},
  {(CHARTYPE *)"F8",KEY_F8},
  {(CHARTYPE *)"F9",KEY_F9},
  {(CHARTYPE *)"F10",KEY_F10},
  {(CHARTYPE *)"F11",KEY_F11},
  {(CHARTYPE *)"F12",KEY_F12},
  {(CHARTYPE *)"S-F1",KEY_S_F1},
  {(CHARTYPE *)"S-F2",KEY_S_F2},
  {(CHARTYPE *)"S-F3",KEY_S_F3},
  {(CHARTYPE *)"S-F4",KEY_S_F4},
  {(CHARTYPE *)"S-F5",KEY_S_F5},
  {(CHARTYPE *)"S-F6",KEY_S_F6},
  {(CHARTYPE *)"S-F7",KEY_S_F7},
  {(CHARTYPE *)"S-F8",KEY_S_F8},
  {(CHARTYPE *)"S-F9",KEY_S_F9},
  {(CHARTYPE *)"S-F10",KEY_S_F10},
  {(CHARTYPE *)"S-F11",KEY_S_F11},
  {(CHARTYPE *)"S-F12",KEY_S_F12},
  {(CHARTYPE *)"C-F1",KEY_C_F1},
  {(CHARTYPE *)"C-F2",KEY_C_F2},
  {(CHARTYPE *)"C-F3",KEY_C_F3},
  {(CHARTYPE *)"C-F4",KEY_C_F4},
  {(CHARTYPE *)"C-F5",KEY_C_F5},
  {(CHARTYPE *)"C-F6",KEY_C_F6},
  {(CHARTYPE *)"C-F7",KEY_C_F7},
  {(CHARTYPE *)"C-F8",KEY_C_F8},
  {(CHARTYPE *)"C-F9",KEY_C_F9},
  {(CHARTYPE *)"C-F10",KEY_C_F10},
  {(CHARTYPE *)"C-F11",KEY_C_F11},
  {(CHARTYPE *)"C-F12",KEY_C_F12},
  {(CHARTYPE *)"A-F1",KEY_A_F1},
  {(CHARTYPE *)"A-F2",KEY_A_F2},
  {(CHARTYPE *)"A-F3",KEY_A_F3},
  {(CHARTYPE *)"A-F4",KEY_A_F4},
  {(CHARTYPE *)"A-F5",KEY_A_F5},
  {(CHARTYPE *)"A-F6",KEY_A_F6},
  {(CHARTYPE *)"A-F7",KEY_A_F7},
  {(CHARTYPE *)"A-F8",KEY_A_F8},
  {(CHARTYPE *)"A-F9",KEY_A_F9},
  {(CHARTYPE *)"A-F10",KEY_A_F10},
  {(CHARTYPE *)"A-F11",KEY_A_F11},
  {(CHARTYPE *)"A-F12",KEY_A_F12},
  {(CHARTYPE *)"F13",KEY_F13},
  {(CHARTYPE *)"F14",KEY_F14},
  {(CHARTYPE *)"F15",KEY_F15},
  {(CHARTYPE *)"F16",KEY_F16},
  {(CHARTYPE *)"F17",KEY_F17},
  {(CHARTYPE *)"F18",KEY_F18},
  {(CHARTYPE *)"F19",KEY_F19},
  {(CHARTYPE *)"F20",KEY_F20},
  {(CHARTYPE *)"S-F13",KEY_S_F13},
  {(CHARTYPE *)"S-F14",KEY_S_F14},
  {(CHARTYPE *)"S-F15",KEY_S_F15},
  {(CHARTYPE *)"S-F16",KEY_S_F16},
  {(CHARTYPE *)"S-F17",KEY_S_F17},
  {(CHARTYPE *)"S-F18",KEY_S_F18},
  {(CHARTYPE *)"S-F19",KEY_S_F19},
  {(CHARTYPE *)"NUM0"     ,KEY_Pad0},
  {(CHARTYPE *)"NUM1"     ,KEY_C1},
  {(CHARTYPE *)"NUM2"     ,KEY_C2},
  {(CHARTYPE *)"NUM3"     ,KEY_C3},
  {(CHARTYPE *)"NUM4"     ,KEY_B1},
  {(CHARTYPE *)"CENTER"   ,KEY_B2},
  {(CHARTYPE *)"NUM6"     ,KEY_B3},
  {(CHARTYPE *)"NUM7"     ,KEY_A1},
  {(CHARTYPE *)"NUM8"     ,KEY_A2},
  {(CHARTYPE *)"NUM9"     ,KEY_A3},

#if defined(DOS) || defined(OS2) || defined(XCURSES) || defined(WIN32)
/* normal characters */
  {(CHARTYPE *)"CURU",KEY_CURU},
  {(CHARTYPE *)"CURD",KEY_CURD},
  {(CHARTYPE *)"CURL",KEY_CURL},
  {(CHARTYPE *)"CURR",KEY_CURR},
  {(CHARTYPE *)"ENTER",KEY_RETURN },
  {(CHARTYPE *)"ENTER",KEY_ENTER},
  {(CHARTYPE *)"TAB",KEY_TAB },
  {(CHARTYPE *)"BKSP",KEY_BKSP },
  {(CHARTYPE *)"HOME",KEY_HOME},
  {(CHARTYPE *)"PGUP",KEY_PGUP},
  {(CHARTYPE *)"PGDN",KEY_PGDN},
  {(CHARTYPE *)"END",KEY_END},
  {(CHARTYPE *)"INS",KEY_INS},
  {(CHARTYPE *)"DEL",KEY_DEL},
  {(CHARTYPE *)"PLUS",PADPLUS},
  {(CHARTYPE *)"MINUS",PADMINUS},
  {(CHARTYPE *)"SLASH",PADSLASH},
  {(CHARTYPE *)"STAR",PADSTAR},
  {(CHARTYPE *)"NUMENTER",PADENTER},
  {(CHARTYPE *)"NUMSTOP",PADSTOP},
  {(CHARTYPE *)"MOUSE"    ,KEY_MOUSE},
/* shifted characters */
  {(CHARTYPE *)"S-HOME",KEY_SHOME},
  {(CHARTYPE *)"S-END",KEY_SEND},
  {(CHARTYPE *)"S-PGUP",KEY_SPREVIOUS},
  {(CHARTYPE *)"S-PGDN",KEY_SNEXT},
  {(CHARTYPE *)"S-CURU",KEY_S_CURU},
  {(CHARTYPE *)"S-CURD",KEY_S_CURD},
  {(CHARTYPE *)"S-CURL",KEY_SLEFT},
  {(CHARTYPE *)"S-CURR",KEY_SRIGHT},
  {(CHARTYPE *)"S-CENTER",KEY_S_NUMCENTER},
  {(CHARTYPE *)"S-NUM0",KEY_0},
  {(CHARTYPE *)"S-NUM1",KEY_1},
  {(CHARTYPE *)"S-NUM2",KEY_2},
  {(CHARTYPE *)"S-NUM3",KEY_3},
  {(CHARTYPE *)"S-NUM4",KEY_4},
  {(CHARTYPE *)"S-NUM5",KEY_5},
  {(CHARTYPE *)"S-NUM6",KEY_6},
  {(CHARTYPE *)"S-NUM7",KEY_7},
  {(CHARTYPE *)"S-NUM8",KEY_8},
  {(CHARTYPE *)"S-NUM9",KEY_9},
/* control characters */
  {(CHARTYPE *)"C-2",KEY_C_2},
  {(CHARTYPE *)"C-6",KEY_C_6},
  {(CHARTYPE *)"C--",KEY_C_MINUS},
  {(CHARTYPE *)"C-[",KEY_C_LBRACKET},
  {(CHARTYPE *)"C-]",KEY_C_RBRACKET},
  {(CHARTYPE *)"C-\\",KEY_C_BSLASH},
  {(CHARTYPE *)"C-ENTER",CTL_ENTER},
  {(CHARTYPE *)"C-TAB",CTL_TAB},
/*  {(CHARTYPE *)"C-BKSP",CTL_BKSP},*/
  {(CHARTYPE *)"C-BKSP",127},
  {(CHARTYPE *)"C-HOME",CTL_HOME},
  {(CHARTYPE *)"C-PGUP",CTL_PGUP},
  {(CHARTYPE *)"C-PGDN",CTL_PGDN},
  {(CHARTYPE *)"C-CURU",CTL_UP},
  {(CHARTYPE *)"C-CURD",CTL_DOWN},
  {(CHARTYPE *)"C-CURL",CTL_LEFT},
  {(CHARTYPE *)"C-CURR",CTL_RIGHT},
  {(CHARTYPE *)"C-END",CTL_END},
  {(CHARTYPE *)"C-INS",CTL_INS},
  {(CHARTYPE *)"C-DEL",CTL_DEL},
  {(CHARTYPE *)"C-CENTER",CTL_PADCENTER},
  {(CHARTYPE *)"C-NUMSTOP",CTL_PADSTOP},
  {(CHARTYPE *)"C-NUM0",CTL_PAD0},
  {(CHARTYPE *)"C-NUM1",CTL_PAD1},
  {(CHARTYPE *)"C-NUM2",CTL_PAD2},
  {(CHARTYPE *)"C-NUM3",CTL_PAD3},
  {(CHARTYPE *)"C-NUM4",CTL_PAD4},
  {(CHARTYPE *)"C-NUM5",CTL_PAD5},
  {(CHARTYPE *)"C-NUM6",CTL_PAD6},
  {(CHARTYPE *)"C-NUM7",CTL_PAD7},
  {(CHARTYPE *)"C-NUM8",CTL_PAD8},
  {(CHARTYPE *)"C-NUM9",CTL_PAD9},
  {(CHARTYPE *)"C-PLUS",CTL_PADPLUS},
  {(CHARTYPE *)"C-MINUS",CTL_PADMINUS},
  {(CHARTYPE *)"C-SLASH",CTL_PADSLASH},
  {(CHARTYPE *)"C-STAR",CTL_PADSTAR},
  {(CHARTYPE *)"C-NUMENTER",CTL_PADENTER},
/* alt characters */
  {(CHARTYPE *)"A-A",ALT_A},
  {(CHARTYPE *)"A-B",ALT_B},
  {(CHARTYPE *)"A-C",ALT_C},
  {(CHARTYPE *)"A-D",ALT_D},
  {(CHARTYPE *)"A-E",ALT_E},
  {(CHARTYPE *)"A-F",ALT_F},
  {(CHARTYPE *)"A-G",ALT_G},
  {(CHARTYPE *)"A-H",ALT_H},
  {(CHARTYPE *)"A-I",ALT_I},
  {(CHARTYPE *)"A-J",ALT_J},
  {(CHARTYPE *)"A-K",ALT_K},
  {(CHARTYPE *)"A-L",ALT_L},
  {(CHARTYPE *)"A-M",ALT_M},
  {(CHARTYPE *)"A-N",ALT_N},
  {(CHARTYPE *)"A-O",ALT_O},
  {(CHARTYPE *)"A-P",ALT_P},
  {(CHARTYPE *)"A-Q",ALT_Q},
  {(CHARTYPE *)"A-R",ALT_R},
  {(CHARTYPE *)"A-S",ALT_S},
  {(CHARTYPE *)"A-T",ALT_T},
  {(CHARTYPE *)"A-U",ALT_U},
  {(CHARTYPE *)"A-V",ALT_V},
  {(CHARTYPE *)"A-W",ALT_W},
  {(CHARTYPE *)"A-X",ALT_X},
  {(CHARTYPE *)"A-Y",ALT_Y},
  {(CHARTYPE *)"A-Z",ALT_Z},
  {(CHARTYPE *)"A-0",ALT_0},
  {(CHARTYPE *)"A-1",ALT_1},
  {(CHARTYPE *)"A-2",ALT_2},
  {(CHARTYPE *)"A-3",ALT_3},
  {(CHARTYPE *)"A-4",ALT_4},
  {(CHARTYPE *)"A-5",ALT_5},
  {(CHARTYPE *)"A-6",ALT_6},
  {(CHARTYPE *)"A-7",ALT_7},
  {(CHARTYPE *)"A-8",ALT_8},
  {(CHARTYPE *)"A-9",ALT_9},
  {(CHARTYPE *)"A-`",ALT_BQUOTE},
  {(CHARTYPE *)"A--",ALT_MINUS},
  {(CHARTYPE *)"A-=",ALT_EQUAL},
  {(CHARTYPE *)"A-[",ALT_LBRACKET},
  {(CHARTYPE *)"A-]",ALT_RBRACKET},
  {(CHARTYPE *)"A-\\",ALT_BSLASH},
  {(CHARTYPE *)"A-;",ALT_SEMICOLON},
  {(CHARTYPE *)"A-'",ALT_FQUOTE},
  {(CHARTYPE *)"A-,",ALT_COMMA},
  {(CHARTYPE *)"A-.",ALT_STOP},
  {(CHARTYPE *)"A-/",ALT_FSLASH},
  {(CHARTYPE *)"A-ENTER",ALT_ENTER},
  {(CHARTYPE *)"A-TAB",ALT_TAB},
  {(CHARTYPE *)"A-ESC",ALT_ESC },
  {(CHARTYPE *)"A-BKSP",ALT_BKSP },
  {(CHARTYPE *)"A-HOME",ALT_HOME},
  {(CHARTYPE *)"A-PGUP",ALT_PGUP},
  {(CHARTYPE *)"A-PGDN",ALT_PGDN},
  {(CHARTYPE *)"A-CURU",ALT_UP},
  {(CHARTYPE *)"A-CURD",ALT_DOWN},
  {(CHARTYPE *)"A-CURL",ALT_LEFT},
  {(CHARTYPE *)"A-CURR",ALT_RIGHT},
  {(CHARTYPE *)"A-END",ALT_END},
  {(CHARTYPE *)"A-INS",ALT_INS},
  {(CHARTYPE *)"A-DEL",ALT_DEL},
  {(CHARTYPE *)"A-PLUS",ALT_PADPLUS},
  {(CHARTYPE *)"A-MINUS",ALT_PADMINUS},
  {(CHARTYPE *)"A-SLASH",ALT_PADSLASH},
  {(CHARTYPE *)"A-STAR",ALT_PADSTAR},
  {(CHARTYPE *)"A-NUMENTER",ALT_PADENTER},
  {(CHARTYPE *)"A-NUMSTOP",ALT_PADSTOP},
  {(CHARTYPE *)"A-NUM0",ALT_PAD0},
  {(CHARTYPE *)"A-NUM1",ALT_PAD1},
  {(CHARTYPE *)"A-NUM2",ALT_PAD2},
  {(CHARTYPE *)"A-NUM3",ALT_PAD3},
  {(CHARTYPE *)"A-NUM4",ALT_PAD4},
  {(CHARTYPE *)"A-NUM5",ALT_PAD5},
  {(CHARTYPE *)"A-NUM6",ALT_PAD6},
  {(CHARTYPE *)"A-NUM7",ALT_PAD7},
  {(CHARTYPE *)"A-NUM8",ALT_PAD8},
  {(CHARTYPE *)"A-NUM9",ALT_PAD9},
# if defined(XCURSES)
  {(CHARTYPE *)"S-TAB",KEY_BTAB},
  {(CHARTYPE *)"S-INS",KEY_SIC},
  {(CHARTYPE *)"S-DEL",KEY_SDC},
  {(CHARTYPE *)"SELECT",KEY_SELECT},
  {(CHARTYPE *)"PRINT",KEY_PRINT},
  {(CHARTYPE *)"S-PRINT",KEY_SPRINT},
  {(CHARTYPE *)"FIND",KEY_FIND},
  {(CHARTYPE *)"S-FIND",KEY_SFIND},
  {(CHARTYPE *)"SUSPEND",KEY_SUSPEND},
  {(CHARTYPE *)"S-SUSPEND",KEY_SSUSPEND},
  {(CHARTYPE *)"CLEAR",KEY_CLEAR},
  {(CHARTYPE *)"OPTIONS",KEY_OPTIONS},
  {(CHARTYPE *)"S-OPTIONS",KEY_SOPTIONS},
  {(CHARTYPE *)"BREAK",KEY_BREAK},
  {(CHARTYPE *)"CANCEL",KEY_CANCEL},
  {(CHARTYPE *)"S-CANCEL",KEY_SCANCEL},
  {(CHARTYPE *)"HELP"       ,KEY_HELP},
  {(CHARTYPE *)"S-HELP"     ,KEY_SHELP},
  {(CHARTYPE *)"C-HELP"     ,KEY_LHELP},
# else
  {(CHARTYPE *)"S-TAB",KEY_S_TAB},
  {(CHARTYPE *)"S-INS",KEY_S_INS},
  {(CHARTYPE *)"S-DEL",KEY_S_DEL},
# endif
#else
  {(CHARTYPE *)"CURD"     ,KEY_DOWN },
  {(CHARTYPE *)"CURU"     ,KEY_UP },
  {(CHARTYPE *)"CURL"     ,KEY_LEFT },
  {(CHARTYPE *)"CURR"     ,KEY_RIGHT},
  {(CHARTYPE *)"BACKSPACE",KEY_BACKSPACE},
  {(CHARTYPE *)"HOME"     ,KEY_HOME},
  {(CHARTYPE *)"PF1"      ,KEY_PF1},
  {(CHARTYPE *)"PF2"      ,KEY_PF2},
  {(CHARTYPE *)"PF3"      ,KEY_PF3},
  {(CHARTYPE *)"PF4"      ,KEY_PF4},
  {(CHARTYPE *)"NUMENTER" ,KEY_NUMENTER},
  {(CHARTYPE *)"MINUS"    ,KEY_PadMinus},
  {(CHARTYPE *)"NUMSTOP"  ,KEY_PadPeriod},
  {(CHARTYPE *)"COMMA"    ,KEY_PadComma},
  {(CHARTYPE *)"STAR"     ,KEY_PadStar},
  {(CHARTYPE *)"PLUS"     ,KEY_PadPlus},
  {(CHARTYPE *)"SLASH"    ,KEY_PadSlash},
  {(CHARTYPE *)"S-TAB"    ,KEY_BTAB},
  {(CHARTYPE *)"FIND"     ,KEY_Find},
  {(CHARTYPE *)"INS"      ,KEY_InsertHere},
  {(CHARTYPE *)"REMOVE"   ,KEY_Remove},
  {(CHARTYPE *)"DEL"      ,KEY_DELETE},
  {(CHARTYPE *)"SELECT"   ,KEY_Select},
  {(CHARTYPE *)"PGUP"     ,KEY_PrevScreen},
  {(CHARTYPE *)"PGDN"     ,KEY_NextScreen},
#if defined(USE_EXTCURSES)
  {(CHARTYPE *)"TAB"      ,KEY_TAB},
  {(CHARTYPE *)"ENTER"    ,KEY_NEWL},
#else
  {(CHARTYPE *)"TAB"      ,KEY_C_i},
  {(CHARTYPE *)"RETURN"   ,KEY_RETURN},
#endif
  {(CHARTYPE *)"CSI"      ,CSI},
  {(CHARTYPE *)"BREAK"    ,KEY_BREAK },
  {(CHARTYPE *)"DL"       ,KEY_DL},
  {(CHARTYPE *)"IL"       ,KEY_IL},
  {(CHARTYPE *)"DC"       ,KEY_DC},
  {(CHARTYPE *)"INS"      ,KEY_IC},
  {(CHARTYPE *)"EIC"      ,KEY_EIC},
  {(CHARTYPE *)"CLEAR"    ,KEY_CLEAR},
  {(CHARTYPE *)"EOS"      ,KEY_EOS},
  {(CHARTYPE *)"EOL"      ,KEY_EOL},
  {(CHARTYPE *)"SF"       ,KEY_SF},
  {(CHARTYPE *)"SR"       ,KEY_SR},
  {(CHARTYPE *)"PGDN"     ,KEY_NPAGE},
  {(CHARTYPE *)"PGUP"     ,KEY_PPAGE},
  {(CHARTYPE *)"S-TAB"    ,KEY_STAB},
  {(CHARTYPE *)"C-TAB"    ,KEY_CTAB},
  {(CHARTYPE *)"CATAB"    ,KEY_CATAB},
  {(CHARTYPE *)"ENTER"    ,KEY_ENTER},
  {(CHARTYPE *)"S-RESET"  ,KEY_SRESET},
  {(CHARTYPE *)"RESET"    ,KEY_RESET},
  {(CHARTYPE *)"PRINT"    ,KEY_PRINT},
  {(CHARTYPE *)"LL"       ,KEY_LL},
  {(CHARTYPE *)"A1"       ,KEY_A1},
  {(CHARTYPE *)"A3"       ,KEY_A3},
  {(CHARTYPE *)"B2"       ,KEY_B2},
  {(CHARTYPE *)"C1"       ,KEY_C1},
  {(CHARTYPE *)"C3"       ,KEY_C3},
  {(CHARTYPE *)"S-TAB"    ,KEY_BTAB},
  {(CHARTYPE *)"BEG"      ,KEY_BEG},
  {(CHARTYPE *)"CANCEL"   ,KEY_CANCEL},
  {(CHARTYPE *)"CLOSE"    ,KEY_CLOSE},
  {(CHARTYPE *)"COMMAND"  ,KEY_COMMAND},
  {(CHARTYPE *)"COPY"     ,KEY_COPY},
  {(CHARTYPE *)"CREATE"   ,KEY_CREATE},
  {(CHARTYPE *)"END"      ,KEY_END},
  {(CHARTYPE *)"EXIT"     ,KEY_EXIT},
  {(CHARTYPE *)"FIND"     ,KEY_FIND},
  {(CHARTYPE *)"HELP"     ,KEY_HELP},
  {(CHARTYPE *)"MARK"     ,KEY_MARK},
  {(CHARTYPE *)"MESSAGE"  ,KEY_MESSAGE},
  {(CHARTYPE *)"MOVE"     ,KEY_MOVE},
  {(CHARTYPE *)"NEXT"     ,KEY_NEXT},
  {(CHARTYPE *)"OPEN"     ,KEY_OPEN},
  {(CHARTYPE *)"OPTIONS"  ,KEY_OPTIONS},
  {(CHARTYPE *)"PREVIOUS" ,KEY_PREVIOUS},
  {(CHARTYPE *)"REDO"     ,KEY_REDO},
  {(CHARTYPE *)"REFERENCE",KEY_REFERENCE},
  {(CHARTYPE *)"REFRESH"  ,KEY_REFRESH},
  {(CHARTYPE *)"REPLACE"  ,KEY_REPLACE},
  {(CHARTYPE *)"RESTART"  ,KEY_RESTART},
  {(CHARTYPE *)"RESUME"   ,KEY_RESUME},
  {(CHARTYPE *)"SAVE"     ,KEY_SAVE},
  {(CHARTYPE *)"S-BEG"    ,KEY_SBEG},
  {(CHARTYPE *)"S-CANCEL" ,KEY_SCANCEL},
  {(CHARTYPE *)"S-COMMAND",KEY_SCOMMAND},
  {(CHARTYPE *)"S-COPY"   ,KEY_SCOPY},
  {(CHARTYPE *)"S-CREATE" ,KEY_SCREATE},
  {(CHARTYPE *)"S-DC"     ,KEY_SDC},
  {(CHARTYPE *)"S-DL"     ,KEY_SDL},
  {(CHARTYPE *)"SELECT"   ,KEY_SELECT},
  {(CHARTYPE *)"S-END"    ,KEY_SEND},
  {(CHARTYPE *)"S-EOL"    ,KEY_SEOL},
  {(CHARTYPE *)"S-EXIT"   ,KEY_SEXIT},
  {(CHARTYPE *)"S-FIND"   ,KEY_SFIND},
  {(CHARTYPE *)"S-HELP"   ,KEY_SHELP},
  {(CHARTYPE *)"S-HOME"   ,KEY_SHOME},
  {(CHARTYPE *)"S-INS"    ,KEY_SIC},
  {(CHARTYPE *)"S-CURL"   ,KEY_SLEFT},
  {(CHARTYPE *)"S-MESSAGE",KEY_SMESSAGE},
  {(CHARTYPE *)"S-MOVE"   ,KEY_SMOVE},
  {(CHARTYPE *)"S-NEXT"   ,KEY_SNEXT},
  {(CHARTYPE *)"S-OPTIONS",KEY_SOPTIONS},
  {(CHARTYPE *)"S-PREVIOUS",KEY_SPREVIOUS},
  {(CHARTYPE *)"S-PRINT"  ,KEY_SPRINT},
  {(CHARTYPE *)"S-REDO"   ,KEY_SREDO},
  {(CHARTYPE *)"S-REPLACE",KEY_SREPLACE},
  {(CHARTYPE *)"S-CURR"   ,KEY_SRIGHT},
  {(CHARTYPE *)"S-RSUME"  ,KEY_SRSUME},
  {(CHARTYPE *)"S-SAVE"   ,KEY_SSAVE},
  {(CHARTYPE *)"S-SUSPEND",KEY_SSUSPEND},
  {(CHARTYPE *)"S-UNDO"   ,KEY_SUNDO},
  {(CHARTYPE *)"SUSPEND"  ,KEY_SUSPEND},
  {(CHARTYPE *)"UNDO"     ,KEY_UNDO},
  {(CHARTYPE *)"C-CURL"   ,CTL_LEFT},
  {(CHARTYPE *)"C-CURR"   ,CTL_RIGHT},
  {(CHARTYPE *)"C-CURU"   ,CTL_UP},
  {(CHARTYPE *)"C-CURD"   ,CTL_DOWN},
  {(CHARTYPE *)"C-HOME"   ,CTL_HOME},
  {(CHARTYPE *)"C-END"    ,CTL_END},
  {(CHARTYPE *)"C-PGUP"   ,CTL_PGUP},
  {(CHARTYPE *)"C-PGDN"   ,CTL_PGDN},
#endif
  {(CHARTYPE *)"C-A",(int)KEY_C_a},
  {(CHARTYPE *)"C-B",(int)KEY_C_b},
  {(CHARTYPE *)"C-C",(int)KEY_C_c},
  {(CHARTYPE *)"C-D",(int)KEY_C_d},
  {(CHARTYPE *)"C-E",(int)KEY_C_e},
  {(CHARTYPE *)"C-F",(int)KEY_C_f},
  {(CHARTYPE *)"C-G",(int)KEY_C_g},
  {(CHARTYPE *)"C-H",(int)KEY_C_h},
  {(CHARTYPE *)"C-I",(int)KEY_C_i},
  {(CHARTYPE *)"C-J",(int)KEY_C_j},
  {(CHARTYPE *)"C-K",(int)KEY_C_k},
  {(CHARTYPE *)"C-L",(int)KEY_C_l},
  {(CHARTYPE *)"C-M",(int)KEY_C_m},
  {(CHARTYPE *)"C-N",(int)KEY_C_n},
  {(CHARTYPE *)"C-O",(int)KEY_C_o},
  {(CHARTYPE *)"C-P",(int)KEY_C_p},
  {(CHARTYPE *)"C-Q",(int)KEY_C_q},
  {(CHARTYPE *)"C-R",(int)KEY_C_r},
  {(CHARTYPE *)"C-S",(int)KEY_C_s},
  {(CHARTYPE *)"C-T",(int)KEY_C_t},
  {(CHARTYPE *)"C-U",(int)KEY_C_u},
  {(CHARTYPE *)"C-V",(int)KEY_C_v},
  {(CHARTYPE *)"C-W",(int)KEY_C_w},
  {(CHARTYPE *)"C-X",(int)KEY_C_x},
  {(CHARTYPE *)"C-Y",(int)KEY_C_y},
  {(CHARTYPE *)"C-Z",(int)KEY_C_z},
#if defined(BUTTON_MODIFER_MASK)
  {(CHARTYPE *)"PB1",(int)KEY_PB1},
  {(CHARTYPE *)"PB2",(int)KEY_PB2},
  {(CHARTYPE *)"PB3",(int)KEY_PB3},
  {(CHARTYPE *)"S-PB1",(int)KEY_S_PB1},
  {(CHARTYPE *)"S-PB2",(int)KEY_S_PB2},
  {(CHARTYPE *)"S-PB3",(int)KEY_S_PB3},
  {(CHARTYPE *)"C-PB1",(int)KEY_C_PB1},
  {(CHARTYPE *)"C-PB2",(int)KEY_C_PB2},
  {(CHARTYPE *)"C-PB3",(int)KEY_C_PB3},
  {(CHARTYPE *)"A-PB1",(int)KEY_A_PB1},
  {(CHARTYPE *)"A-PB2",(int)KEY_A_PB2},
  {(CHARTYPE *)"A-PB3",(int)KEY_A_PB3},
  {(CHARTYPE *)"RB1",(int)KEY_RB1},
  {(CHARTYPE *)"RB2",(int)KEY_RB2},
  {(CHARTYPE *)"RB3",(int)KEY_RB3},
  {(CHARTYPE *)"S-RB1",(int)KEY_S_RB1},
  {(CHARTYPE *)"S-RB2",(int)KEY_S_RB2},
  {(CHARTYPE *)"S-RB3",(int)KEY_S_RB3},
  {(CHARTYPE *)"C-RB1",(int)KEY_C_RB1},
  {(CHARTYPE *)"C-RB2",(int)KEY_C_RB2},
  {(CHARTYPE *)"C-RB3",(int)KEY_C_RB3},
  {(CHARTYPE *)"A-RB1",(int)KEY_A_RB1},
  {(CHARTYPE *)"A-RB2",(int)KEY_A_RB2},
  {(CHARTYPE *)"A-RB3",(int)KEY_A_RB3},
  {(CHARTYPE *)"DB1",(int)KEY_DB1},
  {(CHARTYPE *)"DB2",(int)KEY_DB2},
  {(CHARTYPE *)"DB3",(int)KEY_DB3},
  {(CHARTYPE *)"S-DB1",(int)KEY_S_DB1},
  {(CHARTYPE *)"S-DB2",(int)KEY_S_DB2},
  {(CHARTYPE *)"S-DB3",(int)KEY_S_DB3},
  {(CHARTYPE *)"C-DB1",(int)KEY_C_DB1},
  {(CHARTYPE *)"C-DB2",(int)KEY_C_DB2},
  {(CHARTYPE *)"C-DB3",(int)KEY_C_DB3},
  {(CHARTYPE *)"A-DB1",(int)KEY_A_DB1},
  {(CHARTYPE *)"A-DB2",(int)KEY_A_DB2},
  {(CHARTYPE *)"A-DB3",(int)KEY_A_DB3},
#endif
  {(CHARTYPE *)NULL    ,0},
};
