/**********************************************************************/
/* KEYINDEX.C: returns the index of a key according to its name       */
/**********************************************************************/

/*
    Copyright (C) 1996, 1997 Free Software Foundation, Inc.
    Ce programme fait partie du package JERED et est soumis, comme le
    reste du package JERED, a la Gnu General Public License version 2
    ou superieure dont voici un extrait et dont vous pouvez lire
    la totalite en consultant le fichier COPYING.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
*/

#if HAVE_STRTOL == 0
#error  This program needs a library containing the 'strtol()' function
#endif

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "jered.h"

typedef struct _KEYDEF_
        {
                char *keyname;
                int value;
        }
        KEYDEF;

static KEYDEF keydefs[] =       /* most of the key names come from ncurses.h */
{
        { "KEY_TAB", KEY_TAB },
        { "KEY_RETURN", KEY_RETURN },
        { "KEY_LINEFEED", KEY_LINEFEED },
        { "KEY_ESPACE", KEY_ESPACE },
        /* { "KEY_ESCAPE", KEY_ESCAPE}, we don't want ESCAPE to be remappable */
        { "KEY_BREAK", KEY_BREAK },
        { "KEY_DOWN", KEY_DOWN },
        { "KEY_UP", KEY_UP },
        { "KEY_LEFT", KEY_LEFT },
        { "KEY_RIGHT", KEY_RIGHT },
        { "KEY_HOME", KEY_HOME },
        { "KEY_BACKSPACE",  KEY_BACKSPACE },
        { "KEY_F0",  KEY_F0 },
        { "KEY_F1",  KEY_F(1) },
        { "KEY_F2",  KEY_F(2) },
        { "KEY_F3",  KEY_F(3) },
        { "KEY_F4",  KEY_F(4) },
        { "KEY_F5",  KEY_F(5) },
        { "KEY_F6",  KEY_F(6) },
        { "KEY_F7",  KEY_F(7) },
        { "KEY_F8",  KEY_F(8) },
        { "KEY_F9",  KEY_F(9) },
        { "KEY_F10",  KEY_F(10) },
        { "KEY_F11",  KEY_F(11) },
        { "KEY_F12",  KEY_F(12) },
        { "KEY_F13",  KEY_F(13) },
        { "KEY_F14",  KEY_F(14) },
        { "KEY_F15",  KEY_F(15) },
        { "KEY_F16",  KEY_F(16) },
        { "KEY_F17",  KEY_F(17) },
        { "KEY_F18",  KEY_F(18) },
        { "KEY_F19",  KEY_F(19) },
        { "KEY_F20",  KEY_F(20) },
        { "KEY_DL", KEY_DL },
        { "KEY_IL", KEY_IL },
        { "KEY_DC", KEY_DC },
        { "KEY_IC", KEY_IC },
        { "KEY_EIC", KEY_EIC },
        { "KEY_CLEAR", KEY_CLEAR },
        { "KEY_EOS", KEY_EOS },
        { "KEY_EOL", KEY_EOL },
        { "KEY_SF", KEY_SF },
        { "KEY_SR", KEY_SR },
        { "KEY_NPAGE", KEY_NPAGE },
        { "KEY_PPAGE", KEY_PPAGE },
        { "KEY_STAB", KEY_STAB },
        { "KEY_CTAB", KEY_CTAB },
        { "KEY_CATAB", KEY_CATAB },
        { "KEY_ENTER", KEY_ENTER },
        { "KEY_SRESET", KEY_SRESET },
        { "KEY_RESET", KEY_RESET },
        { "KEY_PRINT", KEY_PRINT },
        { "KEY_LL", KEY_LL },
        { "KEY_A1", KEY_A1 },
        { "KEY_A3", KEY_A3 },
        { "KEY_B2", KEY_B2 },
        { "KEY_C1", KEY_C1 },
        { "KEY_C3", KEY_C3 },
        { "KEY_BTAB", KEY_BTAB },
        { "KEY_BEG", KEY_BEG },
        { "KEY_CANCEL", KEY_CANCEL },
        { "KEY_CLOSE", KEY_CLOSE },
        { "KEY_COMMAND", KEY_COMMAND },
        { "KEY_COPY", KEY_COPY },
        { "KEY_CREATE", KEY_CREATE },
        { "KEY_END", KEY_END },
        { "KEY_EXIT", KEY_EXIT },
        { "KEY_FIND", KEY_FIND },
        { "KEY_HELP", KEY_HELP },
        { "KEY_MARK", KEY_MARK },
        { "KEY_MESSAGE", KEY_MESSAGE },
        { "KEY_MOVE", KEY_MOVE },
        { "KEY_NEXT", KEY_NEXT },
        { "KEY_OPEN", KEY_OPEN },
        { "KEY_OPTIONS", KEY_OPTIONS },
        { "KEY_PREVIOUS", KEY_PREVIOUS },
        { "KEY_REDO", KEY_REDO },
        { "KEY_REFERENCE", KEY_REFERENCE },
        { "KEY_REFRESH", KEY_REFRESH },
        { "KEY_REPLACE", KEY_REPLACE },
        { "KEY_RESTART", KEY_RESTART },
        { "KEY_RESUME", KEY_RESUME },
        { "KEY_SAVE", KEY_SAVE },
        { "KEY_SBEG", KEY_SBEG },
        { "KEY_SCANCEL", KEY_SCANCEL },
        { "KEY_SCOMMAND", KEY_SCOMMAND },
        { "KEY_SCOPY", KEY_SCOPY },
        { "KEY_SCREATE", KEY_SCREATE },
        { "KEY_SDC", KEY_SDC },
        { "KEY_SDL", KEY_SDL },
        { "KEY_SELECT", KEY_SELECT },
        { "KEY_SEND", KEY_SEND },
        { "KEY_SEOL", KEY_SEOL },
        { "KEY_SEXIT", KEY_SEXIT },
        { "KEY_SFIND", KEY_SFIND },
        { "KEY_SHELP", KEY_SHELP },
        { "KEY_SHOME", KEY_SHOME },
        { "KEY_SIC", KEY_SIC },
        { "KEY_SLEFT", KEY_SLEFT },
        { "KEY_SMESSAGE", KEY_SMESSAGE },
        { "KEY_SMOVE", KEY_SMOVE },
        { "KEY_SNEXT", KEY_SNEXT },
        { "KEY_SOPTIONS", KEY_SOPTIONS },
        { "KEY_SPREVIOUS", KEY_SPREVIOUS },
        { "KEY_SPRINT", KEY_SPRINT },
        { "KEY_SREDO", KEY_SREDO },
        { "KEY_SREPLACE", KEY_SREPLACE },
        { "KEY_SRIGHT", KEY_SRIGHT },
        { "KEY_SRSUME", KEY_SRSUME },
        { "KEY_SSAVE", KEY_SSAVE },
        { "KEY_SSUSPEND", KEY_SSUSPEND },
        { "KEY_SUNDO", KEY_SUNDO },
        { "KEY_SUSPEND", KEY_SUSPEND },
        { "KEY_UNDO", KEY_UNDO },
        /* { "KEY_MOUSE", KEY_MOUSE }, we don't want mouse events to be remappable for now */
        { NULL, 0x0000 }
};

int find_key_byname(char *keyname);
char *find_key_byindex(int index);
/**********************************************************************/
int key_index(char *keyname)
{
        int kindex = -1;
        int escape = 0;

        if (! strncasecmp(keyname, "ESC_", 4))
        {
                escape = 1;
                keyname += 4;
        }
        if (! strncasecmp(keyname, "KEY_", 4))
        {
                keyname += 4;
                if (! strncasecmp(keyname, "CTRL_", 5))
                {
                        keyname += 5;
                        if (isalpha(*keyname) && (*(keyname + 1) == '\0'))
                                kindex = toupper(*keyname) - 'A' + 1;
                }
                else if (! strncasecmp(keyname, "0X", 2))
                        kindex = strtol(keyname, (char **)NULL, 16);
                else if (*(keyname + 1) == '\0')
                        kindex = (int)(unsigned int)(unsigned char)*keyname;
                else
                        kindex = find_key_byname(keyname - 4);
        }

        if (kindex != -1)
        {
                if (escape)
                        kindex += (KEY_MAX + 1);
        }
        return (kindex);
}
/**********************************************************************/
char *key_name(int index)
{
        static char keyname[50];
        char tmp[10];
        char *ptr;

        *keyname = '\0';
        if (index > KEY_MAX)
        {
                index -= (KEY_MAX + 1);
                strcat(keyname, "ESC_");
        }
        
        ptr = find_key_byindex(index);
        if (ptr != NULL)
                strcat(keyname, ptr);
        else
        {       
                strcat(keyname, "KEY_");
                if ((index >= Ctrl_A) && (index <= Ctrl_Z))
                {
                        strcat(keyname, "CTRL_");
                        *tmp = (char)(index + 'A' - Ctrl_A);
                        *(tmp + 1) = '\0';
                        strcat(keyname, tmp);
                }
                else if ((index >= ' ') && isascii(index))
                {
                        *tmp = (char)index;
                        *(tmp + 1) = '\0';
                        strcat(keyname, tmp);
                }
                else
                {
                        sprintf(tmp, "0x%04X", index);
                        strcat(keyname, tmp);
                }
        }
        return (keyname);
}
/**********************************************************************/
int find_key_byname(char *keyname)
{
        KEYDEF *pk;

        pk = keydefs;
        while (pk->keyname != NULL)
        {
                if (! strcasecmp(pk->keyname, keyname))
                        return(pk->value);
                pk++;
        }
        return(-1);
}
/**********************************************************************/
char *find_key_byindex(int index)
{
        KEYDEF *pk;

        pk = keydefs;
        while (pk->keyname != NULL)
        {
                if (pk->value == index)
                        return(pk->keyname);
                pk++;
        }
        return(NULL);
}
/**********************************************************************/
