#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/iolib/strout.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.5
 | File mod date:    1997.11.29 23:10:41
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  iolib
 |
 | Purpose:          <string-output-port> implementation
 `------------------------------------------------------------------------|#

(define-class <string-output-port> (<output-port>)
  current-buffer
  current-buffer-index
  buffer-overflows)

(define-glue (string-output-port-close port)
{
  REG0 = SOP_close(port);
  RETURN1();
})

(define-method close-output-port ((self <string-output-port>))
  (string-output-port-close self))

(define (open-output-string)
  (make <string-output-port>
	current-buffer: (bvec-alloc <byte-vector> 100)
	current-buffer-index: 0
	buffer-overflows: '()))


(define-glue (string-output-port-write-char port the_char)
{
char ch;

    ch = GET_IMMEDIATE_VALUE(the_char);
    SOP_write( port, &ch, 1 );
    RETURN0();
})

(define-method output-port-write-char ((self <string-output-port>)
				       (ch <ascii-char>))
  (string-output-port-write-char self ch))


(define-glue (string-output-port-write-string port the_str)
{
    SOP_write( port, string_text(the_str), string_length(the_str) );
    RETURN0();
})

(define-method write-string ((self <string-output-port>) (str <string>))
  (string-output-port-write-string self str))


(define-glue (string-output-port-write-int port the_int)
{
char temp[20];
int n;

    n = sprintf( temp, "%d", fx2int(the_int) );
    SOP_write( port, temp, n );
    RETURN0();
})

(define-method write-int ((self <string-output-port>) (int <fixnum>))
  (string-output-port-write-int self int))
