#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/iolib/strin.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.5
 | File mod date:    1997.11.29 23:10:41
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  iolib
 |
 | Purpose:          Implement string-input-ports
 `------------------------------------------------------------------------|#

(define-class <string-input-port> (<input-port>)
  (string-port-contents type: <string> init-value: "")
  (string-port-offset type: <fixnum> init-value: 0))

(define (open-input-string (source <string>))
  (make <string-input-port>
	string-port-contents: source))

;;; these methods can be overridden in subclasses to allow more
;;; data to be supplied to the string as it runs out
;;; `provide-more-input' should return either a <string> or #f

(define-method provide-more-input ((self <string-input-port>))
  #f)

(define-method more-input-ready? ((self <string-input-port>))
  #f)

;;;

(define-method input-port-char-ready? ((self <string-input-port>))
  (or (fixnum<? (string-port-offset self)
		(string-length (string-port-contents self)))
      (more-input-ready? self)))

(define-method input-port-read-char ((self <string-input-port>))
  (let (((contents <string>) (string-port-contents self))
	((i <fixnum>) (string-port-offset self)))
    (if (fixnum<? i (string-length contents))
	(begin
	  (set-string-port-offset! self (add1 i))
	  (integer->ascii-char (bvec-ref contents i)))
	(let ((more (provide-more-input self)))
	  (if (string? more)
	      (begin
		(set-string-port-contents! self more)
		(set-string-port-offset! self 0)
		(input-port-read-char self))
	      $eof-object)))))

(define-method input-port-peek-char ((self <string-input-port>))
  (let (((contents <string>) (string-port-contents self))
	((i <fixnum>) (string-port-offset self)))
    (if (fixnum<? i (string-length contents))
	(integer->ascii-char (bvec-ref contents i))
	(let ((more (provide-more-input self)))
	  (if (string? more)
	      (begin
		(set-string-port-contents! self more)
		(set-string-port-offset! self 0)
		(input-port-peek-char self))
	      $eof-object)))))


(define-method collect ((self <string-input-port>) (more? <function>))
  (let loop (((i <fixnum>) (string-port-offset self))
	     ((n <fixnum>) (string-length (string-port-contents self)))
	     ((str <string>) (string-port-contents self))
	     (r '()))
    (if (fixnum<? i n)
	(let ((ch (integer->ascii-char (bvec-ref str i))))
	  (if (more? ch)
	      (if (eq? ch #\newline)
		  (begin
		    (increment-line self)
		    (loop (add1 i) n str (cons ch r)))
		  (loop (add1 i) n str (cons ch r)))
	      (begin
		(set-string-port-offset! self i)
		(reverse! r))))
	(let ((more (provide-more-input self)))
	  (if (string? more)
	      (begin
		(set-string-port-contents! self more)
		(loop 0 (string-length more) more r))
	      (begin
		(set-string-port-offset! self i)
		(reverse! r)))))))
  
(define-method close-input-port ((self <string-input-port>))
  (set-string-port-contents! self "")
  (set-string-port-offset! self 0))
