#|------------------------------------------------------------*-Scheme-*--|
 | File:    handc/demo/threads/game.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.4
 | File mod date:    1997.11.29 23:10:29
 | System build:     v0.7.2, 97.12.21
 |
 `------------------------------------------------------------------------|#

,(use threads syscalls ttywin)

(load "keypoll.scm")

(define-class <my-thread> (<thread>))

(define-class <system-thread> (<my-thread>))

(define-class <game-thread> (<my-thread>)
  player)

(define-method initialize ((self <my-thread>) #rest key-stuff)
  (next-method)
  (set! *all-threads* (append *all-threads* (list self)))
  self)

(define *all-threads* '())

(define (make-system-thread thunk name)
  (make <system-thread>
	thunk: thunk
	name: name))

(define (make-game-thread thunk name player)
  (make <game-thread>
	thunk: thunk
	player: player
	name: name))

;;

(define-class <win> (<object>)
  win-frame
  title
  contents
  energy)

(define (refresh-win (w <win>))
  (move *screen* (car (win-frame w)) (cdr (win-frame w)))
  (standout-begin *screen*)
  (add-str *screen* (make-string 3 #\space))
  (add-str *screen* (title w))
  (add-str *screen* (make-string 3 #\space))
  (standout-end *screen*)
  (add-str *screen* (format #f "   ~d units" (energy w)))
  ;;
  (let ((c (contents w))
	(x (cdr (win-frame w))))
    (let loop ((i 0)
	       (y (+ 1 (car (win-frame w)))))
      (if (< i (vector-length c))
	  (begin
	    (move *screen* y x)
	    (add-str *screen* "|")
	    (add-str *screen* (vector-ref c i))
	    (add-str *screen* "|")
	    (loop (+ i 1) (+ y 1)))))))

(define (player-thread n)
  (let ((w (make <win>
		 energy: 1300
		 win-frame: (cons 6 (- (* n 35) 30))
		 title: (format #f "Player #~d" n)
		 contents: (vector-map (lambda (i)
					 (make-string 14 #\space))
				       '#(1 2 3 4 5 6 7 8 9 10)))))
    (let ((map (contents w)))
      (lambda ()
	(let loop ((i 1)
		   (j 2))
	  ;; move this player
	  (string-set! (vector-ref map i) j #\space)
	  (let ((i (modulo (+ i 1) 10))
		(j (modulo (+ j n) 10)))
	    (string-set! (vector-ref map i) j #\*)
	    (flush-win w)
	    (thread-sleep (+ (remainder (random) 1000) 500))
	    (loop i j)))))))

(define *refresh-mailbox* (make <mailbox>))

(define (no-ready-threads)
  (send-message! *refresh-mailbox* 'halt))

(define (flush-win (w <win>))
  (let ((m (make <mailbox>)))
    (send-message! *refresh-mailbox*
		   (cons w m))
    (receive-message! m)))

(define (refresher)
  (with-curses
   (lambda ()
     (call-with-current-continuation refresh-loop)))
  (exit-threads))

(define (key-listen)
  (let loop ()
    (let ((ch (poll-for-key)))
      (if ch
	  (send-message! *refresh-mailbox* ch)
	  (thread-yield))
      (loop))))

(define (refresh-loop exit-game)
  (move *screen* 0 0)
  (clear-to-bottom *screen*)
  (let loop ((chars '()))
    ;; display the thread status
    (show-thread-status)
    ;;
    (format-at 0 0 "~s" (list->string chars))
    (refresh *screen*)
    ;;
    (let ((m (receive-message! *refresh-mailbox*)))
      (cond
       ((eq? m #\q)
	(exit-game))
       ((eq? m 'halt))
       ((char? m)
	(loop (append chars (list m))))
       ((pair? m)
	(refresh-win (car m))
	(send-message! (cdr m) #t)
	(loop chars))))))

(define (show-thread-status)
  (let ((t *all-threads*))
    (format-at 1 0 "~d threads" (length t))
    (let loop ((i 0)
	       (t t))
      (if (pair? t)
	  (begin
	    (format-at (+ i 2) 0 "thread ~d: ~a (~d ms~a)"
		       i 
		       (thread-name (car t))
		       (total-time (car t))
		       (if (instance? (car t) <game-thread>)
			   (format #f "for player ~a" (player (car t)))
			   ""))
	    (loop (+ i 1)
		  (cdr t)))))))

(define (main args)
  (set! *all-threads* '())
  (run-threads (make-system-thread refresher "refresh")
	       (make-system-thread key-listen "keyboard")
	       (make-game-thread (player-thread 1) 'player-1 1)
	       (make-game-thread (player-thread 2) 'player-2 2)))

