/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1993-1994  Anders Christensen <anders@pvv.unit.no>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Id: rexxsaa.h,v 1.1 1993/05/07 21:38:13 anders Exp anders $
 */

/* Remember to add prototypes for Rexx*() functions */

#if defined(__WATCOMC__) && defined(__NT__)
# include <windows.h>
#endif

#if defined(_MSC_VER) || defined(__RSXNT__)
# include <windows.h>
#endif

int StartRexx() ;
int ExecuteScript( int, char*, int, char* ) ;
void SetVariable( int, char*, int, char* ) ;
char *GetVariable( int*, int, char* ) ;

#if !defined(_OS2EMX_H) && !defined(__RSXNT__)
typedef char CHAR ;
typedef short SHORT ;
typedef long LONG ;
typedef char *PSZ ;

typedef CHAR *PCHAR ;
typedef SHORT *PSHORT ;
typedef LONG *PLONG ;

# ifndef UCHAR_TYPEDEFED
typedef unsigned char UCHAR ;
# endif
# ifndef USHORT_TYPEDEFED
typedef unsigned short USHORT ;
# endif
# ifndef ULONG_TYPEDEFED
typedef unsigned long ULONG ;
# endif

typedef USHORT *PUSHORT ;
typedef char *PCH ;
typedef unsigned char *PUCHAR ;

#endif

#ifdef INCL_REXXSAA
# define INCL_RXSUBCOM
# define INCL_RXSHV
# define INCL_RXFUNC
# define INCL_RXSYSEXIT
# define INCL_RXMACRO
# define INCL_RXARI
#endif

#if !defined(APIENTRY)
# define APIENTRY
#endif

#if !defined(APIRET)
# define APIRET ULONG
#endif

#if !defined(_OS2EMX_H)
typedef APIRET (APIENTRY *PFN)();
#endif

typedef struct RXSTRING_type 
{
   ULONG   strlength ;
   char *strptr ;
} RXSTRING ;
typedef RXSTRING *PRXSTRING ;

typedef APIRET APIENTRY RexxSubcomHandler(PRXSTRING, PUSHORT, PRXSTRING);

#ifdef INCL_RXSYSEXIT

/* 
 * The following are definition for the function codes and subcodes for
 * System Exit Handlers. All RXxxx macros are function codes, while the 
 * RXxxxyyy macros are function subcodes for function code RXxxx.
 */
#define RXFNC        2
# define RXFNCCAL    1

#define RXCMD        3
# define RXCMDHST    1

#define RXMSQ        4
# define RXMSQPLL    1
# define RXMSQPSH    2
# define RXMSQSIZ    3
# define RXMSQNAM   20

#define RXSIO        5
# define RXSIOSAY    1
# define RXSIOTRC    2
# define RXSIOTRD    3
# define RXSIODTR    4
# define RXSIOTLL    5

#define RXHLT        7
# define RXHLTCLR    1
# define RXHLTTST    2

#define RXTRC        8
# define RXTRCTST    1

#define RXINI        9
# define RXINIEXT    1

#define RXTER       10
# define RXTEREXT    1

#define RXDBG       11
# define RXDBGTST    1

#define RXENDLST     0
#define RXNOOFEXITS 12
   
#define RXEXIT_BADTYPE 1
#define RXEXIT_NOTREG 2
#define RXEXIT_NOEMEM 3
#define RXEXIT_OK 0

/* Symbolic return codes for System Exit Handlers */
#define RXEXIT_HANDLED       0
#define RXEXIT_NOT_HANDLED   1
#define RXEXIT_RAISE_ERROR (-1)
  
typedef struct {
   struct {
      unsigned int rxfferr:1 ;
      unsigned int rxffnfnd:1 ;
      unsigned int rxffsub:1 ;
   } rxfnc_flags ;
   unsigned char *rxfnc_name ;
   unsigned short rxfnc_namel ;
   unsigned char *rxfnc_que ;
   unsigned short rxfnc_quel ;
   unsigned short rxfnc_argc ;
   RXSTRING *rxfnc_argv ;
   RXSTRING rxfnc_retc ;
} RXFNCCAL_PARM ;
  
typedef struct {
   struct {
      unsigned int rxfcfail:1 ;
      unsigned int rxfcerr:1 ;
   } rxcmd_flags ;
   unsigned char *rxcmd_address ;
   unsigned short rxcmd_addressl ;
   unsigned char *rxcmd_dll ;
   unsigned short rxcmd_dll_len ;
   RXSTRING rxcmd_command ;
   RXSTRING rxcmd_retc ;
} RXCMDHST_PARM ;

typedef struct {
   RXSTRING rxmsq_retc ;
} RXMSQPLL_PARM ;

typedef struct {
   struct {
      unsigned rcfmlifo:1 ;
   } rcmsq_flags ;
   RXSTRING rxmsq_value ;
} RXMSQPSH_PARM ;

typedef struct {
   unsigned long rxmsq_size ;
} RXMSQSIZ_PARM ;

typedef struct {
   RXSTRING rxmsq_name ;
} RXMSQNAM_PARM ;

typedef struct {
   RXSTRING rxsio_string ;
} RXSIOSAY_PARM ;

typedef RXSIOSAY_PARM RXSIOTRC_PARM ;

typedef struct {
   RXSTRING rxsiotrd_retc ;
} RXSIOTRD_PARM ;      

typedef struct {
   RXSTRING rxsiodtr_retc ;
} RXSIODTR_PARM ;

typedef struct {
   struct {
      unsigned int rxfhhalt:1 ;
   } rxhlt_flags ;
} RXHLTTST_PARM ;

typedef struct {
   struct {
      unsigned int rxftrace:1 ;
   } rxtrx_flags ;
} RXTRCTST_PARM ;

/*
 #define rxfnc_flags	rxfnccal.u_rxfnc_flags
 #define rxfnc_name	rxfnccal.u_rxfnc_name
 #define rxfnc_namel	rxfnccal.u_rxfnc_namel
 #define rxfnc_que	rxfnccal.u_rxfnc_que
 #define rxfnc_quel	rxfnccal.u_rxfnc_quel
 #define rxfnc_argc	rxfnccal.u_rxfnc_argc
 #define rxfnc_argv	rxfnccal.u_rxfnc_argv
 #define rxfnc_retc	rxfnccal.u_rxfnc_retc
 #define rxcmd_flags	rxcmdhst.u_rxcmd_flags
 #define rxcmd_address	rxcmdhst.u_rxcmd_address
 #define rxcmd_addressl	rxcmdhst.u_rxcmd_addressl
 #define rxcmd_dll	rxcmdhst.u_rxcmd_dll
 #define rxcmd_dll_len	rxcmdhst.u_rxcmd_dll_len
 #define rxcmd_command	rxcmdhst.u_rxcmd_command
 #define rxcmd_retc	rxcmdhst.u_rxcmd_retc
 #define rxmsq_retc	rxmsqpll.u_rxmsq_retc
 #define rxsio_string	rxsiosay.u_rxsio_string
 #define rxsiotrd_retc	rxsiotrd.u_rxsiotrd_retc 
 #define rxsiodtr_retc	rxsiodtr.u_rxsiodtr_retc
 #define rxhlt_flags	rxhlttst.u_rxhlt_flags
 #define rxtrc_flags	rxtrctst.u_rxtrc_flags
 */

typedef union {
   RXFNCCAL_PARM fnccal ;
   RXCMDHST_PARM cmdhst ;
   RXMSQPLL_PARM msqpll ;
   RXMSQPSH_PARM msqpsh ;
   RXMSQSIZ_PARM msqsiz ;
   RXMSQNAM_PARM msqnam ;
   RXSIOSAY_PARM siosay ;
   RXSIOTRC_PARM siotrc ;
   RXSIOTRD_PARM siotrd ;
   RXSIODTR_PARM siodtr ;
   RXHLTTST_PARM hlttst ;
   RXTRCTST_PARM trctst ;
} EXIT ;

typedef EXIT *PEXIT ;

typedef struct {
   char *sysexit_name ;
   short sysexit_code ;
} RXSYSEXIT ;

typedef LONG APIENTRY RexxExitHandler( LONG, LONG, PEXIT ) ;
typedef RXSYSEXIT *PRXSYSEXIT ;

APIRET APIENTRY RexxRegisterExitExe(
   PSZ EnvName,
#ifdef RX_STRONGTYPING
   RexxExitHandler *EntryPoint,
#else
   PFN EntryPoint, 
#endif
   PUCHAR UserArea ) ;

APIRET APIENTRY RexxDeregisterExit(
   PSZ EnvName,
   PSZ ModuleName ) ;

#endif /* INCL_RXSYSEXIT */



#define MAXENVNAMELEN 31
  
#define MAKERXSTRING(x,c,l)   ((x).strptr=(c),(x).strlength=(l))
#define RXNULLSTRING(x)       (!(x).strptr)
#define RXSTRLEN(x)           ((x).strptr ? (x).strlength : 0UL)
#define RXSTRPTR(x)           ((x).strptr)
#define RXVALIDSTRING(x)      ((x).strptr && (x).strlength)
#define RXZEROLENSTRING(x)    ((x).strptr && !(x).strlength)

#define DEFAULT_RETSTRING_LENGTH 256 

#define RXCOMMAND         0
#define RXSUBROUTINE      1
#define RXFUNCTION        2


#ifdef INCL_RXSHV

/* 
 * Definitions and declarations for the Rexx variable pool interface.
 */

# define RXSHV_OK	0x00    /* Everything OK */
# define RXSHV_NEWV	0x01    /* Var not previously set */
# define RXSHV_LVAR	0x02    /* Last var in a NEXTV sequence */
# define RXSHV_TRUNC	0x04    /* Name or value has been truncated */
# define RXSHV_BADN	0x08    /* Bad/invalid name */
# define RXSHV_MEMFL	0x10    /* Memory problem, e.g. out of memory */
# define RXSHV_BADF	0x80    /* Invalid function code */

# define RXSHV_NOAVL	0x90    /* Interface is not available */

/* 
 * Note: Some documentation claims that RXSHV_BADF should have the 
 *       value 0x80, but that can't be correct, can it?
 */

# define RXSHV_SET	0x00    /* Set variable */
# define RXSHV_FETCH	0x01    /* Get value of variable */
# define RXSHV_DROPV	0x02    /* Drop variable */
# define RXSHV_SYSET    0x03    /* Set symbolic variable */
# define RXSHV_SYFET    0x04    /* Get value of symbolic variable */
# define RXSHV_SYDRO    0x05    /* Drop symbolic variable */
# define RXSHV_NEXTV	0x06    /* Get next var in a NEXTV sequence */
# define RXSHV_PRIV	0x07    /* Get private information */
# define RXSHV_EXIT	0x08    /* Set function exit value */

/*
 * Note: A symbolic variable is a symbol that will be 'expanded' before 
 *       use, while a (normal) variable is used directly, without 
 *       expanding it first. 
 */

typedef struct shvnode *PSHVBLOCK ;
typedef struct shvnode 
{
   struct shvnode *shvnext ;
   RXSTRING shvname, shvvalue ;
   ULONG shvnamelen, shvvaluelen ;
   UCHAR shvcode, shvret ;
} SHVBLOCK ;

APIRET APIENTRY RexxVariablePool(
   PSHVBLOCK RequestBlockList ) ;

#endif /* INCL_RXSHV */




APIRET APIENTRY RexxStart(
   LONG		ArgCount,
   PRXSTRING 	ArgList,
   PSZ		ProgramName,
   PRXSTRING	Instore,
   PSZ		EnvName,
   LONG		CallType,
#ifdef INCL_RXSYSEXIT
   PRXSYSEXIT	Exits,
#else
   void        *Exits,
#endif
   PSHORT	ReturnCode,
   PRXSTRING	Result ) ;
/* 
 * Return codes .... haha there doesn't seem to be a standard, except
 * zero is OK, negative is an Rexx error, the positive error codes below
 * are my own 'invention'
 */
#define RX_START_OK         0
#define RX_START_BADP       1  /* Bad parameters */
#define RX_START_UNIMPL     2  /* Not yet implemented :-) */
#define RX_START_TOOMANYP   3  /* To many parameters */
#define RX_DIDNT_START      4  /* Unable to start interpreter */


#ifdef INCL_RXSUBCOM

APIRET APIENTRY RexxRegisterSubcomExe(
   PSZ EnvName,
#ifdef RX_STRONGTYPING
   RexxSubcomHandler *EntryPoint,
#else
   PFN EntryPoint,
#endif
   PUCHAR UserArea ) ;

APIRET APIENTRY RexxDeregisterSubcom(
   PSZ EnvName,
   PSZ ModuleName ) ;

APIRET APIENTRY RexxRegisterSubcomDll(
   PSZ EnvName,
   PSZ ModuleName,
#ifdef RX_STRONGTYPING
   RexxSubcomHandler *EntryPoint,
#else
   PFN EntryPoint,
#endif
   PUCHAR UserArea,
   ULONG DropAuth ) ;

APIRET APIENTRY RexxQuerySubcom(
   PSZ Envname,
   PSZ ModuleName,
   PUSHORT Flag,       /* Documentation diverges ... */
   PUCHAR UserArea ) ;

#define RXSUBCOM_OK          0
#define RXSUBCOM_DUP        10
#define RXSUBCOM_MAXREG     20
#define RXSUBCOM_NOTREG     30
#define RXSUBCOM_NOCANDROP  40
#define RXSUBCOM_LOADERR    50
#define RXSUBCOM_NOPROC    127

#define RXSUBCOM_BADENTRY 1001
#define RXSUBCOM_NOEMEM   1002
#define RXSUBCOM_BADTYPE  1003
#define RXSUBCOM_NOTINIT  1004

/* I don't know the 'real' values of these */
#define RXSUBCOM_ERROR      0x01
#define RXSUBCOM_ISREG      0x01
#define RXSUBCOM_FAILURE    0x02
#define RXSUBCOM_DROPPABLE  0x00
#define RXSUBCOM_NONDROP    0x01


#endif /* INCL_RXSUBCOM */


#ifdef INCL_RXFUNC

typedef APIRET APIENTRY RexxFunctionHandler(PUCHAR, ULONG, PRXSTRING, PSZ, PRXSTRING) ;

APIRET APIENTRY RexxRegisterFunctionExe(
   PSZ name,
#ifdef RX_STRONGTYPING
   RexxFunctionHandler *EntryPoint ) ;
#else
   PFN EntryPoint ) ;
#endif

APIRET APIENTRY RexxRegisterFunctionDll(
   PSZ ExternalName,
   PSZ LibraryName,
   PSZ InternalName ) ;

APIRET APIENTRY RexxDeregisterFunction(
   PSZ name ) ;

APIRET APIENTRY RexxQueryFunction(
   PSZ name ) ;

#define RXFUNC_OK             0
#define RXFUNC_DEFINED       10
#define RXFUNC_NOMEM         20
#define RXFUNC_NOTREG        30
#define RXFUNC_MODNOTFND     40
#define RXFUNC_ENTNOTFND     50
#define RXFUNC_NOTINIT       60
#define RXFUNC_BADTYPE       70
#define RXFUNC_NOEMEM      1002

#endif /* INCL_RXFUNC */

/* Asynchronous Request Interface defines */
#ifdef INCL_RXARI

/***    Return Codes from Asynchronous Request interface */

#define RXARI_OK                   0
#define RXARI_NOT_FOUND            1
#define RXARI_PROCESSING_ERROR     2

APIRET APIENTRY RexxSetHalt(
   LONG,
   LONG );

#endif
