#ifndef lint
static char *RCSid = "$Id:$";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992-1994  Anders Christensen <anders@pvv.unit.no>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if defined(DOS) || defined(WIN32) || defined(OS2)      /* MH 10-06-96 */

#include "rexx.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined(DOS)                                        /* MH 10-06-96 */
# include <dos.h>
#endif                                                  /* MH 10-06-96 */
#include <errno.h>
#if defined(__WATCOMC__) || defined(_MSC_VER)           /* MH 10-06-96 */
# include "utsname.h"                                   /* MH 10-06-96 */
# define MAXPATHLEN  _MAX_PATH                          /* MH 10-06-96 */
#else                                                   /* MH 10-06-96 */
# include <sys/param.h>                                 /* MH 10-06-96 */
# include <sys/utsname.h>                               /* MH 10-06-96 */
#endif

#define BUF_SIZE 512

#define RC_OUT_OF_MEMORY (-1)
#define RC_EOF           (-2)

int getenvir( streng *envir );

/***********************************************************************/
static char *get_a_line(FILE *fp,char *string,int *length,int *rcode)
/***********************************************************************/
{
 int ch=' ';
 int bufs = 1;
 register int i=0;

/*---------------------------------------------------------------------*/
/* Allocate the first block of memory.                                 */
/*---------------------------------------------------------------------*/
 if ((string = (char *)malloc(BUF_SIZE+1)) == NULL)
   {
    *rcode = RC_OUT_OF_MEMORY;
    return(NULL);
   }
 
 while(1)
   {
/*---------------------------------------------------------------------*/
/* Read a character form the stream...                                 */
/*---------------------------------------------------------------------*/
    if ((ch = fgetc(fp)) == EOF)
      {
/*---------------------------------------------------------------------*/
/* If EOF is reached, check that it really is end of file.             */
/*---------------------------------------------------------------------*/
       if (feof(fp))
         {
          *length = i;
          *rcode = RC_EOF;
          return(string);
         }
      }
/*---------------------------------------------------------------------*/
/* If end of line is reached, nul terminate string and return.         */
/*---------------------------------------------------------------------*/
    if ((char)ch == '\n')
      {
       *(string+i) = '\0';
       break;
      }
/*---------------------------------------------------------------------*/
/* All other characters, copy to string.                               */
/*---------------------------------------------------------------------*/
    *(string+i++) = (char)ch;
/*---------------------------------------------------------------------*/
/* If we have got to the end of the allocated memory, realloc some more*/
/*---------------------------------------------------------------------*/
    if (i == BUF_SIZE*bufs)
      {
       if ((string = (char *)realloc(string,(BUF_SIZE*(++bufs))+1)) == NULL)
         {
          *rcode = RC_OUT_OF_MEMORY;
          return(NULL);
         }
      }
   }
/*---------------------------------------------------------------------*/
/* Return a line read form the temporary file.                         */
/*---------------------------------------------------------------------*/
 *length = i;
 *rcode = 0;
 return(string);
}
/***********************************************************************/
int dos_do_command( streng *command, int io_flags, int envir )
/***********************************************************************/
{
   int rc=0;
   streng *cmd=NULL ;
   int in=0, out=0, fout=0 ;
   streng *inredir=NULL,*outredir=NULL ;
   int length=0, rcode=0, flush=0 ;
   streng *result=NULL ;
   char *string=NULL;

   FILE *infp,*outfp;
   char *infile="",*outfile="";

   in = io_flags & REDIR_INPUT ;
   out = io_flags & REDIR_OUTLIFO ;
   fout = io_flags & REDIR_OUTFIFO ;

   command = Str_ify( command ) ;
   flush = (out!=0) + ((fout!=0)*2) ;

   if ((!in)&&(!out)&&(!fout))
   {
      ;       /* maybe this should not be allowed. ... */
   }
   cmd = NULL ;
/*---------------------------------------------------------------------*/
/* If redirecting stdin, create a temporary file and write the contents*/
/* of the stack to the file.                                           */
/*---------------------------------------------------------------------*/
   if (in)
     {
      if ((infile = strdup(tmpnam(NULL))) == NULL)      /* MH 10-06-96 */
        {
         perror("While getting temporary in-file name") ;
         return (-1);
        }
      if ((infp = fopen(infile,"w")) == NULL)
        {
         perror("While opening input file") ;
         return (-1);
        }
      while(!stack_empty())
        {
         result = Str_ify(popline()) ;
         fputs(result->value,infp);
         fputs("\n",infp);
        }
      if (fclose(infp))
        {
         perror("While closing input file") ;
         return (-1);
        }
      inredir = Str_make(strlen(infile)+4);
      sprintf(inredir->value,"< %s ",str_trans(infile,'/','\\'));
      inredir->len = strlen(inredir->value);
     }
/*---------------------------------------------------------------------*/
/* If redirecting stdout, create the name of a temporary file for the  */
/* output.                                                             */
/*---------------------------------------------------------------------*/
   if ((out)||(fout))
     {
      if ((outfile = strdup(tmpnam(NULL))) == NULL)     /* MH 10-06-96 */
        {
         perror("While getting temporary out-file name") ;
         return (-1);
        }
      outredir = Str_make(strlen(outfile)+3);
      sprintf(outredir->value,"> %s",str_trans(outfile,'/','\\'));
      outredir->len = strlen(outredir->value);
     }
/*---------------------------------------------------------------------*/
/* Build up the command to be passed to the system() command. The      */
/* command will contain the command to be executed, any arguments and  */
/* the redirection commands and file names.                            */
/*---------------------------------------------------------------------*/
   length = command->len + ((in) ? inredir->len : 0) + (((out)||(fout)) ? outredir->len : 0) + 2;
   cmd = Str_make(length);
   cmd = Str_cat(cmd,command);
   if (in)
     {
      cmd = Str_cat(cmd,inredir);
      Free(inredir);
     }
   if (out||fout)
     {
      cmd = Str_cat(cmd,outredir);
      Free(outredir);
     }
/*---------------------------------------------------------------------*/
/* Execute the command.                                                */
/*---------------------------------------------------------------------*/
   cmd = Str_ify(cmd);
   rc = system(cmd->value);
   Free(cmd);
/*---------------------------------------------------------------------*/
/* If redirecting stdout, we now have to read the file and push each   */
/* line onto the stack.                                                */
/*---------------------------------------------------------------------*/
   if ((out)||(fout))
     {
      str_trans(outfile,'\\','/');
      if ((outfp = fopen(outfile,"r")) == NULL)
        {
         perror("While opening output file") ;
         return(-1);
        }

/*---------------------------------------------------------------------*/
/* If redirecting stdin, create a temporary file and write the contents*/
/* of the stack to the file.                                           */
/*---------------------------------------------------------------------*/
      while(1)
        {
         string = get_a_line(outfp,string,&length,&rcode);
         if (rcode == RC_OUT_OF_MEMORY)
           {
            perror("While reading output file");
            return (-1);
           }
         if (rcode == RC_EOF && length == 0)
           {
            free(string);
            break;
           }
         result = Str_ncre(string,length);
         tmp_stack(result,flush==2);
         free(string);
         if (rcode == RC_EOF)
            break;
        }
      if (flush)
         flush_stack(flush==2);

      if (fclose(outfp))
        {
         perror("While closing output file") ;
         return(-1);
        }
     }
/*---------------------------------------------------------------------*/
/* Delete the temporary file(s) and free up any memory.                */
/*---------------------------------------------------------------------*/
  if (in)
    {
     unlink(str_trans(infile,'\\','/'));
     free(infile);
    }
  if ((out)||(fout))
    {
     unlink(str_trans(outfile,'\\','/'));
     free(outfile);
    }
/*---------------------------------------------------------------------*/
/* Return with, hopefully, return code from system() command.          */
/*---------------------------------------------------------------------*/
  return rc ;
}
# if defined(__WATCOMC__) || defined(_MSC_VER)          /* MH 10-06-96 */
/********************************************************* MH 10-06-96 */
int uname(struct utsname *name)                         /* MH 10-06-96 */
/********************************************************* MH 10-06-96 */
{                                                       /* MH 10-06-96 */
/*-------------------------------------------------------- MH 10-06-96 */
/* Set up values for utsname structure...                  MH 10-06-96 */
/*-------------------------------------------------------- MH 10-06-96 */
#  if defined(OS2)                                      /* MH 10-06-96 */
 strcpy(name->sysname,"OS2");                           /* MH 10-06-96 */
#  endif                                                /* MH 10-06-96 */
#  if defined(WIN32)                                    /* MH 10-06-96 */
 strcpy(name->sysname,"WIN32");                         /* MH 10-06-96 */
#  endif                                                /* MH 10-06-96 */
#  if !defined(_MSC_VER)
 strcpy(name->nodename,"standalone");                   /* MH 10-06-96 */
 sprintf(name->version,"%d",_osmajor);                  /* MH 10-06-96 */
 sprintf(name->release,"%d",_osminor);                  /* MH 10-06-96 */
 strcpy(name->machine,"i386");                          /* MH 10-06-96 */
#  endif
 return(0);                                             /* MH 10-06-96 */
}                                                       /* MH 10-06-96 */
# endif                                                 /* MH 10-06-96 */
#endif
