# Makefile for omniidl2 -- NT / Windows '95
#
# Type NMAKE CFG="HELP" for help.

CONFIG_MAKEFILE=.\CONFIG.win32

!INCLUDE "$(CONFIG_MAKEFILE)"

!IF "$(CFG)" == ""
CFG=omniidl2
!ENDIF 

!IF "$(CFG)" != "omniidl2" && "$(CFG)" != "ast"\
 && "$(CFG)" != "fe" && "$(CFG)" != "narrow" &&\
 "$(CFG)" != "util" && "$(CFG)" != "omniORB2_be"

!IF "$(CFG)" != "HELP"
!MESSAGE Invalid configuration "$(CFG)" specified.
!ENDIF
!MESSAGE You can specify a configuration when running NMAKE on this makefile
!MESSAGE by defining the macro CFG on the command line.  For example:
!MESSAGE 
!MESSAGE NMAKE /f "omniidl2.mak" CFG="omniidl2"
!MESSAGE 
!MESSAGE Possible choices for configuration are:
!MESSAGE 
!MESSAGE "omniidl2" (IDL compiler for omniORB2) (default)
!MESSAGE A build can be cleaned by specifying:
!MESSAGE
!MESSAGE NMAKE /f "omniidl2.mak" CLEAN CFG="<configuration>"
!MESSAGE
!ERROR Please specify one of the above configurations.
!ENDIF 

!IF "$(OS)" == "Windows_NT"
NULL=
!ELSE 
NULL=nul
!ENDIF 


#Source directory for tools:

SRCDIR=$(SRCDIR)\tool

#INCLUDE directories
INCLUDE = $(INCLUDE);$(SRCDIR)\omniidl2\include;$(SRCDIR)\omniidl2\omniORB2_be;$(SRCDIR)\omniidl2\fe


################################################################################
# Begin Project


!IF  "$(CFG)" == "omniidl2"

OUTDIR=$(BASEDIR)\omniidl2

INTDIR=$(BASEDIR)\omniidl2\driver

ALL : "omniORB2_be" "util"\
 "narrow" "fe" "ast"\
  "$(LIBDEPENDS)" \
  "$(OUTDIR)\omniidl2.exe"

CLEAN : 
	-@erase "$(INTDIR)\drv_args.obj"
	-@erase "$(INTDIR)\drv_fork.obj"
	-@erase "$(INTDIR)\drv_init.obj"
	-@erase "$(INTDIR)\drv_link.obj"
	-@erase "$(INTDIR)\drv_main.obj"
	-@erase "$(INTDIR)\drv_preproc.obj"
	-@erase "$(INTDIR)\drv_private.obj"
	-@erase "$(OUTDIR)\omniidl2.exe"
	$(MAKE) /$(MAKEFLAGS) /F "omniidl2.mak" CLEAN CFG="omniORB2_be"
	$(MAKE) /$(MAKEFLAGS) /F "omniidl2.mak" CLEAN CFG="util"
	$(MAKE) /$(MAKEFLAGS) /F "omniidl2.mak" CLEAN CFG="narrow"
	$(MAKE) /$(MAKEFLAGS) /F "omniidl2.mak" CLEAN CFG="fe"
	$(MAKE) /$(MAKEFLAGS) /F "omniidl2.mak" CLEAN CFG="ast"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

"omniORB2_be":
	if not exist "$(BASEDIR)\omniidl2\omniORB2_be/$(NULL)" mkdir "$(BASEDIR)\omniidl2\omniORB2_be"

"util":
	if not exist "$(BASEDIR)\omniidl2\util/$(NULL)" mkdir "$(BASEDIR)\omniidl2\util"

"narrow":
	if not exist "$(BASEDIR)\omniidl2\narrow/$(NULL)" mkdir "$(BASEDIR)\omniidl2\narrow"

"fe":
	if not exist "$(BASEDIR)\omniidl2\fe/$(NULL)" mkdir "$(BASEDIR)\omniidl2\fe"

"ast":
	if not exist "$(BASEDIR)\omniidl2\ast/$(NULL)" mkdir "$(BASEDIR)\omniidl2\ast"

"$(BASEDIR)\omniidl2\driver":
	if not exist "$(BASEDIR)\omniidl2\driver/$(NULL)" mkdir "$(BASEDIR)\omniidl2\driver"

CPP_PROJ=/nologo /ML /w  /GX /O2 /D "NDEBUG" /D "WIN32" /D "_CONSOLE" /D\
 "__NT__" /D "NTArchitecture" /D "_X86_"  \
 /Fo"$(INTDIR)/" /D IDL_CFE_VERSION=" \"1.3.0\"" /D CPP_LOCATION=" \"CL\"" /c 
CPP_OBJS=$(BASEDIR)\omniidl2\omniidl2/

.cc{$(CPP_OBJS)}.obj:
   $(CPP) $(CPP_PROJ) $< 
	
LINK32_FLAGS=kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib\
 advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib\
 odbccp32.lib /nologo /subsystem:console \
 /pdb:none /machine:IX86 /nodefaultlib:"libc.lib" /opt:noref \
 /out:"$(OUTDIR)/omniidl2.exe" 
LINK32_OBJS= \
	"$(INTDIR)\drv_args.obj" \
	"$(INTDIR)\drv_fork.obj" \
	"$(INTDIR)\drv_init.obj" \
	"$(INTDIR)\drv_link.obj" \
	"$(INTDIR)\drv_main.obj" \
	"$(INTDIR)\drv_preproc.obj" \
	"$(INTDIR)\drv_private.obj" \
	"$(BASEDIR)\omniidl2\ast\ast.lib" \
	"$(BASEDIR)\omniidl2\fe\fe.lib" \
	"$(BASEDIR)\omniidl2\narrow\narrow.lib" \
	"$(BASEDIR)\omniidl2\omniORB2_be\omniORB2_be.lib" \
	"$(BASEDIR)\omniidl2\util\util.lib"

"$(LIBDEPENDS)":
	$(MAKE) /$(MAKEFLAGS) /F "omniidl2.mak" CFG="ast"
	$(MAKE) /$(MAKEFLAGS) /F "omniidl2.mak" CFG="fe"
	$(MAKE) /$(MAKEFLAGS) /F "omniidl2.mak" CFG="narrow"
	$(MAKE) /$(MAKEFLAGS) /F "omniidl2.mak" CFG="omniORB2_be"
	$(MAKE) /$(MAKEFLAGS) /F "omniidl2.mak" CFG="util" 



"$(OUTDIR)\omniidl2.exe" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)	
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<



!ELSEIF  "$(CFG)" == "ast"


OUTDIR=$(BASEDIR)\omniidl2\ast
INTDIR=$(BASEDIR)\omniidl2\ast

ALL : "$(OUTDIR)\ast.lib"

CLEAN : 
	-@erase "$(INTDIR)\ast_argument.obj"
	-@erase "$(INTDIR)\ast_array.obj"
	-@erase "$(INTDIR)\ast_attribute.obj"
	-@erase "$(INTDIR)\ast_check.obj"
	-@erase "$(INTDIR)\ast_concrete_type.obj"
	-@erase "$(INTDIR)\ast_constant.obj"
	-@erase "$(INTDIR)\ast_decl.obj"
	-@erase "$(INTDIR)\ast_enum.obj"
	-@erase "$(INTDIR)\ast_enum_val.obj"
	-@erase "$(INTDIR)\ast_exception.obj"
	-@erase "$(INTDIR)\ast_expression.obj"
	-@erase "$(INTDIR)\ast_field.obj"
	-@erase "$(INTDIR)\ast_generator.obj"
	-@erase "$(INTDIR)\ast_interface.obj"
	-@erase "$(INTDIR)\ast_intf_fwd.obj"
	-@erase "$(INTDIR)\ast_module.obj"
	-@erase "$(INTDIR)\ast_operation.obj"
	-@erase "$(INTDIR)\ast_predefined_type.obj"
	-@erase "$(INTDIR)\ast_recursive.obj"
	-@erase "$(INTDIR)\ast_redef.obj"
	-@erase "$(INTDIR)\ast_root.obj"
	-@erase "$(INTDIR)\ast_sequence.obj"
	-@erase "$(INTDIR)\ast_string.obj"
	-@erase "$(INTDIR)\ast_structure.obj"
	-@erase "$(INTDIR)\ast_type.obj"
	-@erase "$(INTDIR)\ast_typedef.obj"
	-@erase "$(INTDIR)\ast_union.obj"
	-@erase "$(INTDIR)\ast_union_branch.obj"
	-@erase "$(INTDIR)\ast_union_label.obj"
	-@erase "$(OUTDIR)\ast.lib"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"


CPP_PROJ=/nologo /ML /w  /GX /O2 /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D\
 "NTArchitecture" /D "_X86_" /D "__NT__"  \
 /Fo"$(INTDIR)/" /c 
CPP_OBJS=$(BASEDIR)\omniidl2\ast/

.cc{$(CPP_OBJS)}.obj:
   $(CPP) $(CPP_PROJ) $< 

LIB32_FLAGS=/nologo /out:"$(OUTDIR)/ast.lib" 
LIB32_OBJS= \
	"$(INTDIR)\ast_argument.obj" \
	"$(INTDIR)\ast_array.obj" \
	"$(INTDIR)\ast_attribute.obj" \
	"$(INTDIR)\ast_check.obj" \
	"$(INTDIR)\ast_concrete_type.obj" \
	"$(INTDIR)\ast_constant.obj" \
	"$(INTDIR)\ast_decl.obj" \
	"$(INTDIR)\ast_enum.obj" \
	"$(INTDIR)\ast_enum_val.obj" \
	"$(INTDIR)\ast_exception.obj" \
	"$(INTDIR)\ast_expression.obj" \
	"$(INTDIR)\ast_field.obj" \
	"$(INTDIR)\ast_generator.obj" \
	"$(INTDIR)\ast_interface.obj" \
	"$(INTDIR)\ast_intf_fwd.obj" \
	"$(INTDIR)\ast_module.obj" \
	"$(INTDIR)\ast_operation.obj" \
	"$(INTDIR)\ast_predefined_type.obj" \
	"$(INTDIR)\ast_recursive.obj" \
	"$(INTDIR)\ast_redef.obj" \
	"$(INTDIR)\ast_root.obj" \
	"$(INTDIR)\ast_sequence.obj" \
	"$(INTDIR)\ast_string.obj" \
	"$(INTDIR)\ast_structure.obj" \
	"$(INTDIR)\ast_type.obj" \
	"$(INTDIR)\ast_typedef.obj" \
	"$(INTDIR)\ast_union.obj" \
	"$(INTDIR)\ast_union_branch.obj" \
	"$(INTDIR)\ast_union_label.obj"

"$(OUTDIR)\ast.lib" : "$(OUTDIR)" $(DEF_FILE) $(LIB32_OBJS)
    $(LIB32) @<<
  $(LIB32_FLAGS) $(DEF_FLAGS) $(LIB32_OBJS)
<<



!ELSEIF  "$(CFG)" == "fe"

OUTDIR=$(BASEDIR)\omniidl2\fe
INTDIR=$(BASEDIR)\omniidl2\fe

ALL : "$(OUTDIR)\fe.lib"

CLEAN : 
	-@erase "$(INTDIR)\fe_declarator.obj"
	-@erase "$(INTDIR)\fe_extern.obj"
	-@erase "$(INTDIR)\fe_init.obj"
	-@erase "$(INTDIR)\fe_interface_header.obj"
	-@erase "$(INTDIR)\fe_private.obj"
	-@erase "$(INTDIR)\lex.yy.obj"
	-@erase "$(INTDIR)\y.tab.obj"
	-@erase "$(OUTDIR)\fe.lib"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"


CPP_PROJ=/nologo /ML /w  /GX /O2 /D "NDEBUG" /D "WIN32" /D "_WINDOWS" /D\
 "__NT__" /D "NTArchitecture" /D "_X86_" /D "__EXTERN_C__" \
  /Fo"$(INTDIR)/" /c 
CPP_OBJS=$(BASEDIR)\omniidl2\fe/
    
.cc{$(CPP_OBJS)}.obj:
   $(CPP) $(CPP_PROJ) $< 

LIB32_FLAGS=/nologo /out:"$(OUTDIR)/fe.lib" 
LIB32_OBJS= \
	"$(INTDIR)\fe_declarator.obj" \
	"$(INTDIR)\fe_extern.obj" \
	"$(INTDIR)\fe_init.obj" \
	"$(INTDIR)\fe_interface_header.obj" \
	"$(INTDIR)\fe_private.obj" \
	"$(INTDIR)\lex.yy.obj" \
	"$(INTDIR)\y.tab.obj"

"$(OUTDIR)\fe.lib" : "$(OUTDIR)" $(DEF_FILE) $(LIB32_OBJS)
    $(LIB32) @<<
  $(LIB32_FLAGS) $(DEF_FLAGS) $(LIB32_OBJS)
<<



!ELSEIF  "$(CFG)" == "narrow"

OUTDIR=$(BASEDIR)\omniidl2\narrow
INTDIR=$(BASEDIR)\omniidl2\narrow

ALL : "$(OUTDIR)\narrow.lib"

CLEAN : 
	-@erase "$(INTDIR)\nr_narrow.obj"
	-@erase "$(OUTDIR)\narrow.lib"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

CPP_PROJ=/nologo /ML /w  /GX /O2 /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D\
 "NTArchitecture" /D "_X86_" /D "__NT__"  \
 /Fo"$(INTDIR)/" /c 
CPP_OBJS=$(BASEDIR)\omniidl2\narrow/

.cc{$(CPP_OBJS)}.obj:
   $(CPP) $(CPP_PROJ) $< 

LIB32_FLAGS=/nologo /out:"$(OUTDIR)/narrow.lib" 
LIB32_OBJS= \
	"$(INTDIR)\nr_narrow.obj"

"$(OUTDIR)\narrow.lib" : "$(OUTDIR)" $(DEF_FILE) $(LIB32_OBJS)
    $(LIB32) @<<
  $(LIB32_FLAGS) $(DEF_FLAGS) $(LIB32_OBJS)
<<



!ELSEIF  "$(CFG)" == "util"


OUTDIR=$(BASEDIR)\omniidl2\util
INTDIR=$(BASEDIR)\omniidl2\util

ALL : "$(OUTDIR)\util.lib"

CLEAN : 
	-@erase "$(INTDIR)\utl_decllist.obj"
	-@erase "$(INTDIR)\utl_error.obj"
	-@erase "$(INTDIR)\utl_exceptlist.obj"
	-@erase "$(INTDIR)\utl_exprlist.obj"
	-@erase "$(INTDIR)\utl_global.obj"
	-@erase "$(INTDIR)\utl_identifier.obj"
	-@erase "$(INTDIR)\utl_idlist.obj"
	-@erase "$(INTDIR)\utl_indenter.obj"
	-@erase "$(INTDIR)\utl_labellist.obj"
	-@erase "$(INTDIR)\utl_list.obj"
	-@erase "$(INTDIR)\utl_namelist.obj"
	-@erase "$(INTDIR)\utl_scope.obj"
	-@erase "$(INTDIR)\utl_stack.obj"
	-@erase "$(INTDIR)\utl_string.obj"
	-@erase "$(INTDIR)\utl_strlist.obj"
	-@erase "$(OUTDIR)\util.lib"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

CPP_PROJ=/nologo /ML /w  /GX /O2 /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D\
 "NTArchitecture" /D "_X86_" /D "__NT__"  \
 /Fo"$(INTDIR)/" /c 
CPP_OBJS=$(BASEDIR)\omniidl2\util/

.cc{$(CPP_OBJS)}.obj:
   $(CPP) $(CPP_PROJ) $< 

LIB32_FLAGS=/nologo /out:"$(OUTDIR)/util.lib" 
LIB32_OBJS= \
	"$(INTDIR)\utl_decllist.obj" \
	"$(INTDIR)\utl_error.obj" \
	"$(INTDIR)\utl_exceptlist.obj" \
	"$(INTDIR)\utl_exprlist.obj" \
	"$(INTDIR)\utl_global.obj" \
	"$(INTDIR)\utl_identifier.obj" \
	"$(INTDIR)\utl_idlist.obj" \
	"$(INTDIR)\utl_indenter.obj" \
	"$(INTDIR)\utl_labellist.obj" \
	"$(INTDIR)\utl_list.obj" \
	"$(INTDIR)\utl_namelist.obj" \
	"$(INTDIR)\utl_scope.obj" \
	"$(INTDIR)\utl_stack.obj" \
	"$(INTDIR)\utl_string.obj" \
	"$(INTDIR)\utl_strlist.obj"

"$(OUTDIR)\util.lib" : "$(OUTDIR)" $(DEF_FILE) $(LIB32_OBJS)
    $(LIB32) @<<
  $(LIB32_FLAGS) $(DEF_FLAGS) $(LIB32_OBJS)
<<

!ELSEIF  "$(CFG)" == "omniORB2_be"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 0
# PROP BASE Output_Dir "omniORB2_be\omniORB2"
# PROP BASE Intermediate_Dir "omniORB2_be\omniORB2"
# PROP BASE Target_Dir "omniORB2_be"
# PROP Use_MFC 1
# PROP Use_Debug_Libraries 0
# PROP Output_Dir "omniORB2_be\omniORB2"
# PROP Intermediate_Dir "omniORB2_be\omniORB2"
# PROP Target_Dir "omniORB2_be"
OUTDIR=$(BASEDIR)\omniidl2\omniORB2_be
INTDIR=$(BASEDIR)\omniidl2\omniORB2_be

ALL : "$(OUTDIR)\omniORB2_be.lib"

CLEAN : 
	-@erase "$(INTDIR)\o2be_array.obj"
	-@erase "$(INTDIR)\o2be_attribute.obj"
	-@erase "$(INTDIR)\o2be_cfe_interface.obj"
	-@erase "$(INTDIR)\o2be_constant.obj"
	-@erase "$(INTDIR)\o2be_enum.obj"
	-@erase "$(INTDIR)\o2be_exception.obj"
	-@erase "$(INTDIR)\o2be_field.obj"
	-@erase "$(INTDIR)\o2be_generator.obj"
	-@erase "$(INTDIR)\o2be_interface.obj"
	-@erase "$(INTDIR)\o2be_module.obj"
	-@erase "$(INTDIR)\o2be_name.obj"
	-@erase "$(INTDIR)\o2be_operation.obj"
	-@erase "$(INTDIR)\o2be_predefined_type.obj"
	-@erase "$(INTDIR)\o2be_root.obj"
	-@erase "$(INTDIR)\o2be_sequence.obj"
	-@erase "$(INTDIR)\o2be_string.obj"
	-@erase "$(INTDIR)\o2be_struct.obj"
	-@erase "$(INTDIR)\o2be_typedef.obj"
	-@erase "$(INTDIR)\o2be_union.obj"
	-@erase "$(INTDIR)\o2be_union_branch.obj"
	-@erase "$(OUTDIR)\omniORB2_be.lib"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

CPP_PROJ=/nologo /MT /w  /GX /O2 /D "NDEBUG" /D "WIN32" /D "_WINDOWS" /D\
 "__NT__" /D "NTArchitecture" /D "_X86_" /D "_MBCS"\
   /Fo"$(INTDIR)/" /c 
CPP_OBJS=$(BASEDIR)\omniidl2\omniORB2_be/

.cc{$(CPP_OBJS)}.obj:
   $(CPP) $(CPP_PROJ) $<  

LIB32_FLAGS=/nologo /out:"$(OUTDIR)/omniORB2_be.lib" 
LIB32_OBJS= \
	"$(INTDIR)\o2be_array.obj" \
	"$(INTDIR)\o2be_attribute.obj" \
	"$(INTDIR)\o2be_cfe_interface.obj" \
	"$(INTDIR)\o2be_constant.obj" \
	"$(INTDIR)\o2be_enum.obj" \
	"$(INTDIR)\o2be_exception.obj" \
	"$(INTDIR)\o2be_field.obj" \
	"$(INTDIR)\o2be_generator.obj" \
	"$(INTDIR)\o2be_interface.obj" \
	"$(INTDIR)\o2be_module.obj" \
	"$(INTDIR)\o2be_name.obj" \
	"$(INTDIR)\o2be_operation.obj" \
	"$(INTDIR)\o2be_predefined_type.obj" \
	"$(INTDIR)\o2be_root.obj" \
	"$(INTDIR)\o2be_sequence.obj" \
	"$(INTDIR)\o2be_string.obj" \
	"$(INTDIR)\o2be_struct.obj" \
	"$(INTDIR)\o2be_typedef.obj" \
	"$(INTDIR)\o2be_union.obj" \
	"$(INTDIR)\o2be_union_branch.obj"

"$(OUTDIR)\omniORB2_be.lib" : "$(OUTDIR)" $(DEF_FILE) $(LIB32_OBJS)
    $(LIB32) @<<
  $(LIB32_FLAGS) $(DEF_FLAGS) $(LIB32_OBJS)
<<

!ENDIF 

################################################################################
# Begin Target

# Name "omniidl2"
################################################################################
# Begin Project Dependency

# Project_Dep_Name "$(BASEDIR)\omniidl2\ast\ast.lib"

!IF  "$(CFG)" == "omniidl2"

"$(BASEDIR)\omniidl2\ast\ast.lib" : 
   $(MAKE) /$(MAKEFLAGS) /F "omniidl2.mak" CFG="ast" 

!ENDIF 

# End Project Dependency
################################################################################
# Begin Project Dependency

# Project_Dep_Name "$(BASEDIR)\omniidl2\fe\fe.lib"

!IF  "$(CFG)" == "omniidl2"

"$(BASEDIR)\omniidl2\fe\fe.lib" : 
   $(MAKE) /$(MAKEFLAGS) /F "omniidl2.mak" CFG="fe" 

!ENDIF 

# End Project Dependency
################################################################################
# Begin Project Dependency

# Project_Dep_Name "$(BASEDIR)\omniidl2\narrow\narrow.lib"

!IF  "$(CFG)" == "omniidl2"

"$(BASEDIR)\omniidl2\narrow\narrow.lib" : 
   $(MAKE) /$(MAKEFLAGS) /F "omniidl2.mak" CFG="narrow" 

!ENDIF 

# End Project Dependency
################################################################################
# Begin Project Dependency

# Project_Dep_Name "$(BASEDIR)\omniidl2\util\util.lib"

!IF  "$(CFG)" == "omniidl2"

"$(BASEDIR)\omniidl2\util\util.lib" : 
   $(MAKE) /$(MAKEFLAGS) /F "omniidl2.mak" CFG="util" 

!ENDIF 

# End Project Dependency
################################################################################
# Begin Project Dependency

# Project_Dep_Name "$(BASEDIR)\omniidl2\omniORB2_be\omniORB2_be.lib"

!IF  "$(CFG)" == "omniidl2"

"$(BASEDIR)\omniidl2\omniORB2_be\omniORB2_be.lib" : 
   $(MAKE) /$(MAKEFLAGS) /F "omniidl2.mak" CFG="omniORB2_be" 

!ENDIF 

# End Project Dependency
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\driver\drv_private.cc
DEP_CPP_DRV_P=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\drv_private.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\drv_private.obj" : $(SOURCE) $(DEP_CPP_DRV_P) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\driver\drv_fork.cc
DEP_CPP_DRV_F=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\drv_private.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\drv_fork.obj" : $(SOURCE) $(DEP_CPP_DRV_F) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\driver\drv_init.cc
DEP_CPP_DRV_I=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\drv_link.hh"\
	{$(INCLUDE)}"\drv_private.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\drv_init.obj" : $(SOURCE) $(DEP_CPP_DRV_I) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\driver\drv_link.cc
DEP_CPP_DRV_L=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\drv_link.hh"\
	{$(INCLUDE)}"\drv_private.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\drv_link.obj" : $(SOURCE) $(DEP_CPP_DRV_L) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\driver\drv_main.cc
DEP_CPP_DRV_M=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\drv_link.hh"\
	{$(INCLUDE)}"\drv_private.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\drv_main.obj" : $(SOURCE) $(DEP_CPP_DRV_M) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\driver\drv_preproc.cc
DEP_CPP_DRV_PR=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\drv_link.hh"\
	{$(INCLUDE)}"\drv_private.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\STAT.H"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\drv_preproc.obj" : $(SOURCE) $(DEP_CPP_DRV_PR) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\driver\drv_args.cc
DEP_CPP_DRV_A=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\drv_link.hh"\
	{$(INCLUDE)}"\drv_private.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\drv_args.obj" : $(SOURCE) $(DEP_CPP_DRV_A) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\util\utl_decllist.cc
DEP_CPP_UTL_D=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\utl_decllist.obj" : $(SOURCE) $(DEP_CPP_UTL_D) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
# End Target
################################################################################
# Begin Target

# Name "ast"
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_argument.cc
DEP_CPP_AST_A=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_argument.obj" : $(SOURCE) $(DEP_CPP_AST_A) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_array.cc
DEP_CPP_AST_AR=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_array.obj" : $(SOURCE) $(DEP_CPP_AST_AR) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_attribute.cc
DEP_CPP_AST_AT=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_attribute.obj" : $(SOURCE) $(DEP_CPP_AST_AT) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_check.cc

!IF  "$(CFG)" == "ast"

DEP_CPP_AST_C=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_check.obj" : $(SOURCE) $(DEP_CPP_AST_C) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


!ENDIF 

# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_concrete_type.cc
DEP_CPP_AST_CO=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_concrete_type.obj" : $(SOURCE) $(DEP_CPP_AST_CO) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_constant.cc
DEP_CPP_AST_CON=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_constant.obj" : $(SOURCE) $(DEP_CPP_AST_CON) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_decl.cc
DEP_CPP_AST_D=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_decl.obj" : $(SOURCE) $(DEP_CPP_AST_D) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_enum.cc
DEP_CPP_AST_E=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_enum.obj" : $(SOURCE) $(DEP_CPP_AST_E) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_enum_val.cc
DEP_CPP_AST_EN=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_enum_val.obj" : $(SOURCE) $(DEP_CPP_AST_EN) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_exception.cc
DEP_CPP_AST_EX=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_exception.obj" : $(SOURCE) $(DEP_CPP_AST_EX) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_expression.cc
DEP_CPP_AST_EXP=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_expression.obj" : $(SOURCE) $(DEP_CPP_AST_EXP) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_field.cc
DEP_CPP_AST_F=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_field.obj" : $(SOURCE) $(DEP_CPP_AST_F) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_generator.cc
DEP_CPP_AST_G=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_generator.obj" : $(SOURCE) $(DEP_CPP_AST_G) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_union_branch.cc
DEP_CPP_AST_U=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_union_branch.obj" : $(SOURCE) $(DEP_CPP_AST_U) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_union_label.cc
DEP_CPP_AST_U=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_union_label.obj" : $(SOURCE) $(DEP_CPP_AST_U) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_interface.cc
DEP_CPP_AST_I=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_interface.obj" : $(SOURCE) $(DEP_CPP_AST_I) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_intf_fwd.cc
DEP_CPP_AST_IN=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_intf_fwd.obj" : $(SOURCE) $(DEP_CPP_AST_IN) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_module.cc
DEP_CPP_AST_M=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_module.obj" : $(SOURCE) $(DEP_CPP_AST_M) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_operation.cc
DEP_CPP_AST_O=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_operation.obj" : $(SOURCE) $(DEP_CPP_AST_O) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_predefined_type.cc
DEP_CPP_AST_P=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_predefined_type.obj" : $(SOURCE) $(DEP_CPP_AST_P) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_recursive.cc
DEP_CPP_AST_R=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_recursive.obj" : $(SOURCE) $(DEP_CPP_AST_R) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_redef.cc
DEP_CPP_AST_RE=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_redef.obj" : $(SOURCE) $(DEP_CPP_AST_RE) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_root.cc
DEP_CPP_AST_RO=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_root.obj" : $(SOURCE) $(DEP_CPP_AST_RO) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_sequence.cc
DEP_CPP_AST_S=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_sequence.obj" : $(SOURCE) $(DEP_CPP_AST_S) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_string.cc
DEP_CPP_AST_ST=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_string.obj" : $(SOURCE) $(DEP_CPP_AST_ST) "$(INTDIR)"
   $(CPP) $(CPP_PROJ)  /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_structure.cc
DEP_CPP_AST_STR=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_structure.obj" : $(SOURCE) $(DEP_CPP_AST_STR) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_type.cc
DEP_CPP_AST_T=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_type.obj" : $(SOURCE) $(DEP_CPP_AST_T) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_typedef.cc
DEP_CPP_AST_TY=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_typedef.obj" : $(SOURCE) $(DEP_CPP_AST_TY) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\ast\ast_union.cc
DEP_CPP_AST_UN=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\ast_union.obj" : $(SOURCE) $(DEP_CPP_AST_UN) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
# End Target
################################################################################
# Begin Target

# Name "fe"
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\fe\fe_declarator.cc
DEP_CPP_FE_DE=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_declarator.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\fe_interface_header.hh"\
	{$(INCLUDE)}"\fe_private.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\fe_declarator.obj" : $(SOURCE) $(DEP_CPP_FE_DE) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\fe\fe_extern.cc
DEP_CPP_FE_EX=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_declarator.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\fe_interface_header.hh"\
	{$(INCLUDE)}"\fe_private.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\fe_extern.obj" : $(SOURCE) $(DEP_CPP_FE_EX) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\fe\fe_init.cc
DEP_CPP_FE_IN=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_declarator.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\fe_interface_header.hh"\
	{$(INCLUDE)}"\fe_private.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\o2be.h"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\fe_init.obj" : $(SOURCE) $(DEP_CPP_FE_IN) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\fe\fe_interface_header.cc
DEP_CPP_FE_INT=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_declarator.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\fe_interface_header.hh"\
	{$(INCLUDE)}"\fe_private.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\fe_interface_header.obj" : $(SOURCE) $(DEP_CPP_FE_INT) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\fe\fe_private.cc
DEP_CPP_FE_PR=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_declarator.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\fe_interface_header.hh"\
	{$(INCLUDE)}"\fe_private.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\fe_private.obj" : $(SOURCE) $(DEP_CPP_FE_PR) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\fe\lex.yy.cc
DEP_CPP_LEX_Y=\
	{$(INCLUDE)}"\y.tab.hh"\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_declarator.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\fe_interface_header.hh"\
	{$(INCLUDE)}"\fe_private.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\lex.yy.obj" : $(SOURCE) $(DEP_CPP_LEX_Y) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\fe\y.tab.cc
DEP_CPP_Y_TAB=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_declarator.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\fe_interface_header.hh"\
	{$(INCLUDE)}"\fe_private.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\y.tab.obj" : $(SOURCE) $(DEP_CPP_Y_TAB) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
# End Target
################################################################################
# Begin Target

# Name "narrow"
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\narrow\nr_narrow.cc
DEP_CPP_NR_NA=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\nr_narrow.obj" : $(SOURCE) $(DEP_CPP_NR_NA) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
# End Target
################################################################################
# Begin Target

# Name "util"
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\util\utl_error.cc
DEP_CPP_UTL_E=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\utl_error.obj" : $(SOURCE) $(DEP_CPP_UTL_E) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\util\utl_exceptlist.cc
DEP_CPP_UTL_EX=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\utl_exceptlist.obj" : $(SOURCE) $(DEP_CPP_UTL_EX) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\util\utl_exprlist.cc
DEP_CPP_UTL_EXP=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\utl_exprlist.obj" : $(SOURCE) $(DEP_CPP_UTL_EXP) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\util\utl_global.cc
DEP_CPP_UTL_G=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\utl_global.obj" : $(SOURCE) $(DEP_CPP_UTL_G) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\util\utl_identifier.cc
DEP_CPP_UTL_I=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\utl_identifier.obj" : $(SOURCE) $(DEP_CPP_UTL_I) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\util\utl_idlist.cc
DEP_CPP_UTL_ID=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\utl_idlist.obj" : $(SOURCE) $(DEP_CPP_UTL_ID) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\util\utl_indenter.cc
DEP_CPP_UTL_IN=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\utl_indenter.obj" : $(SOURCE) $(DEP_CPP_UTL_IN) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\util\utl_labellist.cc
DEP_CPP_UTL_L=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\utl_labellist.obj" : $(SOURCE) $(DEP_CPP_UTL_L) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\util\utl_list.cc
DEP_CPP_UTL_LI=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\utl_list.obj" : $(SOURCE) $(DEP_CPP_UTL_LI) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\util\utl_namelist.cc
DEP_CPP_UTL_N=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\utl_namelist.obj" : $(SOURCE) $(DEP_CPP_UTL_N) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\util\utl_scope.cc
DEP_CPP_UTL_S=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\utl_scope.obj" : $(SOURCE) $(DEP_CPP_UTL_S) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\util\utl_stack.cc
DEP_CPP_UTL_ST=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\utl_stack.obj" : $(SOURCE) $(DEP_CPP_UTL_ST) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\util\utl_string.cc
DEP_CPP_UTL_STR=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\utl_string.obj" : $(SOURCE) $(DEP_CPP_UTL_STR) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\util\utl_strlist.cc
DEP_CPP_UTL_STRL=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\utl_strlist.obj" : $(SOURCE) $(DEP_CPP_UTL_STRL) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
# End Target
################################################################################
# Begin Target

# Name "omniORB2_be"
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\omniORB2_be\o2be_array.cc
DEP_CPP_O2BE_=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\o2be.h"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\o2be_array.obj" : $(SOURCE) $(DEP_CPP_O2BE_) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\omniORB2_be\o2be_attribute.cc
DEP_CPP_O2BE_A=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\o2be.h"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\o2be_attribute.obj" : $(SOURCE) $(DEP_CPP_O2BE_A) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\omniORB2_be\o2be_cfe_interface.cc
DEP_CPP_O2BE_C=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\drv_private.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\o2be.h"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\o2be_cfe_interface.obj" : $(SOURCE) $(DEP_CPP_O2BE_C) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\omniORB2_be\o2be_constant.cc
DEP_CPP_O2BE_CO=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\o2be.h"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\o2be_constant.obj" : $(SOURCE) $(DEP_CPP_O2BE_CO) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\omniORB2_be\o2be_enum.cc
DEP_CPP_O2BE_E=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\o2be_enum.obj" : $(SOURCE) $(DEP_CPP_O2BE_E) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\omniORB2_be\o2be_exception.cc
DEP_CPP_O2BE_EX=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\o2be_exception.obj" : $(SOURCE) $(DEP_CPP_O2BE_EX) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\omniORB2_be\o2be_field.cc
DEP_CPP_O2BE_F=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\o2be_field.obj" : $(SOURCE) $(DEP_CPP_O2BE_F) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\omniORB2_be\o2be_generator.cc
DEP_CPP_O2BE_G=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\o2be.h"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\o2be_generator.obj" : $(SOURCE) $(DEP_CPP_O2BE_G) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\omniORB2_be\o2be_interface.cc
DEP_CPP_O2BE_I=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\o2be.h"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\o2be_interface.obj" : $(SOURCE) $(DEP_CPP_O2BE_I) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\omniORB2_be\o2be_module.cc
DEP_CPP_O2BE_M=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\o2be.h"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\o2be_module.obj" : $(SOURCE) $(DEP_CPP_O2BE_M) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\omniORB2_be\o2be_name.cc
DEP_CPP_O2BE_N=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\o2be.h"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\o2be_name.obj" : $(SOURCE) $(DEP_CPP_O2BE_N) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\omniORB2_be\o2be_operation.cc
DEP_CPP_O2BE_O=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\o2be.h"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\o2be_operation.obj" : $(SOURCE) $(DEP_CPP_O2BE_O) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\omniORB2_be\o2be_union_branch.cc
DEP_CPP_O2BE_U=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\o2be.h"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\o2be_union_branch.obj" : $(SOURCE) $(DEP_CPP_O2BE_U) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\omniORB2_be\o2be_predefined_type.cc
DEP_CPP_O2BE_P=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\o2be_predefined_type.obj" : $(SOURCE) $(DEP_CPP_O2BE_P) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\omniORB2_be\o2be_root.cc
DEP_CPP_O2BE_R=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\o2be.h"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\o2be_root.obj" : $(SOURCE) $(DEP_CPP_O2BE_R) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\omniORB2_be\o2be_sequence.cc
DEP_CPP_O2BE_S=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\o2be.h"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\o2be_sequence.obj" : $(SOURCE) $(DEP_CPP_O2BE_S) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\omniORB2_be\o2be_string.cc
DEP_CPP_O2BE_ST=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\o2be.h"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\o2be_string.obj" : $(SOURCE) $(DEP_CPP_O2BE_ST) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\omniORB2_be\o2be_struct.cc
DEP_CPP_O2BE_STR=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\o2be.h"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\o2be_struct.obj" : $(SOURCE) $(DEP_CPP_O2BE_STR) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\omniORB2_be\o2be_typedef.cc
DEP_CPP_O2BE_T=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\o2be.h"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\o2be_typedef.obj" : $(SOURCE) $(DEP_CPP_O2BE_T) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
################################################################################
# Begin Source File

SOURCE=$(SRCDIR)\omniidl2\omniORB2_be\o2be_union.cc
DEP_CPP_O2BE_UN=\
	{$(INCLUDE)}"\ast.hh"\
	{$(INCLUDE)}"\ast_argument.hh"\
	{$(INCLUDE)}"\ast_array.hh"\
	{$(INCLUDE)}"\ast_attribute.hh"\
	{$(INCLUDE)}"\ast_concrete_type.hh"\
	{$(INCLUDE)}"\ast_constant.hh"\
	{$(INCLUDE)}"\ast_decl.hh"\
	{$(INCLUDE)}"\ast_enum.hh"\
	{$(INCLUDE)}"\ast_enum_val.hh"\
	{$(INCLUDE)}"\ast_exception.hh"\
	{$(INCLUDE)}"\ast_expression.hh"\
	{$(INCLUDE)}"\ast_extern.hh"\
	{$(INCLUDE)}"\ast_field.hh"\
	{$(INCLUDE)}"\ast_generator.hh"\
	{$(INCLUDE)}"\ast_interface.hh"\
	{$(INCLUDE)}"\ast_interface_fwd.hh"\
	{$(INCLUDE)}"\ast_module.hh"\
	{$(INCLUDE)}"\ast_operation.hh"\
	{$(INCLUDE)}"\ast_predefined_type.hh"\
	{$(INCLUDE)}"\ast_root.hh"\
	{$(INCLUDE)}"\ast_sequence.hh"\
	{$(INCLUDE)}"\ast_string.hh"\
	{$(INCLUDE)}"\ast_structure.hh"\
	{$(INCLUDE)}"\ast_type.hh"\
	{$(INCLUDE)}"\ast_typedef.hh"\
	{$(INCLUDE)}"\ast_union.hh"\
	{$(INCLUDE)}"\ast_union_branch.hh"\
	{$(INCLUDE)}"\ast_union_label.hh"\
	{$(INCLUDE)}"\be_extern.hh"\
	{$(INCLUDE)}"\drv_extern.hh"\
	{$(INCLUDE)}"\fe_extern.hh"\
	{$(INCLUDE)}"\global_extern.hh"\
	{$(INCLUDE)}"\idl.hh"\
	{$(INCLUDE)}"\idl_bool.hh"\
	{$(INCLUDE)}"\idl_defines.hh"\
	{$(INCLUDE)}"\idl_extern.hh"\
	{$(INCLUDE)}"\idl_fwd.hh"\
	{$(INCLUDE)}"\idl_global.hh"\
	{$(INCLUDE)}"\idl_narrow.hh"\
	{$(INCLUDE)}"\intlmacros.hh"\
	{$(INCLUDE)}"\o2be.h"\
	{$(INCLUDE)}"\nr_extern.hh"\
	{$(INCLUDE)}"\sys\TYPES.H"\
	{$(INCLUDE)}"\util.hh"\
	{$(INCLUDE)}"\utl_decllist.hh"\
	{$(INCLUDE)}"\utl_error.hh"\
	{$(INCLUDE)}"\utl_exceptlist.hh"\
	{$(INCLUDE)}"\utl_exprlist.hh"\
	{$(INCLUDE)}"\utl_identifier.hh"\
	{$(INCLUDE)}"\utl_idlist.hh"\
	{$(INCLUDE)}"\utl_indenter.hh"\
	{$(INCLUDE)}"\utl_labellist.hh"\
	{$(INCLUDE)}"\utl_list.hh"\
	{$(INCLUDE)}"\utl_namelist.hh"\
	{$(INCLUDE)}"\utl_scope.hh"\
	{$(INCLUDE)}"\utl_scoped_name.hh"\
	{$(INCLUDE)}"\utl_stack.hh"\
	{$(INCLUDE)}"\utl_string.hh"\
	{$(INCLUDE)}"\utl_strlist.hh"\
	

"$(INTDIR)\o2be_union.obj" : $(SOURCE) $(DEP_CPP_O2BE_UN) "$(INTDIR)"
   $(CPP) $(CPP_PROJ) /Tp$(SOURCE)


# End Source File
# End Target
# End Project
################################################################################
