/* ORB.java */
/* Chris Jacobi, August 20, 1997 4:07 pm PDT */

/*
 * Copyright (c) 1997 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: ORB.java,v 1.5 1997/08/20 23:10:04 jacobi Exp $ */

 
package org.omg.CORBA;

/**
 * Makes Ilu look like it were a CORBA ORB<p>
 * The purpose of this module is to be CORBA compatible; it will change
 * whenever necessary.
 *
 * It does not yet have the exact type required by CORBA.
 */
public class ORB {
     java.util.Properties props = null;
        
    /*friendly*/ ORB (java.util.Properties props) {
        if (props == null) props = System.getProperties();
        this.props = props;
    }
    
    
    /** 
     * ... 
     */
    public static ORB init () {
        xerox.ilu.Ilu.init();
        return new ORB(null);
    }
    
    /** 
     * ... 
     */
    public static ORB init (
        java.lang.String[] args, java.util.Properties props)
    {
        xerox.ilu.Ilu.init();
        return new ORB(props);
    }
    
    public org.omg.CORBA.Object 
        string_to_object(java.lang.String s) 
            throws xerox.ilu.IluSystemException
    {
        xerox.ilu.IluObject ob1 = 
            xerox.ilu.Ilu.objectFromSBH(
                s, 
                xerox.ilu.CORBA_ObjectStub.iluClass());
        if (ob1 instanceof org.omg.CORBA.Object) {
            return (org.omg.CORBA.Object) ob1;
        }  
        throw new xerox.ilu.IluSomeSystemException("ilu object isn't corba::object");
    }

    public java.lang.String object_to_string(xerox.ilu.IluObject ob) 
            throws xerox.ilu.IluSystemException
    {
        java.lang.String s = xerox.ilu.Ilu.iorOfObject(ob);
        return s;
    }
    
    BOA BOA_init() {
        return new BOA();
    }
    
    /*  missing exceptions */
    public org.omg.CORBA.Object     
        resolve_initial_references(java.lang.String object_key)
    {
        java.lang.String sbh = this.props.getProperty(object_key);
        org.omg.CORBA.Object ob = string_to_object(sbh);
        return ob;
    }
    
    public void connect(xerox.ilu.IluObject obj) {
        if (xerox.ilu.IluRT0.known(obj)) return;
        xerox.ilu.Ilu.registerTrueObject(null, obj, null, null, 0);
    }
  
} // ORB

