/* IluJava_JOps.h */
/* Chris Jacobi, July 22, 1997 4:23 pm PDT */

/*
 * Copyright (c) 1996, 1997 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: IluJava_JOps.h,v 1.8 1997/07/22 23:47:29 jacobi Exp $ */

/*
 * Handy java access operations.
 */

#ifndef _ILUJAVA_JOps_
#define _ILUJAVA_JOps_

#include "IluJava_Includes.h"
#include "IluJava_JTypes.h"

extern JArrayOfByte 
IluJava_JAoB_from8(char * data, unsigned len); 
    /* Allocates and initializes a Java array of byte.
     * data: initial data interpreted as 8 bit bytes 
     * len: length of data (or array) in 8 bit units
     * Caller owns data. 
     */


extern JArrayOfChar 
IluJava_JAoC_from8(char * data, unsigned len); 
    /* Allocates and initializes a Java array of char
     * data: initial data interpreted as 8 bit characters 
     * len: length of data in 8 bit units
     * Caller owns data 
     */


extern JArrayOfChar 
IluJava_JAoC_from16(char * data, unsigned len); 
    /* Allocates and initializes a Java array of char.
     * data: initial data interpreted as 16 bit characters 
     * len: length of data in 16 bit units
     * Caller owns data 
     */


     
extern char * 
IluJava_JString_toheap80(JString js); 
    /* Takes java string; ignores high bytes and copies low bytes
     * to a newly allocated null terminated C string (in the C heap).
     * Caller receives ownership of returned string. 
     * Special case: Converts java null to C 0. 
     */

     
extern void 
IluJava_JAoC_toC8(JArrayOfChar ja, char * buffer, unsigned cnt); 
    /* Copies java array of char into a C string buffer.
     * Restricted to 8 bit units of the java chars. 
     * buffer: string buffer; must be long enough to receive 
     * all cnt chars plus terminating 0C char.
     * cnt: Number of 8 bit units to copy  (Must be >= 1 )
     * Caller owns buffer; 
     */

#endif /* _ILUJAVA_JOps_ */

/* end */

