/* IluDebugHooks.java */
/* Chris Jacobi, June 24, 1997 4:45 pm PDT */

/*
 * Copyright (c) 1996 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: IluDebugHooks.java,v 1.8 1997/06/24 23:51:24 jacobi Exp $ */
 
/*
 * APPLET NOTE: 
 * I expect the classloader to deny access to this package from applets
 * Or, the procedure defineDebugHook must not be public.
 *
 * Native stuff in IluJava_IluDebug.c
 *
 */

package xerox.ilu;
import java.lang.System;

/** 
 * For debugging Ilu only <p>
 * @see IluDebug
 */
public class
IluDebugHooks {

    /**
     * Constructor...
     */
    public IluDebugHooks() {
    }
    
    /**
     * Initialization will make sure this package is loaded
     */
    public static void init() {
        IluInit.init();
    }
    
    /**
     * We need an instance on the native side
     * to be able to invoke methods.
     */
    private native void registerTheInst();
    private static IluDebugHooks theInst = new IluDebugHooks();
    static {
        if (IluInit.doInit()) {
            theInst.registerTheInst();
            if (IluDebug.traceGeneric() > IluDebug.dont) {
                defineDebugHook(theInst);
            }
            defineAssertionFailure(theInst);
            defineCheckFailure(theInst);
        }
    }
    
    
    /**
     * Reports an instance of this class to enable
     * the native side to call the right reportAssertionFailure<p> 
     * Used for debugging IluJava only. 
     */
    /*friendly*/ static native void 
    defineAssertionFailure(IluDebugHooks x);
    
    /**
     * This is called from the native side
     * to report errors back into the java side.
     */
    protected void
    reportAssertionFailure(java.lang.String file, int line) {
        System.err.println("! **** assertion failure");
        System.err.println("!  file: " + file + " line: " + line);
        IluDebug.panic("AssertionFailure reported from kernel"); //no return...
    }
    
    
    /**
     * Reports an instance of this class to enable 
     * the native side to call the right reportCheckFailure<p> 
     * Used for debugging IluJava only. > 
     * (Like ilu_SetCheckFailureConsumer) 
     */
    /*friendly*/ static native void  
    defineCheckFailure(IluDebugHooks x);
    
    /**
     * This is called from the runtime support side to report 
     * when a (kernel) internal consistency check fails.<p>
     */
    protected void
    reportCheckFailure(java.lang.String file, int line) {
        System.err.println("! **** internal consistency check");
        System.err.println("!  file: " + file + " line: " + line);
        try {
            throw new xerox.ilu.IluRuntimeError("print the stack trace");
        } catch (xerox.ilu.IluRuntimeError e) {
            e.printStackTrace();
            // We are not waiting but hogg the cpu so this is where the debugger
            // will interrupt us...
            IluDebug.panic("kernel consistency"); //no return...
        }
    }
    
       
    /**
     * Reports an instance of this class to enable 
     * the native side to call the right reportDebugHook<p> 
     * Used for debugging IluJava only. 
     */
    /*friendly*/ static native void  
    defineDebugHook(IluDebugHooks x);
    
    /**
     * Called when an error is being raised in the ilu kernel.
     * Should return without doing anything (visible to the
     * kernel).  Intended for debugging use by ILU maintainers 
     * only.
     */
    protected void
    reportDebugHook(java.lang.String file, int line, int errorType) {
        if (IluDebug.traceGeneric() > IluDebug.dont) {
             System.err.println("! **** ILU error " 
                 + " errorType [" + file + "] line " + line
                 );
        }
    }
    
    
} // IluDebugHooks
