/*
** Copyright (c) 1991-1995 Xerox Corporation.  All Rights Reserved.
**
** Unlimited use, reproduction, and distribution of this software is
** permitted.  Any copy of this software must include both the above
** copyright notice of Xerox Corporation and this paragraph.  Any
** distribution of this software must comply with all applicable United
** States export control laws.  This software is made available AS IS,
** and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
** INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
** AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
** PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
** THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
** CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
** XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* $Id: ilucstub.h,v 1.18 1997/11/26 20:00:50 janssen Exp $ */
/* Last edited by Mike Spreitzer March 19, 1997 10:18 am PST */

#ifndef __ilu_cstub_h_
#define __ilu_cstub_h_

#include "iluchdrs.h"

#define OPTIONAL(x)	x
#define PASS(x)		x
#define RETAIN(x)	x
#define GLOBAL(x)	x

typedef void (*_ILU_C_Method)(void);
/*
 * Actually, the type is a lie, because different methods have
 * different signatures.  But we pick one type to cast them to while
 * stored in a dispatch table.
 */

typedef struct {
  ilu_Class       ilucdts_introType;
  _ILU_C_Method  *ilucdts_methods;
}               _ILU_C_DispatchTableSection;
/*
 * Represents the part of a dispatch table concerning the methods
 * defined directly on (cc_introType).
 */

typedef struct _ILU_C_Class_s _ILU_C_Class_struct;

struct _ILU_C_Class_s {
  _ILU_C_DispatchTableSection *ilucc_sections;
  ILU_C_FinalizationProc ilucc_finalize;
};
/*
 * The dispatch table consists of a sentinel-terminated sequence of
 * sections.  The sentinel is a section whose (ilucdts_introType) is
 * NIL.  The most specific object type implemented appears in the
 * first section; the other sections do not necessarily appear in
 * any particular order.  The finalization method is represented
 * separately, because it's not introduced in ISL.
 */

struct _ILU_C_Object_s {
  /* L1, L2 unconstrained */

  ILU_C_Class     iluco_class;
  ILU_C_Server    server;
  void           *instanceData;
  struct ILU_C_InterruptHandle_s *interruptH;

  /* L1 >= {server->ilucs_ks} */

  ilu_Object      iluco_ko;
  int             iluco_refcnt;
  int             iluco_kvi;	/* iluco_ko && ilu_VeryInterested */
};

struct _ILU_C_Server_s {
  /*L1, L2 unconstrained*/
  ilu_Server      ilucs_ks;

  /*L1 >= {server->ilucs_ks}*/

  int             ilucs_refcnt;
  int             ilucs_objcnt;	/* num C objs of me */
};

typedef ilu_cardinal (*ILU_C_SizeFn) (ilu_Call c, void *p, ilu_Error * e);
/* type_kind(t) scalar:  <c_parameter_type(t, InOut)> * p;
 * type_kind(t) non-scalar:  <c_parameter_type(t, In)> p.
 */

typedef void    (*ILU_C_OutputFn) (ilu_Call c, void *p, ilu_Error * e);
/* type_kind(t) scalar:  <c_parameter_type(t, InOut)> * p;
 * type_kind(t) non-scalar:  <c_parameter_type(t, In)> p.
 */

typedef void   *(*ILU_C_InputFn) (ilu_Call c, void *p, ilu_Error * e);
/* <c_parameter_type(t, InOut)> p;
   <c_role_type(type, role_InpRet, FALSE)> returned */

typedef struct _ILU_C_IoFnsRegistration_s {
  ilu_TypeKind		type_kind;
  ilu_string		type_id;
  union {
    ilu_Class		object_class;
    ilu_cardinal	value_size;
  } properties;
  ilu_Type		kernelType;
  ILU_C_SizeFn		sizeFn;
  ILU_C_OutputFn	outFn;
  ILU_C_InputFn		inputFn;
  ILU_C_FreeFn		freeFn;
} *		ILU_C_IoFnsRegistration;

typedef struct _ILU_C_CRInfo_s {
  const struct _ILU_C_IoFnsRegistration_s *	cr_typecode;
  ILU_C_CRCreateFn		cr_create_fn;
  ILU_C_CRFreeFn		cr_free_fn;
  ILU_C_CRPreOutputFn		cr_pre_output_fn;
  ILU_C_CRPostOutputFn		cr_post_output_fn;
  ILU_C_CRPostInputFn		cr_post_input_fn;
} *	_ILU_C_CRInfo;

ILU_RUNTIME_PUBLIC OPTIONAL(_ILU_C_CRInfo)
     _ILU_C_GetCRInfo (CORBA_TypeCode);

ILU_RUNTIME_PUBLIC ilu_refany
  _ILU_C_CRCreate (_ILU_C_CRInfo,
		   ilu_cardinal /* putative size */,
		   ilu_Error *);

ILU_RUNTIME_PUBLIC void
  _ILU_C_CRFree (_ILU_C_CRInfo,
		ilu_refany	/* pointer to struct */);

ILU_RUNTIME_PUBLIC void
  _ILU_C_CRPreOutput (_ILU_C_CRInfo,
		      ilu_refany, 	/* pointer to struct */
		      ilu_Error *);

ILU_RUNTIME_PUBLIC void
  _ILU_C_CRPostOutput (_ILU_C_CRInfo,
		       ilu_refany, 	/* pointer to struct */
		       ilu_Error *);

ILU_RUNTIME_PUBLIC void
  _ILU_C_CRPostInput (_ILU_C_CRInfo,
		      ilu_refany, 	/* pointer to struct */
		      ilu_Error *);

ILU_RUNTIME_PUBLIC struct _ILU_C_IoFnsRegistration_s _CORBA_boolean__IoFns;

ILU_RUNTIME_PUBLIC struct _ILU_C_IoFnsRegistration_s _CORBA_octet__IoFns;

ILU_RUNTIME_PUBLIC struct _ILU_C_IoFnsRegistration_s _CORBA_short__IoFns;
ILU_RUNTIME_PUBLIC struct _ILU_C_IoFnsRegistration_s _CORBA_long__IoFns;
ILU_RUNTIME_PUBLIC struct _ILU_C_IoFnsRegistration_s _ilu_longinteger__IoFns;

ILU_RUNTIME_PUBLIC struct _ILU_C_IoFnsRegistration_s _CORBA_unsigned_short__IoFns;
ILU_RUNTIME_PUBLIC struct _ILU_C_IoFnsRegistration_s _CORBA_unsigned_long__IoFns;
ILU_RUNTIME_PUBLIC struct _ILU_C_IoFnsRegistration_s _ilu_longcardinal__IoFns;

ILU_RUNTIME_PUBLIC struct _ILU_C_IoFnsRegistration_s _CORBA_char__IoFns;
ILU_RUNTIME_PUBLIC struct _ILU_C_IoFnsRegistration_s _ilu_character__IoFns;

ILU_RUNTIME_PUBLIC struct _ILU_C_IoFnsRegistration_s _CORBA_float__IoFns;
ILU_RUNTIME_PUBLIC struct _ILU_C_IoFnsRegistration_s _CORBA_double__IoFns;
ILU_RUNTIME_PUBLIC struct _ILU_C_IoFnsRegistration_s _ilu_longreal__IoFns;

ILU_RUNTIME_PUBLIC struct _ILU_C_IoFnsRegistration_s _CORBA_string__IoFns;
#define _ilu_CString__IoFns _CORBA_string__IoFns

ILU_RUNTIME_PUBLIC struct _ILU_C_IoFnsRegistration_s _ilu_CORBA_Object__IoFns;

ILU_RUNTIME_PUBLIC void
  _ILU_C_RegisterIoFns (ILU_C_IoFnsRegistration);

ILU_RUNTIME_PUBLIC ILU_C_IoFnsRegistration
  _ILU_C_LookupIoFns (ilu_string);		/* type UID */

#define TC_boolean (&_CORBA_boolean__IoFns)
#define TC_CORBA_boolean (&_CORBA_boolean__IoFns)

#define TC_octet (&_CORBA_octet__IoFns)
#define TC_CORBA_octet (&_CORBA_octet__IoFns)

#define TC_short (&_CORBA_short__IoFns)
#define TC_CORBA_short (&_CORBA_short__IoFns)
#define TC_long (&_CORBA_long__IoFns)
#define TC_CORBA_long (&_CORBA_long__IoFns)
#define TC_ilu_longinteger (&_ilu_longinteger__IoFns)

#define TC_ushort (&_CORBA_unsigned_short__IoFns)
#define TC_CORBA_ushort (&_CORBA_unsigned_short__IoFns)
#define TC_CORBA_unsigned_short (&_CORBA_unsigned_short__IoFns)
#define TC_ulong (&_CORBA_unsigned_long__IoFns)
#define TC_CORBA_ulong (&_CORBA_unsigned_long__IoFns)
#define TC_CORBA_unsigned_long (&_CORBA_unsigned_long__IoFns)
#define TC_ilu_longcardinal (&_ilu_longcardinal__IoFns)

#define TC_char (&_CORBA_char__IoFns)
#define TC_CORBA_char (&_CORBA_char__IoFns)
#define TC_ilu_character (&_ilu_character__IoFns)

#define TC_float (&_CORBA_float__IoFns)
#define TC_CORBA_float (&_CORBA_float__IoFns)
#define TC_double (&_CORBA_double__IoFns)
#define TC_CORBA_double (&_CORBA_double__IoFns)
#define TC_ilu_longreal (&_ilu_longreal__IoFns)

#define TC_string (&_CORBA_string__IoFns)
#define TC_CORBA_string (&_CORBA_string__IoFns)
#define TC_ilu_CString (&_CORBA_string__IoFns)

#define TC_Object (&_ilu_CORBA_Object__IoFns)
#define TC_CORBA_Object (&_ilu_CORBA_Object__IoFns)

#ifdef ADD_VARIANT_SUPPORT

ILU_RUNTIME_PUBLIC struct _ILU_C_IoFnsRegistration_s _CORBA_any__IoFns;
#define _ilu_any__IoFns _CORBA_any__IoFns

#define TC_any (&_CORBA_any__IoFns)
#define TC_CORBA_any (&_CORBA_any__IoFns)
#define TC_ilu_any (&_CORBA_any__IoFns)

ILU_RUNTIME_PUBLIC void
  _CORBA_any__Output (ilu_Call, CORBA_any*, ilu_Error *);

ILU_RUNTIME_PUBLIC ilu_cardinal
  _CORBA_any__SizeOf (ilu_Call, CORBA_any*, ilu_Error *);

ILU_RUNTIME_PUBLIC CORBA_any *
  _CORBA_any__Input (ilu_Call, CORBA_any*, ilu_Error *);

ILU_RUNTIME_PUBLIC void
  CORBA_any__Free (CORBA_any*);

ILU_RUNTIME_PUBLIC CORBA_any *
  CORBA_sequence_CORBA_any_allocbuf (ilu_cardinal _count);

ILU_RUNTIME_PUBLIC CORBA_any *
  CORBA_any_alloc (void);

ILU_RUNTIME_PUBLIC ilu_boolean
  ILU_C_AutomaticUnpickling;
/* ilu_FALSE to prevent automatic unpickling of 'any' values */

#endif /* ADD_VARIANT_SUPPORT */

#define ILU_C_KERNEL_TYPE(tname)	(_ ## tname ## __IoFns.kernelType)

struct _ILU_C_ExceptionDescription_s {
  unsigned int    size;
  ilu_Class       *ed_class;
  ILU_C_SizeFn    sizeFn;
  ILU_C_OutputFn  outFn;
  ILU_C_InputFn   inFn;
  ILU_C_FreeFn    freeFn;
};

/* Main Invariant holds; L2 not further constrained */
ILU_RUNTIME_PUBLIC void 
_ILU_C_Object_release_full(ILU_C_Object * o,
			   char *filename, int lineno);

#define _ILU_C_Object_release(o) _ILU_C_Object_release_full(o, __FILE__, __LINE__)

ILU_RUNTIME_PUBLIC ilu_cardinal _ilu_CString__SizeOf (ilu_Call, ilu_CString, ilu_Error *);
ILU_RUNTIME_PUBLIC ilu_CString *_ilu_CString__Input (ilu_Call, ilu_CString *, ilu_Error *);
ILU_RUNTIME_PUBLIC void _ilu_CString__Output (ilu_Call, ilu_CString, ilu_Error *);
ILU_RUNTIME_PUBLIC void ilu_CString__Free (ilu_CString *);

ILU_RUNTIME_PUBLIC ilu_cardinal _ILU_C_Enumeration__SizeOf (ilu_Call, void *, ilu_Error *);
ILU_RUNTIME_PUBLIC void * _ILU_C_Enumeration__Input (ilu_Call, void *, ilu_Error *);
ILU_RUNTIME_PUBLIC void _ILU_C_Enumeration__Output (ilu_Call, void *, ilu_Error *);

/* Main invariant holds */
ILU_RUNTIME_PUBLIC void		_ILU_C_SetProtocolError (CORBA_Environment *, ilu_ProtocolException, ilu_Error *);

/* Main invariant holds */
ILU_RUNTIME_PUBLIC ilu_boolean	_ILU_C_CheckSibling (ILU_C_Object *disc,
						     ILU_C_Object *putative_sibling,
						     ILU_C_ENVIRONMENT *status);

/* Main invariant holds */
ILU_RUNTIME_PUBLIC ilu_LanguageIndex	_ILU_C_LanguageIndex;

/* Main invariant holds */
/*
  _ILU_C_GenericCall

  void _ILU_C_GenericCall (ilu_Class class, ilu_Method method,
                           _ILU_C_ExceptionDescription *evec,
                           ILU_C_Object *discriminant,
                           ILU_C_ENVIRONMENT *status,
                           char *argdesc, ...)

Operates in varargs mode, off "argdesc".  "argdesc" provides a
description of the arguments to the method, as follows:

"argdesc" contains 2 fields, separated by ':'.

The first field provides a list of the types of all the arguments
which are either In or InOut arguments, each as a one-character code.
The codes are capital letters if the argument is an InOut argument,
lower-case if an In argument.  Specific types are encoded as follows:

  a & A:  short integer
  b & B:  integer
  c & C:  long integer
  d & D:  short cardinal
  e & E:  cardinal
  f & F:  long cardinal
  g & G:  short real
  h & H:  real
  i & I:  long real
  j & J:  short character
  k & K:  character
  l & L:  long character
  m & m:  byte
  n & N:  boolean
  o & O:  enumeration
  p & P:  object
  q & Q:  string
  r & R:  wide string
  z & Z:  other

  s-y & S-Y:  reserved for future use

The following table tells what's found in the varargs list for each case:

a,d,j,k,m,n:	int
b,c,e,f,g,h,i,l,o: <c_parameter_type(t, In)>
A-O:		<c_parameter_type(t, InOut)>
p:		<c_parameter_type(t, In)>,	ilu_Class pclass
P:		<c_parameter_type(t, InOut)>,	ilu_Class pclass
q, r:		<c_parameter_type(t, In)>,	ilu_cardinal limit
Q, R:		<c_parameter_type(t, InOut)>,	ilu_cardinal limit
z:		<c_parameter_type(t, In)>,	ILU_C_{Size,Output}Fn
Z:		<c_parameter_type(t, InOut)>,	ILU_C_{Size,Output}Fn

The sequence of value specified by the first field of "argdesc"
actually appears twice in the varargs part of the _ILU_C_GenericCall
arglist, once for a sizing pass and once for an output pass (there is
no assurance that "va_start" can be called twice in the same
function).

The second field of "argdesc" contains a list of the types of all the
arguments which are either the return type of the method, or Out or
InOut arguments to the method, again as one-character codes, using the
same coding scheme, but this time with lower-case characters
representing Out arguments.  For the purposes of this routine, the
return value of the method is passed and coded as another Out
argument.  The return value argument appears before the actual Out and
InOut arguments in the arglist.

The following table tells what's found in the varargs list for each case:

a-o, A-O:	<c_parameter_type(t, InOut)>
p, P:		<c_parameter_type(t, InOut)>,	ilu_Class pclass
q, r, Q, R:	<c_parameter_type(t, InOut)>,	ilu_cardinal limit
y:		<c_type_role(t, role_InpRet, FALSE)>*, ILU_C_InputFn
z, Z:		<c_parameter_type(t, InOut)>,	ILU_C_InputFn


*/
ILU_RUNTIME_PUBLIC void
  _ILU_C_GenericCall (ilu_Class objtype, ilu_Method method,
		      _ILU_C_ExceptionDescription *evec,
		      ILU_C_Object *discriminant,
		      ILU_C_ENVIRONMENT *status,
		      char *argdesc, ...);

typedef struct _ILU_C_ParmDesc_s {
  unsigned				parm_out : 1;
  unsigned				parm_in : 1;
  unsigned				parm_needs_dereference : 1;
  unsigned				parm_needs_assignment : 1;
  unsigned				parm_extensible_record : 1;
  struct _ILU_C_IoFnsRegistration_s *	parm_type;
  void *				parm_val;	/* <c_parameter_type(t, InOut)> */
} _ILU_C_ParmDesc;

ILU_RUNTIME_PUBLIC void
  _ILU_C_VectorCall (ilu_Class pclass, ilu_Method method,
		     _ILU_C_ExceptionDescription *evec,
		     ILU_C_Object *discriminant,
		     ILU_C_ENVIRONMENT *status,
		     ilu_cardinal nparms,
		     _ILU_C_ParmDesc *parms);

/*L1, L2 unconstrained*/
ILU_RUNTIME_PUBLIC void
_ILU_C_ConvertError(ILU_C_ENVIRONMENT * env,
		    ilu_Error * err,
		    ILU_C_COMPLETIONSTATUS cstat);
/*
 * Stubs call this when the kernel raises an error, to convert the
 * error into CORBA terms.  Sets *env (to a CORBA_SYSTEM_EXCEPTION
 * or CORBA_NO_EXCEPTION) according to *err and cstat. Calls
 * ILU_HANDLED(*err);
 */

/*L1, L2 unconstrained*/
#define _ILU_C_ConvertErrorQ(env,err,cc) \
	_ILU_C_ConvertError(env,err,ILU_C_COMPLETION(cc))

/*before: not Inside (cobj->server, cobj->type->c) */
/*after:  return != NULL => Inside(cobj->server, cobj->type->c) */
ILU_RUNTIME_PUBLIC ilu_Object _ILU_C_KernelObjOfObj(ILU_C_Object *);

/* L1, L2, Main unconstrained */
ILU_RUNTIME_PUBLIC void 
_ILU_C_RegisterSurrogateCType(GLOBAL(ilu_Class) ilutype,
			      GLOBAL(ILU_C_Class) iluc_class);

/* L1, L2, Main unconstrained */
ILU_RUNTIME_PUBLIC _ILU_C_Method
_ILU_C_FindMethod(RETAIN(ILU_C_Object *), GLOBAL(ilu_Class), int);

/**before: Call-Locking(call, IHi);
    after: Call-Invariant(call, err),
	   success => Call-Locking(call, VLo)*/
ILU_RUNTIME_PUBLIC          ilu_boolean
_ILU_C_FinishParameters(ilu_Call,
			OPTIONAL(ILU_C_Object * disc),
			ILU_ERRS((bad_locks, broken_locks)) *err);
/*
 * Calls ilu_RequestRead, and re-registers request handler if
 * appropriate.
 */

/**before: Main Invariant && Call-VLo(call);
    after: Call-Invariant(call, err),
	   success => call->ca_ms == ilu_cmsHi. */
ILU_RUNTIME_PUBLIC ilu_boolean 
_ILU_C_BeginReply(ilu_Call call, ilu_boolean exceptions,
		  ilu_cardinal argSize,
		  ILU_ERRS((bad_locks, IoErrs)) *err);

/**before: Main Invariant && Call-VLo(call);
    after: Call-Invariant(call, err),
	   success => call->ca_ms == ilu_cmsHi. */
ILU_RUNTIME_PUBLIC ilu_boolean 
_ILU_C_BeginException(ilu_Call call, ilu_cardinal evalue,
		      ilu_cardinal argSize,
		      ILU_ERRS((bad_locks, IoErrs)) *err);

/*Main Invariant; Call-Locking(call, OHi)*/
ILU_RUNTIME_PUBLIC          ilu_boolean
_ILU_C_FinishReply(ilu_Call call, ILU_ERRS((bad_locks, IoErrs)) *err);

/*Main Invariant; Call-Locking(call, OHi)*/
ILU_RUNTIME_PUBLIC ilu_boolean 
_ILU_C_FinishException(ilu_Call call, ILU_ERRS((bad_locks, IoErrs)) *err);

/**before: Main Invariant && Call-Lo(call);
    after: Call-Invariant(call, err),
	   success => call->ca_ms == ilu_cmsHi. */
ILU_RUNTIME_PUBLIC void 
_ILU_C_SendException(ilu_Call call, _ILU_C_ExceptionDescription *evec,
		     ILU_C_ENVIRONMENT * status, ilu_Error * err);

/* Main Invariant */
ILU_RUNTIME_PUBLIC void 
_ILU_C_FreeException(ilu_Method method, _ILU_C_ExceptionDescription *evec,
		     ILU_C_ENVIRONMENT * status, ilu_Error * err);

/**before: Main Invariant, Call-Lo(call);
    after: Call-Invariant(call, err),
	   success => call->ca_ms == ilu_cmsNo*/
ILU_RUNTIME_PUBLIC          ilu_boolean
_ILU_C_NoReply(ilu_Call call,
	     ILU_ERRS((bad_param, bad_locks, broken_locks)) * err);

/**Before: Call-Invariant(call, err);
    After: Main Invariant*/
ILU_RUNTIME_PUBLIC void _ILU_C_FinishServingCall(ilu_Call call, ilu_Error *err);

/**before: Main Invariant, Call-Hi(call);
    after: Call-Invariant(call, err) && call->ca_ms == ilu_cmsHi*/
ILU_RUNTIME_PUBLIC ILU_C_Object *
_ILU_C_GetServerSingleton(ilu_Call, ILU_ERRS((bad_param)) *err);

/* L1, L2, Main unconstrained */
ilu_boolean _ILU_C_IsSingleton (ilu_Class c);

/*Main invariant, Call-Hi(call)*/
ILU_RUNTIME_PUBLIC ILU_C_Object *
_ILU_C_InputObject(ilu_Call call, ilu_Class putative_class,
		   ilu_boolean discriminator_p,
		   ILU_ERRS((IoErrs)) * err);

/*Main invariant, Call-Hi(call)*/
ILU_RUNTIME_PUBLIC          ilu_boolean
_ILU_C_OutputObject(ilu_Call call, ILU_C_Object * obj,
		    ilu_Class putative_class,
		    ilu_boolean discriminator_p,
		    ILU_ERRS((IoErrs)) * err);

/* Main invariant holds */
ILU_RUNTIME_PUBLIC          ilu_cardinal
_ILU_C_SizeOfObject(ilu_Call call, ILU_C_Object * obj,
		    ilu_Class putative_class,
		    ilu_boolean discriminator_p,
		    ILU_ERRS((IoErrs)) *err);

/* Main invariant holds */
ILU_RUNTIME_PUBLIC ilu_boolean
  _ILU_C_SetCallerContext (ilu_Passport);
/*
 * Associate the given ilu_Passport with future calls made in the
 * same thread, until overridden by a later call on
 * ILU_C_SetPassportContext.
 */

/* Unrestricted */
ILU_RUNTIME_PUBLIC void _ILU_C_ExtendString (CORBA_char **s, CORBA_char item, CORBA_boolean atend);

/* Unrestricted */
ILU_RUNTIME_PUBLIC void _ILU_C_ExtendWString (ilu_character **s, ilu_character item, CORBA_boolean atend);

/* Unrestricted */
ILU_RUNTIME_PUBLIC void _ILU_C_PopString (CORBA_char **s, CORBA_char *item);

/* Unrestricted */
ILU_RUNTIME_PUBLIC void _ILU_C_PopWString (ilu_character **s, ilu_character *item);

/* Unrestricted */
ILU_RUNTIME_PUBLIC unsigned int _ILU_C_SafeStrlen(RETAIN(char *str));

/* Unrestricted */
ILU_RUNTIME_PUBLIC unsigned int _ILU_C_SafeWStrlen(RETAIN(ilu_character * str));

/* Unrestricted */
ILU_RUNTIME_PUBLIC          PASS(void *) _ILU_C_MallocFailure(CORBA_unsigned_long /* nbytes */);

/*Main invariant holds*/
ILU_RUNTIME_PUBLIC void     _ILU_C_EnsureGcClient(void);
/* The stubs of an interface that defines collectible object types
   calls this at least once, at intialization time. */

#undef OPTIONAL
#undef RETAIN
#undef PASS
#undef GLOBAL

#endif

