#!/bin/sh
#
# Determine the current Fully Qualified Domain Name.
# Returns 0, and prints FQDN to stdout, for success; returns 1 otherwise
#
get_fqdn() {
    domain=null

    myhost=`uname -n 2>/dev/null`

    # If uname did not get a fully qualified name, try hostname...

    case $myhost in
    *.* )
	;;
    * )
	myhost=`hostname 2>/dev/null`
	# If hostname failed entirely, go back to uname.
	if [ x$myhost = x ]; then
	    myhost=`uname -n 2>/dev/null`
	fi
	;;
    esac

    # If uname or hostname did not get a fully qualified name, try nslookup...

    case $myhost in
    *.* )
	fulldname=$myhost
	;;
    * )
	type nslookup > /dev/null 2>&1
	if [ $? = 0 ] ; then
		type awk > /dev/null 2>&1
		if [ $? = 0 ] ; then
			fulldname=`nslookup $myhost 2>&1 | awk '/Name:/ {print $2}'`
		fi
	fi;
    esac

    # if we didn't get it from uname|hostname+nslookup, try the smtp daemon...

    case $fulldname in
    *.* )
	;;
    * )
	# check the banner message from the smtp server...
	fulldname=`(sleep 1; echo quit) |telnet localhost smtp 2>&1 | \
		sed -n 's/^.*220[ -]\([^ ]*\) .*$/\1/p'`
    esac

    # trim off the first field, which is the machine name...

    domain=`echo "$fulldname" | sed 's/^[^.]*\.//g'`

    # if we don't have anything left, we failed...

    [ "$domain" = "" ] && return 1

    # but if we do, we succeeded, and "domain" is properly bound!

    return 0
}

get_fqdn; [ $? != 0 ] && exit 1
echo $domain
exit 0
