import sys

if '-mt' in sys.argv:
	import thread
	import ilu
	ilu.ThreadedOperation()
else:
	import ilu

import objtable, objtable__skel

class realFile(objtable__skel.file):
	def __init__(self, filename, ih=None, server=None):
		self.IluServer = server
		self.IluInstHandle = ih or filename
		self.filename = filename

	def name (self):
		return self.filename

class realServer(objtable__skel.server):
	def __init__(self, ih=None, server=None):
		self.IluServer = server
		self.IluInstHandle = ih or filename

	def find_file(self, name):
		return realFile(name, name, self.IluServer)

loopvar = ilu.CreateLoopHandle();

theServer = None

def createInstance (ih):
	return realFile(ih, ih, theServer)

def main():
  global theServer

  instHandle = "----"
  serverId = sys.argv[1]

  theServer = ilu.CreateServer(serverId,("sunrpcrm", "tcp_0_0",), "sunrpc_2", createInstance)
  uc = realServer(instHandle, theServer)

  uc.IluPublish()

  print "exported", uc.IluSBH()

  ilu.RunMainLoop(loopvar)

main()
