/* TestReceiving.java */
/* Chris Jacobi, October 24, 1997 1:28 pm PDT */

/*
 * Copyright (c) 1997 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: TestReceiving.java,v 1.3 1997/10/24 20:32:17 jacobi Exp $ */

package otherpackage; 


/**
 * This class is the client side of a sample application of 
 * full custom mapping.
 */
class TestReceiving {
      
    static testJavaSerialObjects.ObjectGetter getter;
        
    static void handleIn() {
        try {
            java.lang.Object obj;
            System.out.println("Looking up a getter");
            getter = (testJavaSerialObjects.ObjectGetter) 
                xerox.ilu.IluSimpleBinding.lookup(
                    "JavaPiTeServer", 
                    "myFactory", 
                    testJavaSerialObjects.ObjectGetterStub.iluClass()
                    );
            System.out.println("Got a getter " + getter);
            //
            //Get the first object ...
            obj = getter.GetIt();
            System.out.println("First returned object is: " + obj);
            //
            //Get a second object ...
            obj = getter.GetIt();
            System.out.println("Second returned object is: " + obj);
            //
            //Get a third object ...
            obj = getter.GetIt();
            System.out.println("Third returned object is: " + obj);
        } catch (xerox.ilu.IluSystemException e) {
            System.err.println("Caught an ilu exception: " + e );
        }
    } //handleIn

    public static void main(String argv[]) {
        System.out.println("Start TestReceiving...");
        xerox.javaSerialObjects._allJavaStubs.load();
        testJavaSerialObjects._allJavaStubs.load();
        System.out.println("All the junk is loaded");
        handleIn();
    } //main

} //TestReceiving

