#ifndef _ILUGSS_ASN1_H
#define _ILUGSS_ASN1_H 1
/*
 * gss_asn1.h -- interface to routines for doing ASN.1 encoding / decoding
 *		 from elsewhere in the GSS
 * 
 * Antony Courtney,	7/7/95
 */

/* _ilugss_asn1_extract_oid() -- extract OID from start of a packet
 * returns: a pointer to an OID; modifies token_buffer to contain contents
 * of packet with the OID removed from start
 */
gss_OID _ilugss_asn1_extract_oid(gss_buffer_t token_buffer);

/* _ilugss_asn1_wrap_oid() -- creates a new packet with OID inserted at the
 * front; uses single buffer for both input and output
 */
void _ilugss_asn1_wrap_oid(gss_OID oid,gss_buffer_t token_buffer);

#endif	/* _ILUGSS_ASN1_H */
