 
#include <iostream.h>
#include <gtk--.h>

// Main idea of this test program is to test how connections work in gtk.
//
// It does not do anything too neat, just prints some dummy things to
// console.

class MyWin : public Gtk_Window
{
	Gtk_VBox box;
	Gtk_ScrolledWindow swin;
	Gtk_Button b;
	Gtk_Tooltips btip;
	Gtk_Entry text;
	Gtk_Viewport footext;
	
	int num;
	
	// Connection-objects can be used for disconecting a connection.
	// it isnt necessary to know about these at all, they are here
	// for easier use of connect().
	Connection c1,c2,c3,c4;
	bool init;
public:  
	Signal1<GdkEventKey *> keyPressed;
	Signal1<gint> foo;
	Signal0 test;
	Signal0 test2;
	
private:
	Gtk_FileSelection *fs;
	void buttoncanceled() {
		cout << "File NOT Selected " << fs->get_filename() << endl;
		fs->hide();
	}
	void buttonpressed() {
		cout << "File Selected " << fs->get_filename() << endl;
		fs->hide();
	}
	void dohello(){
		cout << "Button pushed - number was " << num << endl;
		if (!fs) { 
		    // seems that creating new widget takes time.. 
		    // better do it once and then just hide and show that one
		    // this way you wont get million similar windows to the 
		    // screen either...
		    fs=new Gtk_FileSelection("File Selection");
		    connect_to_method(fs->ok_button.clicked,this,&buttonpressed);
		    connect_to_method(fs->cancel_button.clicked,this,&buttoncanceled);
		}
		fs->show();
	}
	
	void dohello_cb(void *){cout << "Button pushed_cb - number was " << num << endl;}
	
	void keypress(GdkEventKey *event)
	{ 
		// sending foo and keyPressed-signals.
		foo(10); keyPressed(event); 
		test();
		c1.disconnect(); // now we'll test disconnecting the connections.
		c2.disconnect();
		c3.disconnect();
		c4.disconnect();
		cout << "Keypress was " << event->keyval << endl;
	}
	
public:
	
	virtual gint expose_event_impl(GdkEventExpose* e) { // catch expose events. 
		printf("expose!\n");
		Gtk_Widget::expose_event_impl(e);
		return 0;
	}
	
	//void show_impl() { printf("SHOW\n"); } // uncomment this and you wont see the window ever :)
	
	virtual int doblah(GdkEventAny*) { b.pressed(); cout << "Blah: " << endl; return 0; }
	int doblah_cb(GdkEventAny*,void*) { cout << "Blah_cb: " << endl; return 0; }
	
	virtual void doblah1(gint a) { b.pressed(); cout << "Blah: " << a << endl; }
	void doblah1_cb(gint a,void*) { cout << "Blah_cb: " << a << endl; }
	
	
	
	MyWin(gint num);
};

MyWin::MyWin(int num)
	: Gtk_Window(GTK_WINDOW_TOPLEVEL),
	  box(true,0),
	  b("Push me"),
	  num(num), init(false), fs(0)
{
	// vbox
	add(&box);
	box.show();
	
	// button
	box.pack_start(&b);
	box.pack_start(&swin);
	swin.add(&footext);
	// connect gtk signal to c++ function
	c1=connect_to_method(b.pressed,this,&dohello);
	connect_to_method(b.clicked,this,&dohello_cb,(void*)0);
	
	// connect sig0 to c++ function
	connect_to_method(test,this,&dohello);
	connect_to_method(test,this,&dohello_cb,(void*)0);
	
	// connect c++ signal to c++ function from gtk--
	c3=connect_to_method(foo,this,&border_width);
	
	// connect c++ signal to user function
	c4=connect_to_method(foo,this,&doblah1);
	c2=connect_to_method(foo,this,&doblah1_cb,(void*)0);
	
	// connect signal to another signal's "emit()"
	connect_to_signal(test,test2); 

	btip.set_tip(&b,"This button is connected using the new c++ signal handler code.","private string");
	b.show();
	
	// text entry
	box.pack_start(&text);
	text.show();
	footext.show();
	swin.show();
	
}

static void staticfunction(GdkEventKey* a) {
	printf("Staticfunction called! %p\n",a);
}

static void staticfunction_cb(GdkEventKey* a,void *) {
	printf("Staticfunction-cb called! %p\n",a);
}

Gtk_Main *mainwidget;

static int myquit(GdkEventAny*) {
	printf("MYQUIT\n");
	mainwidget->quit();
	return 0;
}

int
main(int argc, char *argv[])
{
	Gtk_Main myapp(&argc, &argv);
	mainwidget=&myapp;
	MyWin mywin(5);
	connect_to_method(mywin.delete_event,&mywin,&MyWin::doblah);
	connect_to_function(mywin.delete_event,&myquit);
	
	mywin.show();
	
	// connecting to static function
	connect_to_function(mywin.keyPressed,&staticfunction); 
	connect_to_function(mywin.keyPressed,&staticfunction_cb,(void*)0);
	
	myapp.run();
	return 0;
}






