/* Give the age of a PR.
   Copyright (C) 1994, 95, 96, 1997 Free Software Foundation, Inc.
   Contributed by Brendan Kehoe (brendan@cygnus.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111, USA.  */

#include "config.h"
#include "gnats.h"
#include "query.h"

void usage (), version ();

/* The name of the GNATS server.  */
char *name;

/* The name this program was run with.  */
char *program_name;

/* If 1, give the age in terms of business hours.  */
int business_time = 0;

/* If 1, we're running the daemon.  */
int is_daemon = 0;

typedef struct _times
{
  int days;
  int hours;
} Times;

struct option long_options[] =
{
  {"business-time", 0, NULL, 'b'},
  {"version", 0, NULL, 'V'},
  {"help", 0, NULL, 'h'},
  {NULL, 0, NULL, 0}
};

Times *
time_diff (then)
     time_t then;
{
  Times *t = (Times *) xmalloc (sizeof (Times));
  time_t seconds = time (0);
  time_t diff = seconds - then;
  time_t days, hours;

  days = (diff / 3600) / 24;
  diff -= (days * 86400); /* days * 60 * 60 * 24 */
  hours = diff / 3600;

  t->days = days;
  t->hours = hours;
  return t;
}

void
report_age (p)
     char *p;
{
  char *path;

  if (((char *) strchr (p, '/')) == NULL)
    path = get_category (p);
  else
    {
      path = (char *) xmalloc (PATH_MAX);
      sprintf (path, "%s/%s", gnats_root, p);
    }

  if (path)
    {
      if (get_pr (path, p, 0))
	{
	  time_t then = get_date (pr[ARRIVAL_DATE].value, NULL);
	  Times *t;
	  if (! then)
	    {
	      fprintf (stderr, "%s: don't know the time for %s\n",
		       program_name, p);
	      exit (1);
	    }
	  t = time_diff (then);
	  printf ("%3d %2d\n", t->days, t->hours);
	  xfree ((char*)t);
	}

      xfree (path);
    }
}

int
main (argc, argv)
     int argc;
     char **argv;
{
  int optc;
  program_name = basename (argv[0]);

  name = gnats_server;

  while ((optc = getopt_long (argc, argv, "bhV",
			      long_options, (int *) 0)) != EOF)
    {
      switch (optc)
	{
	case 'b':
	  business_time = 1;
	  break;

	case 'V':
	  version ();
	  exit (0);
	  break;

	case 'h':
	  usage (0);
	  break;

	default:
	  usage (1);
	}
    }

  if (optind == argc || optind >= argc)
    usage (1);

  configure ();
  init_gnats ();

  index_chain = get_index ();
  if (index_chain == NULL)
    {
      fprintf (stderr, "%s: couldn't read the index\n", program_name);
      exit (1);
    }

  report_age (argv[1]);
  exit (0);
}

void
usage (x)
  int x;
{
  fprintf (stderr, "Usage: %s [-b] [--business-time] PR\n", program_name);
  exit (x);
}

void
version ()
{
  printf ("pr-age %s\n", version_string);
}
