##############################################################################
##                                                                          ##
##                          GNAT COMPILER COMPONENTS                        ##
##                                                                          ##
##                           V M S _ H A N D L E R                          ##
##                                                                          ##
##                             $Revision: 1.1 $                             ##
##                                                                          ##
##                       Assembler Implementation File                      ##
##                                                                          ##
##           Copyright (C) 1996, 1997 Free Software Foundation, Inc.        ##
##                                                                          ##
## GNAT is free software; you can  redistribute it  and/or modify it under  ##
## terms of the  GNU General Public License as published  by the Free Soft- ##
## ware  Foundation;  either version 2,  or (at your option) any later ver- ##
## sion. GNARL is distributed in the hope that it will be useful, but WITH- ##
## OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY ##
## or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License ##
## for  more details.  You should have  received  a copy of the GNU General ##
## Public License  distributed with GNARL; see file COPYING.  If not, write ##
## to  the Free Software Foundation,  59 Temple Place # Suite 330,  Boston, ##
## MA 02111#1307, USA.                                                      ##
##                                                                          ##
## As a  special  exception,  if you  link  this file  with other  files to ##
## produce an executable,  this file does not by itself cause the resulting ##
## executable to be covered by the GNU General Public License. This except- ##
## ion does not  however invalidate  any other reasons  why the  executable ##
## file might be covered by the  GNU Public License.                        ##
##                                                                          ##
## GNAT was originally developed  by the GNAT team at  New York University. ##
## It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). ##
##                                                                          ##
##############################################################################

##  This is an OpenVMS/Alpha file

	.set noreorder
	.set volatile
	.file	1 "vmshandler.s"
gcc2_compiled.:
__gnu_compiled_c:
.text
	.align 3
	.globl __gnat_error_prehandler
	.ent __gnat_error_prehandler
__gnat_error_prehandler..en:
	.base $27
	bis $30,$30,$22		#save stack pointer in temporary register
	bis $29,$29,$23		#save frame pointer in temporary register
	lda $1,32($27)		#same instruction as that generated by
				# lda $1,__gnat_error_prehandler_stack below.
	ldq $1,0($1)
	ldq $1,0($1)
	lda $30,0($1)		#new small stack
	lda $30,-56($30)	#carve off a chunk of stack for local use
	stq $26,8($30)
#
# Save all the important registers
#
	stq $22,16($30)		#save original stack pointer
	stq $23,24($30)		#save original frame pointer
	stq $16,32($30)		#save original arguments to handler
	stq $17,40($30)
	stq $29,48($30)
	.mask 0x20000000,0
	stq $27,0($30)
	bis $30,$30,$29
	.frame $29,56,$26,8
	.prologue
.link
	.align 3
__gnat_error_prehandler:
	.pdesc __gnat_error_prehandler..en,stack
.text
	lda $1,__gnat_error_prehandler_stack	#this seems to be neccessary in order for
				# above lda $1,32($27) to work.
#
# Now get the per thread stack.
#
	bis $31,0,$25
	lda $1,system__task_specific_data__get_exc_stack_addr..lk
	ldq $26,0($1)
	ldq $27,8($1)
	jsr $26,system__task_specific_data__get_exc_stack_addr
	ldq $27,0($29)
	ldq $26,8($29)
#
# Retrieve all the save data so it can be copied to the new stack
#
	ldq $22,16($29)
	ldq $23,24($29)
	ldq $16,32($29)
	ldq $17,40($29)
	lda $30,0($0)		#new per thread stack.
	lda $30,-56($30)	#carve off a chunk.
#
# Save all the data on the new stack
#
	stq $26,8($30)
	stq $22,16($30)
	stq $23,24($30)
	stq $16,32($30)
	stq $17,40($30)
	stq $29,48($30)
	stq $27,0($30)
	bis $30,$30,$29
#
# Retrieve the original arguments and call the real error handler.
#
	bis $31,2,$25
	ldq $16,32($29)
	ldq $17,40($29)
	lda $1,__gnat_error_handler..lk
	ldq $26,0($1)
	ldq $27,8($1)
	jsr $26,__gnat_error_handler
	ldq $27,0($29)
#
# Return to caller in the unlikely case we get here.
#
	bis $29,$29,$30
	ldq $26,8($30)
	ldq $29,24($30)		#reload original frame pointer
	ldq $30,16($30)		#reload original stack pointer
	ret $31,($26),1
	.end __gnat_error_prehandler
	.comm __gnat_error_prehandler_stack,4
.rdata
	.align 3
__gnat_error_handler..lk:
	.linkage __gnat_error_handler
system__task_specific_data__get_exc_stack_addr..lk:
	.linkage system__task_specific_data__get_exc_stack_addr
