------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                 S Y S T E M . T I M E _ O P E R A T I O N S              --
--                                                                          --
--                                  B o d y                                 --
--                         (Version for new GNARL)                          --
--                                                                          --
--                             $Revision: 1.8 $                            --
--                                                                          --
--             Copyright (C) 1991-1997, Florida State University            --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

--  This is a Solaris version of this package.

--  DO NOT EDIT this file.
--  It was automatically generated from another file by the m4 macro processor.
--  The name of the file you should edit is the same as this one, but with
--  ".ads" replaced by ".sm4", or
--  ".adb" replaced by ".bm4", or
--  ".c" replaced by ".cm4", or
--  ".dat" replaced by ".tm4"

--  Local options selected:
--    __TARGET            = sparc-sun-solaris2
--    __ARCH              = SPARC
--    __OS                = SUNOS5X
--    __HAS_SIGCONTEXT    = 0
--    __HAS_UCONTEXT      = 1
--    __THREADS           = SOLARIS_THREADS
--    __THREAD_VARIANT    = NA
--    __HAS_TIMESPEC      = 1
--    __HAS_NANOSLEEP     = 1
--    __HAS_CLOCK_GETTIME = 1
--    __HAS_GETTIMEOFDAY  = 1
--    __POSIX_THREAD_PRIO_PROTECT = 0
--    __POSIX_THREAD_PRIO_INHERIT = 0
--    __POSIX_THREAD_ATTR_STACKADDR = 0
--    __POSIX_THREAD_ATTR_STACKSIZE = 0
--    __POSIX_THREAD_PRIORITY_SCHEDULING = 0

with System.Error_Reporting;
--  used for Shutdown

with System.OS_Interface;

with Interfaces.C;

with System.Task_Primitives.Operations;
--  used for Clock
--           Task_ID
--           Self

package body System.Time_Operations is

   use System.Error_Reporting;
   use System.OS_Interface;
   use Interfaces.C;
   use System.Task_Primitives.Operations;

   --  For abortion safety, we need to
   --  implement these using cond_timedwait. Use the service provided by
   --  System.Task_Primitives.Operations.

   --  -----------------
   --  -- Delay_Until --
   --  -----------------

   procedure Delay_Until (Abs_Time : Duration) is
      Self_ID   : Task_ID;
      Timed_Out : Boolean;
   begin
      if Abs_Time <= Clock then
         thr_yield;
         return;
      end if;
      Self_ID := Self;
      Write_Lock (Self_ID);
      Sleep_Until (Self_ID, Abs_Time, Timed_Out);
      Unlock (Self_ID);
   end Delay_Until;

   ---------------
   -- Delay_For --
   ---------------

   procedure Delay_For (Rel_Time : Duration) is
   begin
      Delay_Until (Clock + Rel_Time);
   end Delay_For;

end System.Time_Operations;
