#!	/bin/sh
set -e
umask 022
VERSION=__version__
readonly Arch=__arch__
if [ ! install.sh ]; then
	echo 	"Error: Change directory to the boot disk before running this script."
	1>&2
	exit -1
fi
if [ $# -gt 0 ]; then
	DDIR=$1
fi
if [ ! -d ${DDIR}/boot ]; then
	mkdir -m 755 ${DDIR}/boot
fi
cp linux ${DDIR}/boot/vmlinuz-${VERSION}
if [ ! "$Arch" = "m68k" -a ! "$Arch" = "sparc" ]; then
	rdev ${DDIR}/boot/vmlinuz-${VERSION} ${DDIR}
	rdev -r ${DDIR}/boot/vmlinuz-${VERSION} 0
	rdev -R ${DDIR}/boot/vmlinuz-${VERSION} 1
	rdev -v ${DDIR}/boot/vmlinuz-${VERSION} -1
fi
if [ -f sys_map.gz ]; then
	zcat < sys_map.gz > ${DDIR}/boot/System.map-${VERSION}
fi
if [ -f ${DDIR}/vmlinuz ]; then 
	rm -f ${DDIR}/vmlinuz.old
	mv -f ${DDIR}/vmlinuz ${DDIR}/vmlinuz.old
	rm -f ${DDIR}/vmlinuz
fi
(cd ${DDIR}/; ln -s boot/vmlinuz-${VERSION} vmlinuz)
if [ -f ${DDIR}/System.map ]; then 
	rm -f ${DDIR}/System.map
fi
sync
exit 0
