// -*- C++ -*-
/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor
* 	 
*	    Copyright (C) 1995 Matthias Ettrich
*
*======================================================*/

#ifndef _LAYOUT_H
#define _LAYOUT_H

#include "lyxlex.h"

/* the different border types */ 
#define BORDER_MANUAL 0
#define BORDER_FIRST_DYNAMIC 1
#define BORDER_DYNAMIC 2
#define BORDER_STATIC 3
#define BORDER_RIGHT_ADDRESS_BOX 4


/* the different LaTeX-Types */ 
#define LATEX_PARAGRAPH 0
#define LATEX_COMMAND 1
#define LATEX_ENVIRONMENT 2
#define LATEX_ITEM_ENVIRONMENT 3
#define LATEX_LIST_ENVIRONMENT 4


/* the different label types */ 
#define LABEL_NO_LABEL 0
#define LABEL_MANUAL 1
#define LABEL_TOP_ENVIRONMENT 2


/* the flushright labels following now must start with LABEL_STATIC */ 
#define LABEL_STATIC 3		       
#define LABEL_SENSITIVE 4
#define LABEL_FIRST_COUNTER 5
#define LABEL_COUNTER_CHAPTER 5
#define LABEL_COUNTER_SECTION 6
#define LABEL_COUNTER_SUBSECTION 7
#define LABEL_COUNTER_SUBSUBSECTION 8
#define LABEL_COUNTER_PARAGRAPH 9
#define LABEL_COUNTER_SUBPARAGRAPH 10
#define LABEL_COUNTER_ENUMI 11
#define LABEL_COUNTER_ENUMII 12
#define LABEL_COUNTER_ENUMIII 13
#define LABEL_COUNTER_ENUMIV 14


/* fix labels are printed flushright, manual labels flushleft. 
* BORDER_MANUAL and BORDER_FIRST_DYNAMIC are *only* for LABEL_MANUAL,
* BORDER_DYNAMIC and BORDER_STATIC are *not* for LABEL_MANUAL. 
* This seems a funny restriction, but I think other combinations are
* not needed, so I will not change it yet. 
* Correcton: BORDER_FIRST_DYNAMIC also usable with LABEL_STATIC */


/* there is a parindent and a parskip. Which one is used depends on the 
* paragraph_separataion-flag of the text-object. 
* BUT: parindent is only thrown away, if a parskip is defined! So if you
* want a space betweend the paragraphs and a parindent at the same time, 
* you should set parskip to zero and use topsep, parsep and bottomsep.
* 
* The standard layout is an exception: its parindent is only set, if the 
* previous paragraph is standard too. Well, this is LateX and it is good! */ 


class LyXLayout {
public:
	LyXLayout ();
	~LyXLayout ();
	void Copy (LyXLayout &l);
	int Read (LyXLexClass);

	char type;
	char *name;
   
	LyXFont font;
	LyXFont labelfont;
	char *leftborder;
	char *rightborder;
   
	char *labelsep;
	char *labelindent;
	char *parindent;
	float parskip;
	float itemsep;
   
	float topsep;
	float bottomsep;
	float parsep;

	char *labelstring;
	
	char align;
	char alignpossible;
	char labeltype;
	char bordertype;
	
	float baselinestretch;
	
	char fill_top;
	char fill_bottom;
  
	char latextype;
	char *latexname;
  
	char newline_allowed;
   
	char nextnoindent;
	char free_spacing;
};


class LyXTextClass  {
public:
	LyXTextClass ();
	~LyXTextClass();
	void Copy (LyXTextClass &l);
	int Read (char *filename);
	char *name;
	LyXLayout* style;
	char number_of_defined_layouts;
	char *options;
	char columns;
	char sides;
	char pagestyle;
	char maxcounter;
	char *top_label_layout;
};

 
class LyXLayoutList {
public:
	LyXLayoutList();
	~LyXLayoutList();
	void Add (LyXLayout *l);
	LyXLayout * ToAr();
	int GetNum();
	void Clean(); 
private:
	struct LyXLayoutL {
		LyXLayout* layout;
		LyXLayoutL *next;
	};
	LyXLayoutL * l;
	LyXLayoutL *eol;
	int num_layouts;
};


class LyXTextClassList {
public:
	LyXTextClassList();
	~LyXTextClassList();
	void Add (LyXTextClass *l);
	void ToAr();
	int GetNum();
	LyXLayout *Style(char textclass, char layout);
	char NumberOfLayout(char textclass, const char* name);
	char* NameOfLayout(char textclass, char layout);
	char NumberOfClass(const char* textclass);
	char* NameOfClass(char number);
	LyXTextClass * TextClass(char textclass);
	int Read (const char *path);
private:
	struct LyXTextClassL {
		LyXTextClass * textclass;
		LyXTextClassL * next;
	}; 
	LyXTextClassL * l;
	LyXTextClassL *eol;
	int num_textclass;
	LyXTextClass * ar;
	LyXTextClass * dummy_textclass;
};


extern LyXTextClassList lyxstyle;
 
#endif
