#
# $Source: /home/nlfm/Working/Zircon/Development/lib/RCS/saverc.tcl,v $
# $Date: 1996/04/07 16:02:42 $
# $Revision: 1.16.1.9 $
#
#
proc putProc {desc name list} {
    foreach l $list {
	regsub -all "\[\[\{\"\$\]" $l {\\\0} l
	puts $desc "$name \"$l\""
    }
}
#
proc saverc {} {
    global zircon defaults cVars confData DEBUG OnCode bindings trust \
      style nicks ircnames ignores
    set rc $zircon(prefdir)/preferences
    if [file exist $rc] {
	file stat $rc st
	set mode $st(mode)
	set rc [glob $rc]
	exec mv $rc $rc.bak
    } {
	set mode 0600
    }
    set desc [open $rc w $mode]
    puts $desc "#\n# Zircon preferences file saved - [getDate]\n#"
    foreach z [array names defaults] {
	if [string compare $zircon($z) $defaults($z)] {
	    puts $desc "set zircon($z) {$zircon($z)}"
	}
    }
    foreach z {soundcmd action} {
	if [info exists zircon($z)] {
	    puts $desc "set zircon($z) {$zircon($z)}"
	}
    }
    foreach z {envnick envname envserver style language look command raw} {
	puts $desc "set zircon($z) $zircon($z)"
    }
    foreach z {cciport wwwclient} {
	if [info exists zircon($z)] { puts $desc "set zircon($) $zircon($z)" }
    }
    puts $desc "#\n# Nicknames\n#"
    putProc $desc nick $nicks
    puts $desc "#\n# IRC Names\n#"
    putProc $desc ircname $ircnames
    puts $desc "#\n# Server information\n#"
    Server :: save $desc
    if {$zircon(host) != {nil}} {
	puts $desc "Server :: select [$zircon(host) name]"
    } {
	mkDialog WARNING .@nodef {Warning} \
	  {You have no default server selected!} {} {OK {}}
    }
    puts $desc "#\n# Service information\n#"
    Service :: save $desc
    puts $desc "#\n# User information\n#"
    User :: save $desc
    puts $desc "#\n# Ignores\n#"
    foreach p $ignores {
	if {[lindex $p 1] != {}} {
	    puts $desc "ignore {[lindex $p 0]} [lindex $p 1]"
	}
    }
    puts $desc "#\n# Channel information\n#"
    Channel :: save $desc
    puts $desc "#\n# Message information\n#"
    Message :: save $desc
    puts $desc "#\n# Notice information\n#"
    Notice :: save $desc
    puts $desc "#\n# Chat information\n#"
    Chat :: save $desc
    puts $desc "#\n# Miscellaneous Control Values\n#"
    foreach x [array names cVars] {
	foreach v $cVars($x) {
	    global $v
	    switch $v {
	    ignores -
	    ircnames -
	    nicks { }
	    actions  { putProc $desc action $actions }
	    leaves  { putProc $desc leave $leaves }
	    signoffs  { putProc $desc signoff $signoffs }
	    aways  { putProc $desc away $aways }
	    default
		{
		    if {[lsearch $confData(single) $v] >= 0} {
			puts $desc "set $v {[set $v]}"
		    } {
			puts $desc "set $v \{"
			foreach x [set $v] { puts $desc "    {$x}" }
			puts $desc "\}"
		    }
		}
	    }
	}
    }
    if $DEBUG { puts $desc "set DEBUG 1" }
    puts $desc "#\n# On Conditions\n#"
    foreach x [array names OnCode] {
	foreach on $OnCode($x) { puts $desc "on $x $on" }
    }
    if ![string match {} $bindings] {
	puts $desc "#\n# Global Bindings\n#"
	foreach on $bindings { puts $desc "zbind {} $on\n" }
    }
    puts $desc "#\n# Trust settings\n#"
    foreach x [array names trust] {
	puts $desc "set trust($x) {$trust($x)}"
    }
    close $desc
}
