# include <stdio.h>
# include <stdlib.h>

# include "hfs.h"
# include "hcwd.h"
# include "hfsutil.h"
# include "glob.h"
# include "hrename.h"

/*
 * NAME:	do_rename()
 * DESCRIPTION:	move/rename files
 */
static
int do_rename(hfsvol *vol, int argc, char *argv[], char *dest)
{
  hfsdirent ent;
  int i, result = 0;

  if (argc > 1 && (hfs_stat(vol, dest, &ent) < 0 ||
		   ! (ent.flags & HFS_ISDIR)))
    {
      fprintf(stderr, "%s: not a directory\n", dest);
      return 1;
    }

  for (i = 0; i < argc; ++i)
    {
      if (hfs_rename(vol, argv[i], dest) < 0)
	{
	  hfs_perror(argv[i]);
	  result = 1;
	}
    }

  return result;
}

/*
 * NAME:	hrename->main()
 * DESCRIPTION:	implement hrename command
 */
int hrename_main(int argc, char *argv[])
{
  mountent *ment;
  hfsvol *vol;
  int fargc;
  char **fargv;
  int result = 0;

  if (argc < 3)
    {
      fprintf(stderr, "Usage: %s hfs-src-path [...] hfs-target-path\n",
	      argv[0]);
      return 1;
    }

  vol = hfs_remount(argv[0], ment = hcwd_getvol(-1));
  if (vol == 0)
    return 1;

  fargv = hfs_glob(vol, argc - 2, &argv[1], &fargc);
  if (fargv == 0)
    {
      fprintf(stderr, "%s: out of memory\n", argv[0]);
      result = 1;
    }
  else
    result = do_rename(vol, fargc, fargv, argv[argc - 1]);

  if (result == 0)
    {
      char *path;

      path = hfs_cwd(vol);
      if (path == 0)
	{
	  hfs_perror("Can't get current HFS directory path");
	  result = 1;
	}
      else if (hcwd_setcwd(ment, path) < 0)
	{
	  perror("Can't set current HFS directory");
	  result = 1;
	}

      if (path)
	free(path);
    }

  if (hfs_umount(vol) < 0 && result == 0)
    {
      hfs_perror("Error closing HFS volume");
      result = 1;
    }

  if (fargv)
    free(fargv);

  return result;
}
