
#include <sys/time.h>
#include <unistd.h>
#include <stdlib.h>

#include "Mac_Resource.h"
#include "sound.h"
#include "fontserv.h"
#include "framebuf.h"
#include "x11_framebuf.h"
#include "vga_framebuf.h"

#include "Maelstrom.h"
#include "Maelstrom_Inline.h"

/* Define true and false, if not already defined */
#ifndef true
#define true	1
#endif
#ifndef false
#define false	0
#endif
#ifndef True
#define True	1
#endif
#ifndef False
#define False	0
#endif

#define SCREEN_WIDTH	640
#define SCREEN_HEIGHT	480

// The Font Server :)
extern FontServ *fontserv;

// The Sound Server *grin*
extern SoundClient *sound;

// The SCREEN!! :)
extern FrameBuf *win;

// Functions from main.cc
extern void CleanUp(void);
extern void Quit(int status);
extern void ReapChild(int sig);
extern void Killed(int sig);
extern void HandleMouse(XEvent *event);
extern void DrawText(int x, int y, BitMap *text, unsigned char color);
extern void UnDrawText(int x, int y, BitMap *text);

// Functions from Utils.cc
extern int    Load_Title(struct Title *title, int title_id);
extern CIcon *GetCIcon(short cicn_id);
extern void   BlitCIcon(int x, int y, CIcon *cicn);
extern void   FreeCIcon(CIcon *cicn);
extern void   SetRect(Rect *R, int left, int top, int right, int bottom);
extern void   OffsetRect(Rect *R, int x, int y);
extern void   InsetRect(Rect *R, int x, int y);

// Functions from shared.cc
extern char  *file2libpath(char *filename);
#if defined(_SGI_SOURCE) || defined(_INCLUDE_HPUX_SOURCE) || defined(__mips)
extern void  usleep(unsigned long usec);
#endif

// Functions from intro.cc
extern int DoInitializations(int fullscreen, int private_cmap, int dofade,
                                                        int gammacorrect);

// Functions from misc.cc
extern void DoSplash(void);
extern void DoAbout(void);

// Functions from make.cc
extern	int	MakeLargeRock(int x, int y);
extern	int	MakeMediumRock(int x, int y);
extern	int	MakeSmallRock(int x, int y);
extern	int	MakeSteelRoid(int x, int y);
extern	int	MakeMultiplier(void);
extern	int	MakeBonus(void);
extern	int	MakePrize(void);
extern	int	MakeHoming(void);
extern	int	MakeGravity(void);
extern	int	MakeNova(void);
extern	int	MakeDamagedShip(void);
extern	int	MakeEnemy(void);
extern  int     NewSprite(BlitPtr aBlit, int changeTime, 
			int xCoord, int yCoord, int xVel, int yVel, long sType);

// Functions from game.cc
extern	void	NewGame(void);
extern	void	SetStar(int which);

// Functions from blit.cc
extern	void	CompositeFrame(void);
extern	void	BlastFrame(void);
extern	void	KillSprite(int which);

// Functions from controls.cc
extern void	LoadControls(void);
extern void	SaveControls(void);
extern void	ConfigureControls(void);
extern int	PollEvent(XEvent *event, int timeout);
extern void	HandleEvents(int timeout);
extern void	ShowDawn(void);

// Functions from scores.cc
extern void	LoadScores(void);
extern void	SaveScores(void);
extern int	ZapHighScores(void);
extern int	GetStartLevel(void);

// Functions from netscore.cc
extern void	RegisterHighScore(Scores high);
extern void	PrintHighScores(void);

// External variables...
// in main.cc : 
extern Bool	gUpdateBuffer;
extern Bool	gRunning;
extern Bool	gFadeBack;
extern int	gNoDelay;
extern long	gStudlyScore;
// in init.cc : 
extern int	gLastHigh;
extern int	gGameOn;
extern int	gShipSprite;
extern Rect	gScrnRect;
extern Rect	gClipRect;
extern int	gStatusLine;
extern int	gTop, gLeft, gBottom, gRight;
extern Sprite  *gSprites[MAX_SPRITES];
extern MPoint	gShotOrigins[SHIP_FRAMES];
extern MPoint	gThrustOrigins[SHIP_FRAMES];
extern MPoint	gVelocityTable[SHIP_FRAMES];
extern ShotPtr	gEnemyShots[MAX_SHOTS];
extern ShotPtr	gTheShots[MAX_SHOTS];
extern StarPtr	gTheStars[MAX_STARS];
extern int	gStarColors[20];
// in blit.cc :
extern int	gThrustWasOn;
extern ULONG	gDeadTime;
extern unsigned char gTheShotColors[];
extern unsigned char gEnemyShotColors[];
// in controls.cc :
extern Controls	controls;
extern Controls	pressed;
extern int	gSoundLevel;
extern int	gGammaCorrect;
// int scores.cc :
extern Scores	hScores[];

// -- Variables specific to each game 
// in main.cc : 
extern int	gStartLives;
extern int	gStartLevel;
// in init.cc : 
extern int	gFrameReady;
extern ULONG	gLastKeyPolled;
extern ULONG	gLastDrawn;
extern int	gNumSprites;
// in make.cc :
extern ULONG	gPrizeTime;
extern ULONG	gBonusTime;
extern ULONG	gDamagedTime;
// in scores.cc :
extern long	gScore;
// in game.cc :
extern ShotPtr	gTheShots[MAX_SHOTS];
extern ShotPtr	gEnemyShots[MAX_SHOTS];
extern int	gNumRoids;
extern ULONG	gBoomDelay;
extern ULONG	gLastBoom;
extern int	gBoomPhase;
extern int	gThrustOn;
extern int	gNumRocks;
extern int	gLives;
extern ULONG	gLastStar;
extern long	gBonus;
extern ULONG	gLastBonus;
extern ULONG	gWaveStarted;
extern ULONG	gWhenDone;
extern ULONG	gOurTicks;

extern int	gMultiplierShown;
extern ULONG	gMultTime;
extern ULONG	gWhenMult;
extern int	gMultFactor;

extern int	gPrizeShown;
extern ULONG	gWhenPrize;

extern int	gBonusShown;
extern ULONG	gWhenBonus;

extern ULONG	gWhenHoming;
extern ULONG	gWhenGrav;
extern ULONG	gWhenDamaged;

extern int	gAirBrakes;
extern int	gAutoFire;
extern int	gLuckOfTheIrish;
extern int	gLongFire;
extern int	gTripleFire;

extern int	gShieldOn;
extern int	gShieldLevel;
extern int	gShaking;
extern ULONG	gWhenNova;
extern ULONG	gShakeTime;
extern int	gNovaBlast;
extern int	gNovaFlag;
extern ULONG	gShieldTime;
extern ULONG	gFreezeTime;
extern ULONG	gEnemyFireTime;

extern int	gWave;
extern int	gEnemySprite;
extern ULONG	gWhenEnemy;


// Sound resource definitions...
#define gShotSound	100
#define gMultiplier	101
#define gExplosionSound	102
#define gShipHitSound	103
#define gBoom1		104
#define gBoom2		105
#define gMultiplierGone	106
#define gMultShotSound	107
#define gSteelHit	108
#define gBonk		109
#define gRiff		110
#define gPrizeAppears	111
#define gGotPrize	112
#define gGameOver	113
#define gNewLife	114
#define gBonusAppears	115
#define gBonusShot	116
#define gNoBonus	117
#define gGravAppears	118
#define gHomingAppears	119
#define gShieldOnSound	120
#define gNoShieldSound	121
#define gNovaAppears	122
#define gNovaBoom	123
#define gLuckySound	124
#define gDamagedAppears	125
#define gSavedShipSound	126
#define gFunk		127
#define gEnemyAppears	128
#define gPrettyGood	131
#define gThrusterSound	132
#define gEnemyFire	133
#define gFreezeSound	134
#define gIdiotSound	135
#define gPauseSound	136


/* -- The blit'ers we use */
extern BlitPtr	gRock1R, gRock2R, gRock3R, gDamagedShip;
extern BlitPtr	gRock1L, gRock2L, gRock3L, gShipExplosion;
extern BlitPtr	gPlayerShip, gExplosion, gNova, gEnemyShip, gEnemyShip2;
extern BlitPtr	gMult2, gMult3, gMult4, gMult5, gSteelRoidL;
extern BlitPtr	gSteelRoidR, gPrize, gBonusBlit, gPointBlit;
extern BlitPtr	gVortexBlit, gMineBlitL, gMineBlitR, gShieldBlit;
extern BlitPtr	gThrust1, gThrust2, gShrapnel1, gShrapnel2;

/* -- The prize CICN's */

extern CIconPtr gAutoFireIcon, gAirBrakesIcon, gMult2Icon, gMult3Icon;
extern CIconPtr gMult4Icon, gMult5Icon, gLuckOfTheIrishIcon, gLongFireIcon;
extern CIconPtr gTripleFireIcon, gKeyIcon, gShieldIcon;
